/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.ext.mssql;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.dbunit.DatabaseUnitException;
import org.dbunit.database.DatabaseConfig;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.DefaultDataSet;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableIterator;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.filter.IColumnFilter;
import org.dbunit.operation.AbstractOperation;
import org.dbunit.operation.CompositeOperation;
import org.dbunit.operation.DatabaseOperation;
import org.dbunit.operation.ExclusiveTransactionException;

public class InsertIdentityOperation
extends AbstractOperation {
    public static final String PROPERTY_IDENTITY_COLUMN_FILTER = "http://www.dbunit.org/properties/mssql/identityColumnFilter";
    public static final DatabaseOperation INSERT = new InsertIdentityOperation(DatabaseOperation.INSERT);
    public static final DatabaseOperation CLEAN_INSERT = new CompositeOperation(DatabaseOperation.DELETE_ALL, new InsertIdentityOperation(DatabaseOperation.INSERT));
    public static final DatabaseOperation REFRESH = new InsertIdentityOperation(DatabaseOperation.REFRESH);
    private static final IColumnFilter DEFAULT_IDENTITY_FILTER = new IColumnFilter(){

        public boolean accept(String tableName, Column column) {
            return column.getSqlTypeName().endsWith("identity");
        }
    };
    private final DatabaseOperation _operation;

    public InsertIdentityOperation(DatabaseOperation operation) {
        this._operation = operation;
    }

    private boolean hasIdentityColumn(ITableMetaData metaData, IDatabaseConnection connection) throws DataSetException {
        DatabaseConfig config = connection.getConfig();
        IColumnFilter identityFilter = (IColumnFilter)config.getProperty(PROPERTY_IDENTITY_COLUMN_FILTER);
        if (identityFilter == null) {
            identityFilter = DEFAULT_IDENTITY_FILTER;
        }
        Column[] columns = metaData.getColumns();
        int i = 0;
        while (i < columns.length) {
            if (identityFilter.accept(metaData.getTableName(), columns[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void execute(IDatabaseConnection connection, IDataSet dataSet) throws DatabaseUnitException, SQLException {
        Connection jdbcConnection = connection.getConnection();
        Statement statement = jdbcConnection.createStatement();
        try {
            IDataSet databaseDataSet = connection.createDataSet();
            if (!jdbcConnection.getAutoCommit()) {
                throw new ExclusiveTransactionException();
            }
            jdbcConnection.setAutoCommit(false);
            ITableIterator iterator = dataSet.iterator();
            while (iterator.next()) {
                block8: {
                    StringBuffer sqlBuffer;
                    Object var13_12;
                    ITable table = iterator.getTable();
                    String tableName = table.getTableMetaData().getTableName();
                    ITableMetaData metaData = databaseDataSet.getTableMetaData(tableName);
                    boolean hasIdentityColumn = this.hasIdentityColumn(metaData, connection);
                    if (hasIdentityColumn) {
                        StringBuffer sqlBuffer2 = new StringBuffer(128);
                        sqlBuffer2.append("SET IDENTITY_INSERT ");
                        sqlBuffer2.append(this.getQualifiedName(connection.getSchema(), metaData.getTableName(), connection));
                        sqlBuffer2.append(" ON");
                        statement.execute(sqlBuffer2.toString());
                    }
                    try {
                        this._operation.execute(connection, new DefaultDataSet(table));
                        var13_12 = null;
                        if (!hasIdentityColumn) break block8;
                        sqlBuffer = new StringBuffer(128);
                        sqlBuffer.append("SET IDENTITY_INSERT ");
                    }
                    catch (Throwable throwable) {
                        var13_12 = null;
                        if (hasIdentityColumn) {
                            sqlBuffer = new StringBuffer(128);
                            sqlBuffer.append("SET IDENTITY_INSERT ");
                            sqlBuffer.append(this.getQualifiedName(connection.getSchema(), metaData.getTableName(), connection));
                            sqlBuffer.append(" OFF");
                            statement.execute(sqlBuffer.toString());
                        }
                        jdbcConnection.commit();
                        throw throwable;
                    }
                    sqlBuffer.append(this.getQualifiedName(connection.getSchema(), metaData.getTableName(), connection));
                    sqlBuffer.append(" OFF");
                    statement.execute(sqlBuffer.toString());
                }
                jdbcConnection.commit();
                {
                }
            }
            Object var16_15 = null;
        }
        catch (Throwable throwable) {
            Object var16_16 = null;
            jdbcConnection.setAutoCommit(true);
            statement.close();
            throw throwable;
        }
        jdbcConnection.setAutoCommit(true);
        statement.close();
    }
}

