/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.ext.oracle;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.dbunit.dataset.datatype.TypeCastException;
import org.dbunit.ext.oracle.OracleClobDataType;

public class OracleNClobDataType
extends OracleClobDataType {
    protected static final Short FORM_NCHAR = new Short(2);

    public void setSqlValue(Object value, int column, PreparedStatement statement) throws SQLException, TypeCastException {
        try {
            Class<?> statementClass = Class.forName("oracle.jdbc.OraclePreparedStatement");
            Method formOfUse = statementClass.getMethod("setFormOfUse", Integer.TYPE, Short.TYPE);
            formOfUse.invoke((Object)statement, new Integer(column), FORM_NCHAR);
        }
        catch (IllegalAccessException e) {
            throw new TypeCastException(value, this, e);
        }
        catch (NoSuchMethodException e) {
            throw new TypeCastException(value, this, e);
        }
        catch (InvocationTargetException e) {
            throw new TypeCastException(value, this, e.getTargetException());
        }
        catch (ClassNotFoundException e) {
            throw new TypeCastException(value, this, e);
        }
        statement.setObject(column, this.getClob(value, statement.getConnection()));
    }
}

