/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.util.concurrent;

import org.dbunit.util.concurrent.BoundedChannel;
import org.dbunit.util.concurrent.LinkedNode;

public class SynchronousChannel
implements BoundedChannel {
    protected static final Object CANCELLED = new Object();
    protected final Queue waitingPuts = new Queue();
    protected final Queue waitingTakes = new Queue();

    public int capacity() {
        return 0;
    }

    public Object peek() {
        return null;
    }

    public void put(Object x) throws InterruptedException {
        LinkedNode linkedNode;
        LinkedNode item;
        if (x == null) {
            throw new IllegalArgumentException();
        }
        while (true) {
            LinkedNode slot;
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            item = null;
            SynchronousChannel synchronousChannel = this;
            synchronized (synchronousChannel) {
                slot = this.waitingTakes.deq();
                if (slot == null) {
                    item = new LinkedNode(x);
                    this.waitingPuts.enq(item);
                }
            }
            if (slot == null) break;
            linkedNode = slot;
            synchronized (linkedNode) {
                if (slot.value != CANCELLED) {
                    slot.value = x;
                    slot.notify();
                    return;
                }
            }
        }
        linkedNode = item;
        synchronized (linkedNode) {
            try {
                while (item.value != null) {
                    item.wait();
                }
                return;
            }
            catch (InterruptedException ie) {
                if (item.value == null) {
                    Thread.currentThread().interrupt();
                    return;
                }
                item.value = CANCELLED;
                throw ie;
            }
        }
    }

    public Object take() throws InterruptedException {
        Object x;
        LinkedNode linkedNode;
        LinkedNode slot;
        while (true) {
            LinkedNode item;
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            slot = null;
            SynchronousChannel synchronousChannel = this;
            synchronized (synchronousChannel) {
                item = this.waitingPuts.deq();
                if (item == null) {
                    slot = new LinkedNode();
                    this.waitingTakes.enq(slot);
                }
            }
            if (item == null) break;
            linkedNode = item;
            synchronized (linkedNode) {
                x = item.value;
                if (x != CANCELLED) {
                    item.value = null;
                    item.next = null;
                    item.notify();
                    Object object = x;
                    return object;
                }
            }
        }
        linkedNode = slot;
        synchronized (linkedNode) {
            try {
                while (true) {
                    if ((x = slot.value) != null) {
                        slot.value = null;
                        slot.next = null;
                        Object object = x;
                        return object;
                    }
                    slot.wait();
                }
            }
            catch (InterruptedException ie) {
                Object x2 = slot.value;
                if (x2 != null) {
                    slot.value = null;
                    slot.next = null;
                    Thread.currentThread().interrupt();
                    Object object = x2;
                    return object;
                }
                slot.value = CANCELLED;
                throw ie;
            }
        }
    }

    public boolean offer(Object x, long msecs) throws InterruptedException {
        LinkedNode item;
        if (x == null) {
            throw new IllegalArgumentException();
        }
        long waitTime = msecs;
        long startTime = 0L;
        do {
            LinkedNode slot;
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            item = null;
            SynchronousChannel synchronousChannel = this;
            synchronized (synchronousChannel) {
                slot = this.waitingTakes.deq();
                if (slot == null) {
                    if (waitTime <= 0L) {
                        boolean bl = false;
                        return bl;
                    }
                    item = new LinkedNode(x);
                    this.waitingPuts.enq(item);
                }
            }
            if (slot != null) {
                LinkedNode linkedNode = slot;
                synchronized (linkedNode) {
                    if (slot.value != CANCELLED) {
                        slot.value = x;
                        slot.notify();
                        boolean bl = true;
                        return bl;
                    }
                }
            }
            long now = System.currentTimeMillis();
            if (startTime == 0L) {
                startTime = now;
                continue;
            }
            waitTime = msecs - (now - startTime);
        } while (item == null);
        LinkedNode linkedNode = item;
        synchronized (linkedNode) {
            try {
                while (true) {
                    if (item.value == null) {
                        boolean bl = true;
                        return bl;
                    }
                    if (waitTime <= 0L) {
                        item.value = CANCELLED;
                        boolean bl = false;
                        return bl;
                    }
                    item.wait(waitTime);
                    waitTime = msecs - (System.currentTimeMillis() - startTime);
                }
            }
            catch (InterruptedException ie) {
                if (item.value == null) {
                    Thread.currentThread().interrupt();
                    boolean bl = true;
                    return bl;
                }
                item.value = CANCELLED;
                throw ie;
            }
        }
    }

    public Object poll(long msecs) throws InterruptedException {
        LinkedNode slot;
        long waitTime = msecs;
        long startTime = 0L;
        do {
            LinkedNode item;
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            slot = null;
            SynchronousChannel synchronousChannel = this;
            synchronized (synchronousChannel) {
                item = this.waitingPuts.deq();
                if (item == null) {
                    if (waitTime <= 0L) {
                        Object var10_8 = null;
                        return var10_8;
                    }
                    slot = new LinkedNode();
                    this.waitingTakes.enq(slot);
                }
            }
            if (item != null) {
                LinkedNode linkedNode = item;
                synchronized (linkedNode) {
                    Object x = item.value;
                    if (x != CANCELLED) {
                        item.value = null;
                        item.next = null;
                        item.notify();
                        Object object = x;
                        return object;
                    }
                }
            }
            long now = System.currentTimeMillis();
            if (startTime == 0L) {
                startTime = now;
                continue;
            }
            waitTime = msecs - (now - startTime);
        } while (slot == null);
        LinkedNode linkedNode = slot;
        synchronized (linkedNode) {
            try {
                while (true) {
                    Object x;
                    if ((x = slot.value) != null) {
                        slot.value = null;
                        slot.next = null;
                        Object object = x;
                        return object;
                    }
                    if (waitTime <= 0L) {
                        slot.value = CANCELLED;
                        Object var14_18 = null;
                        return var14_18;
                    }
                    slot.wait(waitTime);
                    waitTime = msecs - (System.currentTimeMillis() - startTime);
                }
            }
            catch (InterruptedException ie) {
                Object x = slot.value;
                if (x != null) {
                    slot.value = null;
                    slot.next = null;
                    Thread.currentThread().interrupt();
                    Object object = x;
                    return object;
                }
                slot.value = CANCELLED;
                throw ie;
            }
        }
    }

    protected static class Queue {
        protected LinkedNode head;
        protected LinkedNode last;

        protected Queue() {
        }

        protected void enq(LinkedNode p) {
            this.last = this.last == null ? (this.head = p) : (this.last.next = p);
        }

        protected LinkedNode deq() {
            LinkedNode p = this.head;
            if (p != null && (this.head = p.next) == null) {
                this.last = null;
            }
            return p;
        }
    }
}

