/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.util.xml;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Stack;

public class XmlWriter {
    private Writer out;
    private String encoding;
    private Stack stack = new Stack();
    private StringBuffer attrs;
    private boolean empty;
    private boolean closed = true;
    private boolean pretty = true;
    private boolean wroteText = false;
    private String indent = "  ";
    private String newline = "\n";

    public XmlWriter(Writer writer) {
        this(writer, null);
    }

    public XmlWriter(Writer writer, String encoding) {
        this.setWriter(writer, encoding);
    }

    public void enablePrettyPrint(boolean enable) {
        this.pretty = enable;
    }

    public void setIndent(String indent) {
        this.indent = indent;
    }

    public void setNewline(String newline) {
        this.newline = newline;
    }

    public XmlWriter writeElementWithText(String name, String text) throws IOException {
        this.writeElement(name);
        this.writeText(text);
        return this.endElement();
    }

    public XmlWriter writeEmptyElement(String name) throws IOException {
        this.writeElement(name);
        return this.endElement();
    }

    public XmlWriter writeElement(String name) throws IOException {
        return this.openElement(name);
    }

    private XmlWriter openElement(String name) throws IOException {
        boolean wasClosed = this.closed;
        this.closeOpeningTag();
        this.closed = false;
        if (this.pretty) {
            if (!wasClosed || this.wroteText) {
                this.out.write(this.newline);
            }
            int i = 0;
            while (i < this.stack.size()) {
                this.out.write(this.indent);
                ++i;
            }
        }
        this.out.write("<");
        this.out.write(name);
        this.stack.add(name);
        this.empty = true;
        this.wroteText = false;
        return this;
    }

    private void closeOpeningTag() throws IOException {
        if (!this.closed) {
            this.writeAttributes();
            this.closed = true;
            this.out.write(">");
        }
    }

    private void writeAttributes() throws IOException {
        if (this.attrs != null) {
            this.out.write(this.attrs.toString());
            this.attrs.setLength(0);
            this.empty = false;
        }
    }

    public XmlWriter writeAttribute(String attr, String value) throws IOException {
        if (this.attrs == null) {
            this.attrs = new StringBuffer();
        }
        this.attrs.append(" ");
        this.attrs.append(attr);
        this.attrs.append("=\"");
        this.attrs.append(this.escapeXml(value));
        this.attrs.append("\"");
        return this;
    }

    public XmlWriter endElement() throws IOException {
        if (this.stack.empty()) {
            throw new IOException("Called endElement too many times. ");
        }
        String name = (String)this.stack.pop();
        if (name != null) {
            if (this.empty) {
                this.writeAttributes();
                this.out.write("/>");
            } else {
                if (this.pretty && !this.wroteText) {
                    int i = 0;
                    while (i < this.stack.size()) {
                        this.out.write(this.indent);
                        ++i;
                    }
                }
                this.out.write("</");
                this.out.write(name);
                this.out.write(">");
            }
            if (this.pretty) {
                this.out.write(this.newline);
            }
            this.empty = false;
            this.closed = true;
            this.wroteText = false;
        }
        return this;
    }

    public void close() throws IOException {
        this.out.flush();
        if (!this.stack.empty()) {
            throw new IOException("Tags are not all closed. Possibly, " + this.stack.pop() + " is unclosed. ");
        }
    }

    public XmlWriter writeText(String text) throws IOException {
        this.closeOpeningTag();
        this.empty = false;
        this.wroteText = true;
        this.out.write(this.escapeXml(text));
        return this;
    }

    public XmlWriter writeCData(String cdata) throws IOException {
        this.closeOpeningTag();
        this.empty = false;
        this.wroteText = true;
        this.out.write("<![CDATA[");
        this.out.write(cdata);
        this.out.write("]]>");
        return this;
    }

    public XmlWriter writeComment(String comment) throws IOException {
        this.writeChunk("<!-- " + comment + " -->");
        return this;
    }

    private void writeChunk(String data) throws IOException {
        this.closeOpeningTag();
        this.empty = false;
        if (this.pretty && !this.wroteText) {
            int i = 0;
            while (i < this.stack.size()) {
                this.out.write(this.indent);
                ++i;
            }
        }
        this.out.write(data);
        if (this.pretty) {
            this.out.write(this.newline);
        }
    }

    public static void main(String[] args) throws IOException {
        XmlWriter.test1();
        XmlWriter.test2();
    }

    public static void test1() throws IOException {
        StringWriter writer = new StringWriter();
        XmlWriter xmlwriter = new XmlWriter(writer);
        xmlwriter.writeElement("person").writeAttribute("name", "fred").writeAttribute("age", "12").writeElement("phone").writeText("4254343").endElement().writeElement("friends").writeElement("bob").endElement().writeElement("jim").endElement().endElement().endElement();
        xmlwriter.close();
        System.err.println(((Object)writer).toString());
    }

    public static void test2() throws IOException {
        StringWriter writer = new StringWriter();
        XmlWriter xmlwriter = new XmlWriter(writer);
        xmlwriter.writeComment("Example of XmlWriter running");
        xmlwriter.writeElement("person");
        xmlwriter.writeAttribute("name", "fred");
        xmlwriter.writeAttribute("age", "12");
        xmlwriter.writeElement("phone");
        xmlwriter.writeText("4254343");
        xmlwriter.endElement();
        xmlwriter.writeComment("Examples of empty tags");
        xmlwriter.writeElement("friends");
        xmlwriter.writeEmptyElement("bob");
        xmlwriter.writeEmptyElement("jim");
        xmlwriter.endElement();
        xmlwriter.writeElementWithText("foo", "This is an example.");
        xmlwriter.endElement();
        xmlwriter.close();
        System.err.println(((Object)writer).toString());
    }

    private String escapeXml(String str) {
        str = this.replace(str, "&", "&amp;");
        str = this.replace(str, "<", "&lt;");
        str = this.replace(str, ">", "&gt;");
        str = this.replace(str, "\"", "&quot;");
        str = this.replace(str, "'", "&apos;");
        return str;
    }

    private String replace(String value, String original, String replacement) {
        StringBuffer buffer = null;
        int startIndex = 0;
        int lastEndIndex = 0;
        while (true) {
            if ((startIndex = value.indexOf(original, lastEndIndex)) == -1) {
                if (buffer == null) break;
                buffer.append(value.substring(lastEndIndex));
                break;
            }
            if (buffer == null) {
                buffer = new StringBuffer((int)((double)original.length() * 1.5));
            }
            buffer.append(value.substring(lastEndIndex, startIndex));
            buffer.append(replacement);
            lastEndIndex = startIndex + original.length();
        }
        return buffer == null ? value : buffer.toString();
    }

    private void setEncoding(String encoding) {
        if (encoding == null && this.out instanceof OutputStreamWriter) {
            encoding = ((OutputStreamWriter)this.out).getEncoding();
        }
        if (encoding != null) {
            if ("UTF8".equals(encoding = encoding.toUpperCase())) {
                encoding = "UTF-8";
            } else if ("US-ASCII".equals(encoding) || "ASCII".equals(encoding)) {
                encoding = "US-ASCII";
            } else if ("ISO-8859-1".equals(encoding) || "8859_1".equals(encoding) || "ISO8859_1".equals(encoding)) {
                encoding = "ISO-8859-1";
            } else if ("UNICODE".equals(encoding) || "UNICODE-BIG".equals(encoding) || "UNICODE-LITTLE".equals(encoding)) {
                encoding = "UTF-16";
            }
        }
        this.encoding = encoding;
    }

    public final void setWriter(Writer writer, String encoding) {
        if (this.out != null) {
            throw new IllegalStateException("can't change stream in mid course");
        }
        this.out = writer;
        if (this.out != null) {
            this.setEncoding(encoding);
        }
    }

    public XmlWriter writeDeclaration() throws IOException {
        if (this.encoding != null) {
            this.out.write("<?xml version='1.0'");
            this.out.write(" encoding='" + this.encoding + "'");
            this.out.write("?>");
            this.out.write(this.newline);
        }
        return this;
    }

    public XmlWriter writeDoctype(String systemId, String publicId) throws IOException {
        if (systemId != null || publicId != null) {
            this.out.write("<!DOCTYPE dataset");
            if (systemId != null) {
                this.out.write(" SYSTEM \"");
                this.out.write(systemId);
                this.out.write("\"");
            }
            if (publicId != null) {
                this.out.write(" PUBLIC \"");
                this.out.write(publicId);
                this.out.write("\"");
            }
            this.out.write(">");
            this.out.write(this.newline);
        }
        return this;
    }
}

