/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.wicket.ioc;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import org.jboss.seam.util.Reflections;
import org.jboss.seam.wicket.ioc.BijectedAttribute;
import org.jboss.seam.wicket.ioc.InjectedField;

public abstract class BijectedField<T extends Annotation>
extends InjectedField<T>
implements BijectedAttribute<T> {
    private String contextVariableName = this.getSpecifiedContextVariableName();

    public BijectedField(Field field, T annotation) {
        super(field, annotation);
        if (this.contextVariableName == null || "".equals(this.contextVariableName)) {
            this.contextVariableName = field.getName();
        }
    }

    @Override
    public Object get(Object bean) {
        this.field.setAccessible(true);
        return Reflections.getAndWrap((Field)this.field, (Object)bean);
    }

    @Override
    public String getContextVariableName() {
        return this.contextVariableName;
    }

    protected abstract String getSpecifiedContextVariableName();

    @Override
    public String toString() {
        return "BijectedField(" + Reflections.toString((Member)this.field) + ')';
    }
}

