/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.jboss.ejb.client.SecurityActions;
import org.jboss.logging.Logger;

class EJBClientPropertiesLoader {
    private static final Logger logger = Logger.getLogger(EJBClientPropertiesLoader.class);
    private static final String EJB_CLIENT_PROPS_FILE_SYS_PROPERTY = "jboss.ejb.client.properties.file.path";
    private static final String EJB_CLIENT_PROPS_SKIP_CLASSLOADER_SCAN_SYS_PROPERTY = "jboss.ejb.client.properties.skip.classloader.scan";
    private static final String EJB_CLIENT_PROPS_FILE_NAME = "jboss-ejb-client.properties";

    EJBClientPropertiesLoader() {
    }

    static Properties loadEJBClientProperties() {
        String ejbClientPropsFilePath = SecurityActions.getSystemProperty(EJB_CLIENT_PROPS_FILE_SYS_PROPERTY);
        if (ejbClientPropsFilePath != null) {
            FileInputStream fileStream;
            try {
                fileStream = new FileInputStream(ejbClientPropsFilePath);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException("Failed to find EJB client configuration file specified in jboss.ejb.client.properties.file.path system property", e);
            }
            Properties ejbClientProps = new Properties();
            try {
                ejbClientProps.load(fileStream);
                return ejbClientProps;
            }
            catch (IOException e) {
                throw new RuntimeException("Error reading EJB client properties file " + ejbClientPropsFilePath, e);
            }
        }
        String skipClasspathScan = SecurityActions.getSystemProperty(EJB_CLIENT_PROPS_SKIP_CLASSLOADER_SCAN_SYS_PROPERTY);
        if (skipClasspathScan != null && Boolean.valueOf(skipClasspathScan.trim()).booleanValue()) {
            logger.debug((Object)"jboss.ejb.client.properties.skip.classloader.scan system property is set. Skipping classloader search for jboss-ejb-client.properties");
            return null;
        }
        ClassLoader classLoader = EJBClientPropertiesLoader.getClientClassLoader();
        logger.debug((Object)("Looking for jboss-ejb-client.properties using classloader " + classLoader));
        InputStream clientPropsInputStream = classLoader.getResourceAsStream(EJB_CLIENT_PROPS_FILE_NAME);
        if (clientPropsInputStream != null) {
            logger.debug((Object)("Found jboss-ejb-client.properties using classloader " + classLoader));
            Properties clientProps = new Properties();
            try {
                clientProps.load(clientPropsInputStream);
                return clientProps;
            }
            catch (IOException e) {
                throw new RuntimeException("Could not load jboss-ejb-client.properties", e);
            }
        }
        return null;
    }

    private static ClassLoader getClientClassLoader() {
        ClassLoader tccl = SecurityActions.getContextClassLoader();
        if (tccl != null) {
            return tccl;
        }
        return EJBClientPropertiesLoader.class.getClassLoader();
    }
}

