/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject;

import com.google.inject.BindingAnnotation;
import com.google.inject.ErrorHandler;
import com.google.inject.TypeLiteral;
import com.google.inject.util.Annotations;
import com.google.inject.util.Objects;
import com.google.inject.util.StackTraceElements;
import com.google.inject.util.ToStringBuilder;
import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.lang.reflect.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Key<T> {
    final AnnotationStrategy annotationStrategy;
    final TypeLiteral<T> typeLiteral;
    final int hashCode;
    static final AnnotationStrategy NULL_STRATEGY = new AnnotationStrategy(){

        @Override
        public boolean hasAttributes() {
            return false;
        }

        @Override
        public AnnotationStrategy withoutAttributes() {
            throw new UnsupportedOperationException("Key already has no attributes.");
        }

        @Override
        public Annotation getAnnotation() {
            return null;
        }

        @Override
        public Class<? extends Annotation> getAnnotationType() {
            return null;
        }

        public boolean equals(Object o) {
            return o == NULL_STRATEGY;
        }

        public int hashCode() {
            return 0;
        }

        public String toString() {
            return "[none]";
        }
    };

    protected Key(Class<? extends Annotation> annotationType) {
        this.annotationStrategy = Key.strategyFor(annotationType);
        this.typeLiteral = TypeLiteral.fromSuperclassTypeParameter(this.getClass());
        this.hashCode = this.computeHashCode();
    }

    protected Key(Annotation annotation) {
        this.annotationStrategy = Key.strategyFor(annotation);
        this.typeLiteral = TypeLiteral.fromSuperclassTypeParameter(this.getClass());
        this.hashCode = this.computeHashCode();
    }

    protected Key() {
        this.annotationStrategy = NULL_STRATEGY;
        this.typeLiteral = TypeLiteral.fromSuperclassTypeParameter(this.getClass());
        this.hashCode = this.computeHashCode();
    }

    private Key(Type type, AnnotationStrategy annotationStrategy) {
        this.annotationStrategy = annotationStrategy;
        this.typeLiteral = TypeLiteral.get(type);
        this.hashCode = this.computeHashCode();
    }

    private Key(TypeLiteral<T> typeLiteral, AnnotationStrategy annotationStrategy) {
        this.annotationStrategy = annotationStrategy;
        this.typeLiteral = typeLiteral;
        this.hashCode = this.computeHashCode();
    }

    private int computeHashCode() {
        return this.typeLiteral.hashCode() * 31 + this.annotationStrategy.hashCode();
    }

    public TypeLiteral<T> getTypeLiteral() {
        return this.typeLiteral;
    }

    public Class<? extends Annotation> getAnnotationType() {
        return this.annotationStrategy.getAnnotationType();
    }

    public Annotation getAnnotation() {
        return this.annotationStrategy.getAnnotation();
    }

    boolean hasAnnotationType() {
        return this.annotationStrategy.getAnnotationType() != null;
    }

    String getAnnotationName() {
        Annotation annotation = this.annotationStrategy.getAnnotation();
        if (annotation != null) {
            return ((Object)annotation).toString();
        }
        return this.annotationStrategy.getAnnotationType().toString();
    }

    public int hashCode() {
        return this.hashCode;
    }

    Class<? super T> getRawType() {
        return this.typeLiteral.getRawType();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Key)) {
            return false;
        }
        Key other = (Key)o;
        return this.annotationStrategy.equals(other.annotationStrategy) && this.typeLiteral.equals(other.typeLiteral);
    }

    public String toString() {
        return new ToStringBuilder(Key.class).add("type", this.typeLiteral).add("annotation", this.annotationStrategy).toString();
    }

    static <T> Key<T> get(Class<T> type, AnnotationStrategy annotationStrategy) {
        return new SimpleKey(type, annotationStrategy);
    }

    public static <T> Key<T> get(Class<T> type) {
        return new SimpleKey(type, NULL_STRATEGY);
    }

    public static <T> Key<T> get(Class<T> type, Class<? extends Annotation> annotationType) {
        return new SimpleKey(type, Key.strategyFor(annotationType));
    }

    public static <T> Key<T> get(Class<T> type, Annotation annotation) {
        return new SimpleKey(type, Key.strategyFor(annotation));
    }

    public static Key<?> get(Type type) {
        return new SimpleKey(type, NULL_STRATEGY);
    }

    public static Key<?> get(Type type, Class<? extends Annotation> annotationType) {
        return new SimpleKey(type, Key.strategyFor(annotationType));
    }

    public static Key<?> get(Type type, Annotation annotation) {
        return new SimpleKey(type, Key.strategyFor(annotation));
    }

    public static <T> Key<T> get(TypeLiteral<T> typeLiteral) {
        return new SimpleKey(typeLiteral, NULL_STRATEGY);
    }

    public static <T> Key<T> get(TypeLiteral<T> typeLiteral, Class<? extends Annotation> annotationType) {
        return new SimpleKey(typeLiteral, Key.strategyFor(annotationType));
    }

    public static <T> Key<T> get(TypeLiteral<T> typeLiteral, Annotation annotation) {
        return new SimpleKey(typeLiteral, Key.strategyFor(annotation));
    }

    static Key<?> get(Type type, Member member, Annotation[] annotations, ErrorHandler errorHandler) {
        Annotation found = null;
        for (Annotation annotation : annotations) {
            if (annotation.annotationType().getAnnotation(BindingAnnotation.class) == null) continue;
            if (found == null) {
                found = annotation;
                continue;
            }
            errorHandler.handle(StackTraceElements.forMember(member), "Found more than one annotation annotated with @BindingAnnotation: %s and %s", found, annotation);
        }
        Key<?> key = found == null ? Key.get(type) : Key.get(type, found);
        return key;
    }

    <T> Key<T> ofType(Class<T> type) {
        return new SimpleKey(type, this.annotationStrategy);
    }

    Key<?> ofType(Type type) {
        return new SimpleKey(type, this.annotationStrategy);
    }

    boolean hasAttributes() {
        return this.annotationStrategy.hasAttributes();
    }

    Key<T> withoutAttributes() {
        return new SimpleKey(this.typeLiteral, this.annotationStrategy.withoutAttributes());
    }

    static boolean isMarker(Class<? extends Annotation> annotationType) {
        return annotationType.getDeclaredMethods().length == 0;
    }

    static AnnotationStrategy strategyFor(Annotation annotation) {
        Objects.nonNull(annotation, "annotation");
        Class<? extends Annotation> annotationType = annotation.annotationType();
        Key.ensureRetainedAtRuntime(annotationType);
        Key.ensureIsBindingAnnotation(annotationType);
        return new AnnotationInstanceStrategy(annotation);
    }

    static AnnotationStrategy strategyFor(Class<? extends Annotation> annotationType) {
        Objects.nonNull(annotationType, "annotation type");
        Key.ensureRetainedAtRuntime(annotationType);
        Key.ensureIsBindingAnnotation(annotationType);
        return new AnnotationTypeStrategy(annotationType, null);
    }

    private static void ensureRetainedAtRuntime(Class<? extends Annotation> annotationType) {
        if (!Annotations.isRetainedAtRuntime(annotationType)) {
            throw new IllegalArgumentException(annotationType.getName() + " is not retained at runtime." + " Please annotate it with @Retention(RUNTIME).");
        }
    }

    private static void ensureIsBindingAnnotation(Class<? extends Annotation> annotationType) {
        if (!Key.isBindingAnnotation(annotationType)) {
            throw new IllegalArgumentException(annotationType.getName() + " is not a binding annotation." + " Please annotate it with @BindingAnnotation.");
        }
    }

    static boolean isBindingAnnotation(Annotation annotation) {
        return Key.isBindingAnnotation(annotation.annotationType());
    }

    static boolean isBindingAnnotation(Class<? extends Annotation> annotationType) {
        return annotationType.isAnnotationPresent(BindingAnnotation.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class AnnotationTypeStrategy
    implements AnnotationStrategy {
        final Class<? extends Annotation> annotationType;
        final Annotation annotation;

        AnnotationTypeStrategy(Class<? extends Annotation> annotationType, Annotation annotation) {
            this.annotationType = Objects.nonNull(annotationType, "annotation type");
            this.annotation = annotation;
        }

        @Override
        public boolean hasAttributes() {
            return false;
        }

        @Override
        public AnnotationStrategy withoutAttributes() {
            throw new UnsupportedOperationException("Key already has no attributes.");
        }

        @Override
        public Annotation getAnnotation() {
            return this.annotation;
        }

        @Override
        public Class<? extends Annotation> getAnnotationType() {
            return this.annotationType;
        }

        public boolean equals(Object o) {
            if (!(o instanceof AnnotationTypeStrategy)) {
                return false;
            }
            AnnotationTypeStrategy other = (AnnotationTypeStrategy)o;
            return this.annotationType.equals(other.annotationType);
        }

        public int hashCode() {
            return this.annotationType.hashCode();
        }

        public String toString() {
            return "@" + this.annotationType.getName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class AnnotationInstanceStrategy
    implements AnnotationStrategy {
        final Annotation annotation;

        AnnotationInstanceStrategy(Annotation annotation) {
            this.annotation = Objects.nonNull(annotation, "annotation");
        }

        @Override
        public boolean hasAttributes() {
            return true;
        }

        @Override
        public AnnotationStrategy withoutAttributes() {
            return new AnnotationTypeStrategy(this.getAnnotationType(), this.annotation);
        }

        @Override
        public Annotation getAnnotation() {
            return this.annotation;
        }

        @Override
        public Class<? extends Annotation> getAnnotationType() {
            return this.annotation.annotationType();
        }

        public boolean equals(Object o) {
            if (!(o instanceof AnnotationInstanceStrategy)) {
                return false;
            }
            AnnotationInstanceStrategy other = (AnnotationInstanceStrategy)o;
            return ((Object)this.annotation).equals(other.annotation);
        }

        public int hashCode() {
            return ((Object)this.annotation).hashCode();
        }

        public String toString() {
            return ((Object)this.annotation).toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface AnnotationStrategy {
        public Annotation getAnnotation();

        public Class<? extends Annotation> getAnnotationType();

        public boolean hasAttributes();

        public AnnotationStrategy withoutAttributes();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SimpleKey<T>
    extends Key<T> {
        private SimpleKey(Type type, AnnotationStrategy annotationStrategy) {
            super(type, annotationStrategy);
        }

        private SimpleKey(TypeLiteral<T> typeLiteral, AnnotationStrategy annotationStrategy) {
            super(typeLiteral, annotationStrategy);
        }
    }
}

