/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.spi;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.jar.Manifest;
import org.jboss.osgi.spi.ManifestBuilder;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.osgi.framework.Version;

public final class OSGiManifestBuilder
extends ManifestBuilder
implements Asset {
    private Set<String> importPackages = new LinkedHashSet<String>();
    private Set<String> exportPackages = new LinkedHashSet<String>();
    private Set<String> dynamicImportPackages = new LinkedHashSet<String>();
    private Set<String> requiredBundles = new LinkedHashSet<String>();
    private Set<String> requiredEnvironments = new LinkedHashSet<String>();
    private Manifest manifest;

    public static OSGiManifestBuilder newInstance() {
        return new OSGiManifestBuilder();
    }

    private OSGiManifestBuilder() {
    }

    public OSGiManifestBuilder addBundleManifestVersion(int version) {
        this.append("Bundle-ManifestVersion: " + version);
        return this;
    }

    public OSGiManifestBuilder addBundleSymbolicName(String symbolicName) {
        this.append("Bundle-SymbolicName: " + symbolicName);
        return this;
    }

    public OSGiManifestBuilder addBundleName(String name) {
        this.append("Bundle-Name: " + name);
        return this;
    }

    public OSGiManifestBuilder addBundleVersion(Version version) {
        this.append("Bundle-Version: " + version);
        return this;
    }

    public OSGiManifestBuilder addBundleVersion(String version) {
        return this.addBundleVersion(Version.parseVersion((String)version));
    }

    public OSGiManifestBuilder addBundleActivator(Class<?> bundleActivator) {
        return this.addBundleActivator(bundleActivator.getName());
    }

    public OSGiManifestBuilder addBundleActivator(String bundleActivator) {
        this.append("Bundle-Activator: " + bundleActivator);
        return this;
    }

    public OSGiManifestBuilder addBundleActivationPolicy(String activationPolicy) {
        this.append("Bundle-ActivationPolicy: " + activationPolicy);
        return this;
    }

    public OSGiManifestBuilder addFragmentHost(String fragmentHost) {
        this.append("Fragment-Host: " + fragmentHost);
        return this;
    }

    public OSGiManifestBuilder addRequireBundle(String requiredBundle) {
        this.requiredBundles.add(requiredBundle);
        return this;
    }

    public OSGiManifestBuilder addRequireExecutionEnvironment(String ... environments) {
        for (String aux : environments) {
            this.requiredEnvironments.add(aux);
        }
        return this;
    }

    public OSGiManifestBuilder addImportPackages(Class<?> ... packages) {
        for (Class<?> aux : packages) {
            this.importPackages.add(aux.getPackage().getName());
        }
        return this;
    }

    public OSGiManifestBuilder addImportPackages(String ... packages) {
        for (String aux : packages) {
            this.importPackages.add(aux);
        }
        return this;
    }

    public OSGiManifestBuilder addDynamicImportPackages(String ... packages) {
        for (String aux : packages) {
            this.dynamicImportPackages.add(aux);
        }
        return this;
    }

    public OSGiManifestBuilder addExportPackages(Class<?> ... packages) {
        for (Class<?> aux : packages) {
            this.exportPackages.add(aux.getPackage().getName());
        }
        return this;
    }

    public OSGiManifestBuilder addExportPackages(String ... packages) {
        for (String aux : packages) {
            this.exportPackages.add(aux);
        }
        return this;
    }

    @Override
    public Manifest getManifest() {
        if (this.manifest == null) {
            Iterator<String> iterator;
            StringBuffer buffer;
            if (this.requiredBundles.size() > 0) {
                buffer = new StringBuffer();
                buffer.append("Require-Bundle: ");
                iterator = this.requiredBundles.iterator();
                buffer.append(iterator.next());
                while (iterator.hasNext()) {
                    buffer.append("," + iterator.next());
                }
                this.append(buffer.toString());
            }
            if (this.requiredEnvironments.size() > 0) {
                buffer = new StringBuffer();
                buffer.append("Bundle-RequiredExecutionEnvironment: ");
                iterator = this.requiredEnvironments.iterator();
                buffer.append(iterator.next());
                while (iterator.hasNext()) {
                    buffer.append("," + iterator.next());
                }
                this.append(buffer.toString());
            }
            if (this.exportPackages.size() > 0) {
                buffer = new StringBuffer();
                buffer.append("Export-Package: ");
                iterator = this.exportPackages.iterator();
                buffer.append(iterator.next());
                while (iterator.hasNext()) {
                    buffer.append("," + iterator.next());
                }
                this.append(buffer.toString());
            }
            if (this.importPackages.size() > 0) {
                buffer = new StringBuffer();
                buffer.append("Import-Package: ");
                iterator = this.importPackages.iterator();
                buffer.append(iterator.next());
                while (iterator.hasNext()) {
                    buffer.append("," + iterator.next());
                }
                this.append(buffer.toString());
            }
            if (this.dynamicImportPackages.size() > 0) {
                buffer = new StringBuffer();
                buffer.append("DynamicImport-Package: ");
                iterator = this.dynamicImportPackages.iterator();
                buffer.append(iterator.next());
                while (iterator.hasNext()) {
                    buffer.append("," + iterator.next());
                }
                this.append(buffer.toString());
            }
            this.manifest = super.getManifest();
        }
        return this.manifest;
    }
}

