/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.AbstractNode;
import org.jboss.cache.CacheException;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.Node;
import org.jboss.cache.NodeNotValidException;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.commands.write.CreateNodeCommand;
import org.jboss.cache.factories.CommandsFactory;
import org.jboss.cache.lock.IdentityLock;
import org.jboss.cache.lock.LockStrategyFactory;
import org.jboss.cache.marshall.MarshalledValue;
import org.jboss.cache.optimistic.DataVersion;
import org.jboss.cache.transaction.GlobalTransaction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnversionedNode<K, V>
extends AbstractNode<K, V> {
    protected static Log log = LogFactory.getLog(UnversionedNode.class);
    protected static final boolean trace = log.isTraceEnabled();
    protected transient IdentityLock lock = null;
    private transient CacheSPI cache;
    private final Map data = new HashMap();
    protected NodeSPI delegate;
    private CommandsFactory commandsFactory;
    protected LockStrategyFactory lockStrategyFactory;

    public UnversionedNode() {
        this.fqn = Fqn.ROOT;
        this.initFlags();
    }

    protected UnversionedNode(Object child_name, Fqn fqn, Map data, boolean mapSafe, CacheSPI cache) {
        if (cache == null) {
            throw new IllegalArgumentException("no cache init for " + fqn);
        }
        if (!fqn.isRoot() && !child_name.equals(fqn.getLastElement())) {
            throw new IllegalArgumentException("Child " + child_name + " must be last part of " + fqn);
        }
        this.initFlags();
        this.cache = cache;
        this.fqn = fqn;
        this.init();
        this.setInternalState(data);
    }

    protected void initFlags() {
        this.flags.add(AbstractNode.NodeFlags.DATA_LOADED);
        this.flags.add(AbstractNode.NodeFlags.VALID);
    }

    public NodeSPI getDelegate() {
        return this.delegate;
    }

    public void setDelegate(NodeSPI delegate) {
        this.delegate = delegate;
    }

    public void injectDependencies(CacheSPI spi, CommandsFactory commandsFactory, LockStrategyFactory lockStrategyFactory) {
        this.cache = spi;
        this.commandsFactory = commandsFactory;
        this.lockStrategyFactory = lockStrategyFactory;
        this.init();
    }

    private void init() {
        if (this.cache != null && this.cache.getConfiguration() != null) {
            this.setLockForChildInsertRemove(this.cache.getConfiguration().isLockParentForChildInsertRemove());
        }
    }

    public NodeSPI getParent() {
        if (this.fqn.isRoot()) {
            return null;
        }
        return this.cache.peek(this.fqn.getParent(), true);
    }

    protected synchronized void initLock() {
        if (this.lock == null) {
            this.lock = new IdentityLock(this.lockStrategyFactory, this.delegate);
        }
    }

    private synchronized Map<Object, Node<K, V>> children() {
        if (this.children == null) {
            this.children = this.getFqn().isRoot() ? new ConcurrentHashMap(64, 0.5f, 16) : new ConcurrentHashMap(4, 0.75f, 4);
        }
        return this.children;
    }

    public CacheSPI getCache() {
        return this.cache;
    }

    public boolean isChildrenLoaded() {
        return this.flags.contains((Object)AbstractNode.NodeFlags.CHILDREN_LOADED);
    }

    public void setChildrenLoaded(boolean childrenLoaded) {
        this.setFlag(AbstractNode.NodeFlags.CHILDREN_LOADED, childrenLoaded);
    }

    private void assertValid() {
        if (!this.isValid()) {
            throw new NodeNotValidException("Node " + this.getFqn() + " is not valid.  Perhaps it has been moved or removed.");
        }
    }

    public Object get(Object key) {
        this.assertValid();
        return this.cache.get(this.getFqn(), key);
    }

    public Object getDirect(Object key) {
        return this.data.get(key);
    }

    private boolean isReadLocked() {
        return this.lock != null && this.lock.isReadLocked();
    }

    private boolean isWriteLocked() {
        return this.lock != null && this.lock.isWriteLocked();
    }

    public IdentityLock getLock() {
        this.initLock();
        return this.lock;
    }

    public Map getDataDirect() {
        if (this.data == null) {
            return Collections.emptyMap();
        }
        return this.data;
    }

    public Object put(Object key, Object value) {
        this.assertValid();
        return this.cache.put(this.getFqn(), key, value);
    }

    public Object putDirect(Object key, Object value) {
        return this.data.put(key, value);
    }

    public NodeSPI getOrCreateChild(Object child_name, GlobalTransaction gtx, boolean notify) {
        return this.getOrCreateChild(child_name, gtx, true, notify);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NodeSPI getOrCreateChild(Object child_name, GlobalTransaction gtx, boolean createIfNotExists, boolean notify) {
        if (child_name == null) {
            throw new IllegalArgumentException("null child name");
        }
        NodeSPI child = (NodeSPI)this.children().get(child_name);
        InvocationContext ctx = this.cache.getInvocationContext();
        if (createIfNotExists && child == null) {
            Fqn<Object> child_fqn = Fqn.fromRelativeElements(this.fqn, child_name);
            NodeSPI newChild = (NodeSPI)this.cache.getConfiguration().getRuntimeConfig().getNodeFactory().createNode(child_name, this.delegate, null);
            if (newChild == null) {
                throw new IllegalStateException();
            }
            UnversionedNode unversionedNode = this;
            synchronized (unversionedNode) {
                child = (NodeSPI)this.children().get(child_name);
                if (child == null) {
                    if (notify) {
                        this.cache.getNotifier().notifyNodeCreated(child_fqn, true, ctx);
                    }
                    child = newChild;
                    this.children.put(child_name, child);
                    if (gtx != null) {
                        CreateNodeCommand createNodeCommand = this.commandsFactory.buildCreateNodeCommand(child_fqn);
                        ctx.getTransactionEntry().addModification(createNodeCommand);
                    }
                }
            }
            if (newChild == child) {
                if (trace) {
                    log.trace((Object)("created child: fqn=" + child_fqn));
                }
                if (notify) {
                    this.cache.getNotifier().notifyNodeCreated(child_fqn, false, ctx);
                }
            }
        }
        return child;
    }

    public Object remove(Object key) {
        this.assertValid();
        return this.cache.remove(this.getFqn(), key);
    }

    public Object removeDirect(Object key) {
        if (this.data == null) {
            return null;
        }
        return this.data.remove(key);
    }

    public void printDetails(StringBuilder sb, int indent) {
        this.printDetailsInMap(sb, indent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        if (!this.isValid()) {
            sb.append(" (INVALID!) ");
        }
        if (this.isDeleted()) {
            sb.append(" (deleted) [ ").append(this.fqn);
        } else {
            sb.append("[ ").append(this.fqn);
        }
        if (this.data != null) {
            Map map = this.data;
            synchronized (map) {
                if (trace) {
                    sb.append(" data=").append(this.data.keySet());
                } else {
                    sb.append(" data=[");
                    Set keys = this.data.keySet();
                    int i = 0;
                    for (Object o : keys) {
                        sb.append(o);
                        if (++i == 5) {
                            int more = keys.size() - 5;
                            if (more <= 1) continue;
                            sb.append(", and ");
                            sb.append(more);
                            sb.append(" more");
                            break;
                        }
                        sb.append(", ");
                    }
                    sb.append("]");
                }
            }
        }
        if (this.children != null && !this.children.isEmpty()) {
            if (trace) {
                sb.append(" children=").append(this.getChildrenNamesDirect());
            } else {
                sb.append(" children=[");
                Set<Object> names = this.getChildrenNamesDirect();
                int i = 0;
                for (Object o : names) {
                    sb.append(o);
                    if (++i == 5) {
                        int more = names.size() - 5;
                        if (more <= 1) continue;
                        sb.append(", and ");
                        sb.append(more);
                        sb.append(" more");
                        break;
                    }
                    sb.append(", ");
                }
                sb.append("]");
            }
        }
        if (this.lock != null) {
            if (this.isReadLocked()) {
                sb.append(" RL");
            }
            if (this.isWriteLocked()) {
                sb.append(" WL");
            }
        }
        sb.append("]");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChildDirect(NodeSPI child) {
        if (child.getFqn().getParent().equals(this.getFqn())) {
            UnversionedNode unversionedNode = this;
            synchronized (unversionedNode) {
                this.children().put(child.getFqn().getLastElement(), child);
            }
        } else {
            throw new CacheException("Attempting to add a child [" + child.getFqn() + "] to [" + this.getFqn() + "].  Can only add direct children.");
        }
    }

    public NodeSPI addChildDirect(Fqn f) {
        return this.addChildDirect(f, true);
    }

    public NodeSPI addChildDirect(Fqn f, boolean notify) {
        if (f.size() == 1) {
            GlobalTransaction gtx = this.cache.getInvocationContext().getGlobalTransaction();
            return this.getOrCreateChild(f.getLastElement(), gtx, true, notify);
        }
        throw new UnsupportedOperationException("Cannot directly create children which aren't directly under the current node.");
    }

    public NodeSPI addChildDirect(Object childName, boolean notify) {
        GlobalTransaction gtx = this.cache.getInvocationContext().getGlobalTransaction();
        return this.getOrCreateChild(childName, gtx, true, notify);
    }

    public void clearDataDirect() {
        if (this.data != null) {
            this.data.clear();
        }
    }

    public NodeSPI getChildDirect(Fqn fqn) {
        if (fqn.size() == 1) {
            return this.getChildDirect(fqn.getLastElement());
        }
        NodeSPI currentNode = this.delegate;
        for (int i = 0; i < fqn.size(); ++i) {
            Object nextChildName = fqn.get(i);
            if ((currentNode = currentNode.getChildDirect(nextChildName)) != null) continue;
            return null;
        }
        return currentNode;
    }

    public Set<Object> getChildrenNamesDirect() {
        return this.children == null ? Collections.emptySet() : new HashSet(this.children.keySet());
    }

    public Set<Object> getKeysDirect() {
        if (this.data == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(new HashSet(this.data.keySet()));
    }

    public boolean removeChildDirect(Object childName) {
        return this.children != null && this.children.remove(childName) != null;
    }

    public boolean removeChildDirect(Fqn f) {
        if (f.size() == 1) {
            return this.removeChildDirect(f.getLastElement());
        }
        NodeSPI child = this.getChildDirect(f);
        return child != null && child.getParent().removeChildDirect(f.getLastElement());
    }

    public Map<Object, Node<K, V>> getChildrenMapDirect() {
        return this.children;
    }

    public void setChildrenMapDirect(Map<Object, Node<K, V>> children) {
        this.children().clear();
        this.children.putAll(children);
    }

    public void putAll(Map data) {
        this.assertValid();
        this.cache.put(this.fqn, data);
    }

    public void putAllDirect(Map data) {
        if (data == null) {
            return;
        }
        this.data.putAll(data);
    }

    public void removeChildrenDirect() {
        if (this.children != null) {
            this.children.clear();
        }
        this.children = null;
    }

    public void setVersion(DataVersion version) {
        throw new UnsupportedOperationException("Versioning not supported");
    }

    public DataVersion getVersion() {
        throw new UnsupportedOperationException("Versioning not supported");
    }

    private void printIndent(StringBuilder sb, int indent) {
        if (sb != null) {
            for (int i = 0; i < indent; ++i) {
                sb.append(" ");
            }
        }
    }

    public void addChild(Object child_name, Node n) {
        if (child_name != null) {
            this.children().put(child_name, n);
        }
    }

    private Object getName() {
        return this.fqn.getLastElement();
    }

    public Fqn getFqn() {
        return this.fqn;
    }

    public void setFqn(Fqn fqn) {
        if (trace) {
            log.trace((Object)(this.getFqn() + " set FQN " + fqn));
        }
        this.fqn = fqn;
        if (this.children == null) {
            return;
        }
        for (Map.Entry me : this.children.entrySet()) {
            NodeSPI n = (NodeSPI)me.getValue();
            Fqn<Object> cfqn = Fqn.fromRelativeElements(fqn, me.getKey());
            n.setFqn(cfqn);
        }
    }

    public NodeSPI getChildDirect(Object childName) {
        if (childName == null) {
            return null;
        }
        return (NodeSPI)(this.children == null ? null : (Node)this.children.get(childName));
    }

    public Set<NodeSPI> getChildrenDirect() {
        if (this.children == null || this.children.size() == 0) {
            return Collections.emptySet();
        }
        HashSet<NodeSPI> exclDeleted = new HashSet<NodeSPI>();
        for (Node n : this.children.values()) {
            NodeSPI spi = (NodeSPI)n;
            if (spi.isDeleted()) continue;
            exclDeleted.add(spi);
        }
        return Collections.unmodifiableSet(exclDeleted);
    }

    public boolean hasChildrenDirect() {
        return this.children != null && this.children.size() != 0;
    }

    public Set<NodeSPI> getChildrenDirect(boolean includeMarkedForRemoval) {
        if (includeMarkedForRemoval) {
            if (this.children != null && !this.children.isEmpty()) {
                return Collections.unmodifiableSet(new HashSet(this.children.values()));
            }
            return Collections.emptySet();
        }
        return this.getChildrenDirect();
    }

    private void printDetailsInMap(StringBuilder sb, int indent) {
        this.printIndent(sb, indent);
        indent += 2;
        if (!this.getFqn().isRoot()) {
            sb.append("/");
        }
        sb.append(this.getName());
        sb.append("  ");
        sb.append(this.data);
        if (this.children != null) {
            for (Node n : this.children.values()) {
                sb.append("\n");
                ((NodeSPI)n).printDetails(sb, indent);
            }
        }
    }

    public boolean isDataLoaded() {
        return this.flags.contains((Object)AbstractNode.NodeFlags.DATA_LOADED);
    }

    public void setDataLoaded(boolean dataLoaded) {
        this.setFlag(AbstractNode.NodeFlags.DATA_LOADED, dataLoaded);
    }

    public boolean isValid() {
        return this.flags.contains((Object)AbstractNode.NodeFlags.VALID);
    }

    public void setValid(boolean valid, boolean recursive) {
        this.setFlag(AbstractNode.NodeFlags.VALID, valid);
        if (trace) {
            log.trace((Object)("Marking node " + this.getFqn() + " as " + (valid ? "" : "in") + "valid"));
        }
        if (recursive) {
            for (Node<K, V> child : this.children().values()) {
                ((NodeSPI)child).setValid(valid, recursive);
            }
        }
    }

    public boolean isLockForChildInsertRemove() {
        return this.flags.contains((Object)AbstractNode.NodeFlags.LOCK_FOR_CHILD_INSERT_REMOVE);
    }

    public void setLockForChildInsertRemove(boolean lockForChildInsertRemove) {
        this.setFlag(AbstractNode.NodeFlags.LOCK_FOR_CHILD_INSERT_REMOVE, lockForChildInsertRemove);
    }

    public void setInternalState(Map state) {
        this.putAllDirect(state);
    }

    public Map getInternalState(boolean onlyInternalState) {
        if (onlyInternalState) {
            return new HashMap(0);
        }
        if (this.data == null) {
            return new HashMap(0);
        }
        return new HashMap(this.data);
    }

    public void releaseObjectReferences(boolean recursive) {
        if (recursive && this.children != null) {
            for (Node child : this.children.values()) {
                child.releaseObjectReferences(recursive);
            }
        }
        if (this.data != null) {
            for (Object key : this.data.keySet()) {
                Object value = this.data.get(key);
                if (key instanceof MarshalledValue) {
                    ((MarshalledValue)key).compact(true, true);
                }
                if (!(value instanceof MarshalledValue)) continue;
                ((MarshalledValue)value).compact(true, true);
            }
        }
    }
}

