/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.configuration;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.jbpm.JbpmException;
import org.jbpm.configuration.ObjectFactoryImpl;
import org.jbpm.configuration.ObjectFactoryParser;
import org.jbpm.configuration.ObjectInfo;
import org.jbpm.util.ArrayUtil;
import org.jbpm.util.ClassLoaderUtil;
import org.jbpm.util.XmlUtil;
import org.w3c.dom.Element;

public class ConstructorInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String className;
    private String factoryRefName;
    private String factoryClassName;
    private String factoryMethodName;
    private final String[] parameterClassNames;
    private final ObjectInfo[] parameterInfos;

    public ConstructorInfo(Element constructorElement, ObjectFactoryParser configParser) {
        if (constructorElement.hasAttribute("factory")) {
            this.factoryRefName = constructorElement.getAttribute("factory");
            if (!constructorElement.hasAttribute("method")) {
                throw new JbpmException("missing method attribute in constructor");
            }
            this.factoryMethodName = constructorElement.getAttribute("method");
        } else if (constructorElement.hasAttribute("factory-class")) {
            this.factoryClassName = constructorElement.getAttribute("factory-class");
            if (!constructorElement.hasAttribute("method")) {
                throw new JbpmException("missing method attribute in constructor");
            }
            this.factoryMethodName = constructorElement.getAttribute("method");
        } else {
            if (constructorElement.hasAttribute("method")) {
                throw new JbpmException("missing factory or factory-class attribute in constructor");
            }
            if (constructorElement.hasAttribute("class")) {
                this.className = constructorElement.getAttribute("class");
            } else {
                throw new JbpmException("missing class, factory or factory-class attribute in constructor");
            }
        }
        List parameterElements = XmlUtil.elements(constructorElement, "parameter");
        this.parameterClassNames = new String[parameterElements.size()];
        this.parameterInfos = new ObjectInfo[parameterElements.size()];
        for (int i = 0; i < parameterElements.size(); ++i) {
            Element parameterElement = (Element)parameterElements.get(i);
            if (!parameterElement.hasAttribute("class")) {
                throw new JbpmException("missing class attribute in constructor parameter");
            }
            this.parameterClassNames[i] = parameterElement.getAttribute("class");
            Element parameterInfoElement = XmlUtil.element(parameterElement);
            if (parameterInfoElement == null) {
                throw new JbpmException("missing subelement in constructor parameter");
            }
            this.parameterInfos[i] = configParser.parse(parameterInfoElement);
        }
    }

    public Object createObject(ObjectFactoryImpl objectFactory) {
        Object[] args = this.getArgs(objectFactory);
        Object[] parameterTypes = this.getParameterTypes(objectFactory);
        if (this.factoryRefName != null || this.factoryClassName != null) {
            Class<?> factoryClass;
            Object factory;
            if (this.factoryRefName != null) {
                factory = objectFactory.getObject(this.factoryRefName);
                factoryClass = factory.getClass();
            } else {
                factory = null;
                try {
                    factoryClass = ClassLoaderUtil.classForName(this.factoryClassName);
                }
                catch (ClassNotFoundException e) {
                    throw new JbpmException("factory class not found: " + this.factoryClassName, e);
                }
            }
            Method factoryMethod = this.findMethod(factoryClass, (Class[])parameterTypes);
            try {
                return factoryMethod.invoke(factory, args);
            }
            catch (IllegalAccessException e) {
                throw new JbpmException(this.getClass() + " has no access to " + factoryMethod, e);
            }
            catch (InvocationTargetException e) {
                throw new JbpmException(factoryMethod + " threw exception", e.getCause());
            }
        }
        try {
            Class clazz = objectFactory.classForName(this.className);
            Constructor constructor = clazz.getDeclaredConstructor((Class<?>[])parameterTypes);
            try {
                return constructor.newInstance(args);
            }
            catch (InstantiationException e) {
                throw new JbpmException("failed to instantiate " + clazz, e);
            }
            catch (IllegalAccessException e) {
                throw new JbpmException(this.getClass() + " has no access to " + constructor, e);
            }
            catch (InvocationTargetException e) {
                throw new JbpmException(constructor + " threw exception", e.getCause());
            }
        }
        catch (ClassNotFoundException e) {
            throw new JbpmException("class not found: " + this.className, e);
        }
        catch (NoSuchMethodException e) {
            throw new JbpmException("constructor not found: " + this.className + ArrayUtil.toString(parameterTypes), e);
        }
    }

    protected Class[] getParameterTypes(ObjectFactoryImpl objectFactory) {
        int nbrOfParameters = this.parameterClassNames != null ? this.parameterClassNames.length : 0;
        Class[] parameterTypes = new Class[nbrOfParameters];
        for (int i = 0; i < nbrOfParameters; ++i) {
            String parameterClassName = this.parameterClassNames[i];
            try {
                parameterTypes[i] = objectFactory.classForName(parameterClassName);
                continue;
            }
            catch (ClassNotFoundException e) {
                throw new JbpmException("class not found: " + parameterClassName, e);
            }
        }
        return parameterTypes;
    }

    protected Object[] getArgs(ObjectFactoryImpl objectFactory) {
        int nbrOfParameters = this.parameterClassNames != null ? this.parameterClassNames.length : 0;
        Object[] args = new Object[nbrOfParameters];
        for (int i = 0; i < nbrOfParameters; ++i) {
            args[i] = objectFactory.getObject(this.parameterInfos[i]);
        }
        return args;
    }

    public Method findMethod(Class clazz, Class[] parameterTypes) {
        try {
            return clazz.getMethod(this.factoryMethodName, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            while (true) {
                try {
                    return clazz.getDeclaredMethod(this.factoryMethodName, parameterTypes);
                }
                catch (NoSuchMethodException e2) {
                    if ((clazz = clazz.getSuperclass()) != null) continue;
                    throw new JbpmException("no such method: " + this.factoryMethodName, e);
                }
                break;
            }
        }
    }
}

