/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.configuration;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.JbpmContext;
import org.jbpm.configuration.AbstractObjectInfo;
import org.jbpm.configuration.BeanInfo;
import org.jbpm.configuration.ConfigurationException;
import org.jbpm.configuration.ObjectFactoryImpl;
import org.jbpm.configuration.ObjectFactoryParser;
import org.jbpm.configuration.ObjectInfo;
import org.jbpm.svc.Services;
import org.jbpm.util.XmlUtil;
import org.w3c.dom.Element;

public class JbpmContextInfo
extends AbstractObjectInfo {
    private static final long serialVersionUID = 1L;
    private final ObjectInfo[] serviceFactoryInfos;
    private Map serviceFactories;
    private final ObjectInfo[] saveOperationInfos;
    private List saveOperations;

    public JbpmContextInfo(Element jbpmContextElement, ObjectFactoryParser objectFactoryParser) {
        super(JbpmContextInfo.verifyDefaultName(jbpmContextElement), objectFactoryParser);
        BeanInfo beanInfo;
        if (jbpmContextElement.hasAttribute("singleton")) {
            throw new ConfigurationException("attribute singleton is not allowed in jbpm-context");
        }
        List serviceElements = XmlUtil.elements(jbpmContextElement, "service");
        this.serviceFactoryInfos = new ObjectInfo[serviceElements.size()];
        for (int i = 0; i < this.serviceFactoryInfos.length; ++i) {
            ObjectInfo serviceFactoryInfo;
            Element serviceElement = (Element)serviceElements.get(i);
            String serviceName = serviceElement.getAttribute("name");
            if (serviceName.length() == 0) {
                throw new ConfigurationException("service has no name");
            }
            Element factoryElement = XmlUtil.element(serviceElement, "factory");
            if (factoryElement != null) {
                Element factoryBeanElement = XmlUtil.element(factoryElement);
                if (factoryBeanElement == null) {
                    throw new ConfigurationException("element factory requires either a bean or ref subelement");
                }
                factoryBeanElement.setAttribute("name", serviceName);
                serviceFactoryInfo = objectFactoryParser.parse(factoryBeanElement);
            } else if (serviceElement.hasAttribute("factory")) {
                beanInfo = new BeanInfo();
                beanInfo.setName(serviceName);
                beanInfo.setClassName(serviceElement.getAttribute("factory"));
                serviceFactoryInfo = beanInfo;
            } else {
                throw new ConfigurationException("element service requires either a factory attribute or a factory subelement");
            }
            this.serviceFactoryInfos[i] = serviceFactoryInfo;
        }
        Element saveOperationsElement = XmlUtil.element(jbpmContextElement, "save-operations");
        if (saveOperationsElement != null) {
            List saveOperationElements = XmlUtil.elements(saveOperationsElement, "save-operation");
            this.saveOperationInfos = new ObjectInfo[saveOperationElements.size()];
            for (int i = 0; i < this.saveOperationInfos.length; ++i) {
                Element saveOperationElement = (Element)saveOperationElements.get(i);
                if (saveOperationElement.hasAttribute("class")) {
                    String saveOperationClassName = saveOperationElement.getAttribute("class");
                    beanInfo = new BeanInfo();
                    beanInfo.setClassName(saveOperationClassName);
                    this.saveOperationInfos[i] = beanInfo;
                    continue;
                }
                Element saveOperationBeanElement = XmlUtil.element(saveOperationElement);
                if (saveOperationBeanElement == null) {
                    throw new ConfigurationException("element save-operation requires either a class attribute or a bean or ref subelement");
                }
                this.saveOperationInfos[i] = objectFactoryParser.parse(saveOperationBeanElement);
            }
        } else {
            this.saveOperationInfos = null;
        }
    }

    private static Element verifyDefaultName(Element jbpmContextElement) {
        if (!jbpmContextElement.hasAttribute("name")) {
            jbpmContextElement.setAttribute("name", "default.jbpm.context");
        }
        return jbpmContextElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object createObject(ObjectFactoryImpl objectFactory) {
        JbpmContextInfo jbpmContextInfo = this;
        synchronized (jbpmContextInfo) {
            if (this.serviceFactories == null) {
                int i;
                this.serviceFactories = new LinkedHashMap(this.serviceFactoryInfos.length);
                for (i = 0; i < this.serviceFactoryInfos.length; ++i) {
                    ObjectInfo serviceFactoryInfo = this.serviceFactoryInfos[i];
                    Object serviceFactory = serviceFactoryInfo.createObject(objectFactory);
                    this.serviceFactories.put(serviceFactoryInfo.getName(), serviceFactory);
                }
                if (this.saveOperationInfos != null) {
                    this.saveOperations = new ArrayList(this.saveOperationInfos.length);
                    for (i = 0; i < this.saveOperationInfos.length; ++i) {
                        Object saveOperation = this.saveOperationInfos[i].createObject(objectFactory);
                        this.saveOperations.add(saveOperation);
                    }
                }
            }
        }
        Services services = new Services(this.serviceFactories, this.saveOperations);
        return new JbpmContext(services, objectFactory);
    }
}

