/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.db;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.jbpm.JbpmContext;
import org.jbpm.JbpmException;
import org.jbpm.db.JbpmSession;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;
import org.jbpm.graph.node.ProcessState;
import org.jbpm.persistence.JbpmPersistenceException;

public class GraphSession {
    private final Session session;
    private final JbpmSession jbpmSession;

    public GraphSession(JbpmSession jbpmSession) {
        this.session = jbpmSession.getSession();
        this.jbpmSession = jbpmSession;
    }

    public GraphSession(Session session) {
        this.session = session;
        this.jbpmSession = null;
    }

    public void deployProcessDefinition(ProcessDefinition processDefinition) {
        String processName = processDefinition.getName();
        if (processName == null) {
            throw new JbpmException("process definition has no name");
        }
        ProcessDefinition previousLatestVersion = this.findLatestProcessDefinition(processName);
        if (previousLatestVersion != null) {
            processDefinition.setVersion(previousLatestVersion.getVersion() + 1);
        } else {
            processDefinition.setVersion(1);
        }
        this.saveProcessDefinition(processDefinition);
    }

    public void saveProcessDefinition(ProcessDefinition processDefinition) {
        try {
            this.session.save((Object)processDefinition);
        }
        catch (HibernateException e) {
            this.handle(e);
            throw new JbpmPersistenceException("could not save " + processDefinition, e);
        }
    }

    public ProcessDefinition loadProcessDefinition(long processDefinitionId) {
        try {
            return (ProcessDefinition)this.session.load(ProcessDefinition.class, (Serializable)new Long(processDefinitionId));
        }
        catch (HibernateException e) {
            this.handle(e);
            throw new JbpmPersistenceException("could not load process definition " + processDefinitionId, e);
        }
    }

    public ProcessDefinition getProcessDefinition(long processDefinitionId) {
        try {
            return (ProcessDefinition)this.session.get(ProcessDefinition.class, (Serializable)new Long(processDefinitionId));
        }
        catch (HibernateException e) {
            this.handle(e);
            throw new JbpmPersistenceException("could not get process definition " + processDefinitionId, e);
        }
    }

    public ProcessDefinition findProcessDefinition(String name, int version) {
        try {
            return (ProcessDefinition)this.session.getNamedQuery("GraphSession.findProcessDefinitionByNameAndVersion").setString("name", name).setInteger("version", version).uniqueResult();
        }
        catch (HibernateException e) {
            this.handle(e);
            throw new JbpmPersistenceException("could not find process definition by name '" + name + "' and version " + version, e);
        }
    }

    public ProcessDefinition findLatestProcessDefinition(String name) {
        try {
            return (ProcessDefinition)this.session.getNamedQuery("GraphSession.findLatestProcessDefinitionQuery").setString("name", name).setMaxResults(1).uniqueResult();
        }
        catch (HibernateException e) {
            this.handle(e);
            throw new JbpmPersistenceException("could not find process definition by name " + name, e);
        }
    }

    public List findLatestProcessDefinitions() {
        try {
            List tuples = this.session.getNamedQuery("GraphSession.findLatestProcessDefinitions").list();
            if (tuples.isEmpty()) {
                return Collections.EMPTY_LIST;
            }
            ArrayList<ProcessDefinition> result = new ArrayList<ProcessDefinition>(tuples.size());
            for (Object[] tuple : tuples) {
                String name = (String)tuple[0];
                Integer version = (Integer)tuple[1];
                result.add(this.findProcessDefinition(name, version));
            }
            return result;
        }
        catch (HibernateException e) {
            this.handle(e);
            throw new JbpmPersistenceException("could not find latest process definitions", e);
        }
    }

    public List findProcessDefinitions(Collection processDefinitionIds) {
        try {
            return this.session.createCriteria(ProcessDefinition.class).add(Restrictions.in((String)"id", (Collection)processDefinitionIds)).list();
        }
        catch (HibernateException e) {
            this.handle(e);
            throw new JbpmPersistenceException("could not find process definitions by identifiers " + processDefinitionIds, e);
        }
    }

    public List findAllProcessDefinitions() {
        try {
            return this.session.getNamedQuery("GraphSession.findAllProcessDefinitions").list();
        }
        catch (HibernateException e) {
            this.handle(e);
            throw new JbpmPersistenceException("could not find all process definitions", e);
        }
    }

    public List findAllProcessDefinitionVersions(String name) {
        try {
            return this.session.getNamedQuery("GraphSession.findAllProcessDefinitionVersions").setString("name", name).list();
        }
        catch (HibernateException e) {
            this.handle(e);
            throw new JbpmPersistenceException("could not find all process definitions by name " + name, e);
        }
    }

    public void deleteProcessDefinition(long processDefinitionId) {
        this.deleteProcessDefinition(this.loadProcessDefinition(processDefinitionId));
    }

    public void deleteProcessDefinition(ProcessDefinition processDefinition) {
        try {
            List processInstances = this.session.createCriteria(ProcessInstance.class).add((Criterion)Restrictions.eq((String)"processDefinition", (Object)processDefinition)).setProjection((Projection)Projections.id()).list();
            for (Long id : processInstances) {
                ProcessInstance processInstance = (ProcessInstance)this.session.get(ProcessInstance.class, (Serializable)id);
                if (processInstance == null) continue;
                this.deleteProcessInstance(processInstance);
            }
            List referencingProcessStates = this.findReferencingProcessStates(processDefinition);
            for (ProcessState processState : referencingProcessStates) {
                processState.setSubProcessDefinition(null);
            }
            this.session.delete((Object)processDefinition);
        }
        catch (HibernateException e) {
            this.handle(e);
            throw new JbpmPersistenceException("could not delete " + processDefinition, e);
        }
    }

    private List findReferencingProcessStates(ProcessDefinition subProcessDefinition) {
        return this.session.getNamedQuery("GraphSession.findReferencingProcessStates").setEntity("subProcessDefinition", (Object)subProcessDefinition).list();
    }

    public void saveProcessInstance(ProcessInstance processInstance) {
        JbpmContext.getCurrentJbpmContext().save(processInstance);
    }

    public ProcessInstance loadProcessInstance(long processInstanceId) {
        try {
            return (ProcessInstance)this.session.load(ProcessInstance.class, (Serializable)new Long(processInstanceId));
        }
        catch (HibernateException e) {
            this.handle(e);
            throw new JbpmPersistenceException("could not load process instance " + processInstanceId, e);
        }
    }

    public ProcessInstance getProcessInstance(long processInstanceId) {
        try {
            return (ProcessInstance)this.session.get(ProcessInstance.class, (Serializable)new Long(processInstanceId));
        }
        catch (HibernateException e) {
            this.handle(e);
            throw new JbpmPersistenceException("could not get process instance " + processInstanceId, e);
        }
    }

    public Token loadToken(long tokenId) {
        try {
            return (Token)this.session.load(Token.class, (Serializable)new Long(tokenId));
        }
        catch (HibernateException e) {
            this.handle(e);
            throw new JbpmPersistenceException("could not load token " + tokenId, e);
        }
    }

    public Token getToken(long tokenId) {
        try {
            return (Token)this.session.get(Token.class, (Serializable)new Long(tokenId));
        }
        catch (HibernateException e) {
            this.handle(e);
            throw new JbpmPersistenceException("could not get token " + tokenId, e);
        }
    }

    public void lockProcessInstance(long processInstanceId) {
        try {
            this.session.load(ProcessInstance.class, (Serializable)new Long(processInstanceId), LockMode.UPGRADE);
        }
        catch (HibernateException e) {
            this.handle(e);
            throw new JbpmPersistenceException("could not lock process instance " + processInstanceId, e);
        }
    }

    public void lockProcessInstance(ProcessInstance processInstance) {
        try {
            this.session.lock((Object)processInstance, LockMode.UPGRADE);
        }
        catch (HibernateException e) {
            this.handle(e);
            throw new JbpmPersistenceException("could not lock " + processInstance, e);
        }
    }

    public List findProcessInstances(long processDefinitionId) {
        try {
            return this.session.getNamedQuery("GraphSession.findAllProcessInstancesForDefinition").setLong("processDefinitionId", processDefinitionId).list();
        }
        catch (HibernateException e) {
            this.handle(e);
            throw new JbpmPersistenceException("could not find instances for process definition " + processDefinitionId, e);
        }
    }

    public void deleteProcessInstance(long processInstanceId) {
        this.deleteProcessInstance(this.loadProcessInstance(processInstanceId));
    }

    public void deleteProcessInstance(ProcessInstance processInstance) {
        this.deleteProcessInstance(processInstance, true, true);
    }

    public void deleteProcessInstance(ProcessInstance processInstance, boolean includeTasks, boolean includeJobs) {
        if (processInstance == null) {
            throw new IllegalArgumentException("processInstance cannot be null");
        }
        try {
            if (includeJobs) {
                this.deleteJobs(processInstance);
            }
            this.deleteLogs(processInstance);
            Token superProcessToken = processInstance.getSuperProcessToken();
            if (superProcessToken != null) {
                this.detachFromSuperProcess(processInstance, superProcessToken);
            }
            this.deleteSubProcesses(processInstance);
            if (includeTasks) {
                this.deleteTasks(processInstance);
            }
            this.session.delete((Object)processInstance);
        }
        catch (HibernateException e) {
            this.handle(e);
            throw new JbpmPersistenceException("could not delete " + processInstance, e);
        }
    }

    private void deleteJobs(ProcessInstance processInstance) {
        this.session.getNamedQuery("GraphSession.deleteJobsForProcessInstance").setEntity("processInstance", (Object)processInstance).executeUpdate();
    }

    private void deleteLogs(ProcessInstance processInstance) {
        List logs = this.session.getNamedQuery("GraphSession.findLogsForProcessInstance").setEntity("processInstance", (Object)processInstance).list();
        Iterator i = logs.iterator();
        while (i.hasNext()) {
            this.session.delete(i.next());
        }
    }

    private void detachFromSuperProcess(ProcessInstance processInstance, Token superProcessToken) {
        processInstance.setSuperProcessToken(null);
        superProcessToken.setSubProcessInstance(null);
    }

    private void deleteSubProcesses(ProcessInstance processInstance) {
        List subProcessInstances = this.session.getNamedQuery("GraphSession.findSubProcessInstances").setEntity("processInstance", (Object)processInstance).list();
        for (ProcessInstance subProcessInstance : subProcessInstances) {
            this.deleteProcessInstance(subProcessInstance);
        }
    }

    private void deleteTasks(ProcessInstance processInstance) {
        List tasks = this.session.getNamedQuery("GraphSession.findTaskInstancesForProcessInstance").setEntity("processInstance", (Object)processInstance).list();
        Iterator i = tasks.iterator();
        while (i.hasNext()) {
            this.session.delete(i.next());
        }
    }

    public List calculateAverageTimeByNode(long processDefinitionId, long minumumDurationMillis) {
        try {
            List tuples = this.session.getNamedQuery("GraphSession.calculateAverageTimeByNode").setLong("processDefinitionId", processDefinitionId).setDouble("minimumDuration", (double)minumumDurationMillis).list();
            if (tuples.isEmpty()) {
                return Collections.EMPTY_LIST;
            }
            ArrayList<AverageNodeTimeEntry> results = new ArrayList<AverageNodeTimeEntry>();
            for (Object[] values : tuples) {
                AverageNodeTimeEntry entry = new AverageNodeTimeEntry();
                entry.setNodeId(((Number)values[0]).longValue());
                entry.setNodeName((String)values[1]);
                entry.setCount(((Number)values[2]).intValue());
                entry.setAverageDuration(((Number)values[3]).longValue());
                entry.setMinDuration(((Number)values[4]).longValue());
                entry.setMaxDuration(((Number)values[5]).longValue());
                results.add(entry);
            }
            return results;
        }
        catch (HibernateException e) {
            this.handle(e);
            throw new JbpmPersistenceException("could not calculate average time by node for process definition " + processDefinitionId, e);
        }
    }

    public List findActiveNodesByProcessInstance(ProcessInstance processInstance) {
        try {
            return this.session.getNamedQuery("GraphSession.findActiveNodesByProcessInstance").setEntity("processInstance", (Object)processInstance).list();
        }
        catch (HibernateException e) {
            this.handle(e);
            throw new JbpmPersistenceException("could not find active nodes for " + processInstance, e);
        }
    }

    public ProcessInstance getProcessInstance(ProcessDefinition processDefinition, String key) {
        try {
            return (ProcessInstance)this.session.getNamedQuery("GraphSession.findProcessInstanceByKey").setEntity("processDefinition", (Object)processDefinition).setString("key", key).uniqueResult();
        }
        catch (HibernateException e) {
            this.handle(e);
            throw new JbpmPersistenceException("could not get process instance by key " + key, e);
        }
    }

    public ProcessInstance loadProcessInstance(ProcessDefinition processDefinition, String key) {
        ProcessInstance processInstance = this.getProcessInstance(processDefinition, key);
        if (processInstance == null) {
            throw new JbpmPersistenceException("could not load process instance by key " + key);
        }
        return processInstance;
    }

    private void handle(HibernateException exception) {
        if (this.jbpmSession != null) {
            this.jbpmSession.handleException();
        }
    }

    public static class AverageNodeTimeEntry {
        private long nodeId;
        private String nodeName;
        private int count;
        private long averageDuration;
        private long minDuration;
        private long maxDuration;

        public long getNodeId() {
            return this.nodeId;
        }

        public void setNodeId(long nodeId) {
            this.nodeId = nodeId;
        }

        public String getNodeName() {
            return this.nodeName;
        }

        public void setNodeName(String nodeName) {
            this.nodeName = nodeName;
        }

        public int getCount() {
            return this.count;
        }

        public void setCount(int count) {
            this.count = count;
        }

        public long getAverageDuration() {
            return this.averageDuration;
        }

        public void setAverageDuration(long averageDuration) {
            this.averageDuration = averageDuration;
        }

        public long getMinDuration() {
            return this.minDuration;
        }

        public void setMinDuration(long minDuration) {
            this.minDuration = minDuration;
        }

        public long getMaxDuration() {
            return this.maxDuration;
        }

        public void setMaxDuration(long maxDuration) {
            this.maxDuration = maxDuration;
        }
    }
}

