/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.db;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.jbpm.db.JbpmSession;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.persistence.JbpmPersistenceException;
import org.jbpm.taskmgmt.exe.TaskInstance;

public class TaskMgmtSession {
    final Session session;
    final JbpmSession jbpmSession;

    public TaskMgmtSession(JbpmSession jbpmSession) {
        this.session = jbpmSession.getSession();
        this.jbpmSession = jbpmSession;
    }

    public TaskMgmtSession(Session session) {
        this.session = session;
        this.jbpmSession = null;
    }

    public List findTaskInstances(String actorId) {
        try {
            return this.session.getNamedQuery("TaskMgmtSession.findTaskInstancesByActorId").setString("actorId", actorId).list();
        }
        catch (HibernateException e) {
            this.handle(e);
            throw new JbpmPersistenceException("could not find task instances by actor " + actorId, e);
        }
    }

    public List findTaskInstances(List actorIds) {
        if (actorIds.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        try {
            return this.session.getNamedQuery("TaskMgmtSession.findTaskInstancesByActorIds").setParameterList("actorIds", (Collection)actorIds).list();
        }
        catch (HibernateException e) {
            this.handle(e);
            throw new JbpmPersistenceException("could not find task instances by actors " + actorIds, e);
        }
    }

    public List findTaskInstances(String[] actorIds) {
        return this.findTaskInstances(Arrays.asList(actorIds));
    }

    public List findPooledTaskInstances(String actorId) {
        try {
            List taskInstanceIds = this.session.getNamedQuery("TaskMgmtSession.findPooledTaskInstancesByActorId").setString("actorId", actorId).list();
            return this.findTaskInstancesByIds(taskInstanceIds);
        }
        catch (HibernateException e) {
            this.handle(e);
            throw new JbpmPersistenceException("could not find pooled task instances by actor " + actorId, e);
        }
    }

    public List findPooledTaskInstances(List actorIds) {
        if (actorIds.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        try {
            List taskInstanceIds = this.session.getNamedQuery("TaskMgmtSession.findPooledTaskInstancesByActorIds").setParameterList("actorIds", (Collection)actorIds).list();
            return this.findTaskInstancesByIds(taskInstanceIds);
        }
        catch (HibernateException e) {
            this.handle(e);
            throw new JbpmPersistenceException("could not find pooled task instances by actors " + actorIds, e);
        }
    }

    public List findTaskInstancesByToken(long tokenId) {
        try {
            return this.session.getNamedQuery("TaskMgmtSession.findTaskInstancesByTokenId").setLong("tokenId", tokenId).list();
        }
        catch (HibernateException e) {
            this.handle(e);
            throw new JbpmPersistenceException("could not find task instances by token " + tokenId, e);
        }
    }

    public List findTaskInstancesByProcessInstance(ProcessInstance processInstance) {
        try {
            return this.session.getNamedQuery("TaskMgmtSession.findTaskInstancesByProcessInstance").setEntity("processInstance", (Object)processInstance).list();
        }
        catch (HibernateException e) {
            this.handle(e);
            throw new JbpmPersistenceException("could not find task instances by " + processInstance, e);
        }
    }

    public TaskInstance loadTaskInstance(long taskInstanceId) {
        TaskInstance taskInstance = null;
        try {
            taskInstance = (TaskInstance)this.session.load(TaskInstance.class, (Serializable)new Long(taskInstanceId));
        }
        catch (HibernateException e) {
            this.handle(e);
            throw new JbpmPersistenceException("could not load task instance " + taskInstanceId, e);
        }
        return taskInstance;
    }

    public TaskInstance getTaskInstance(long taskInstanceId) {
        TaskInstance taskInstance = null;
        try {
            taskInstance = (TaskInstance)this.session.get(TaskInstance.class, (Serializable)new Long(taskInstanceId));
        }
        catch (HibernateException e) {
            this.handle(e);
            throw new JbpmPersistenceException("could not get task instance " + taskInstanceId, e);
        }
        return taskInstance;
    }

    public List findTaskInstancesByIds(List taskInstanceIds) {
        if (taskInstanceIds.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        try {
            return this.session.getNamedQuery("TaskMgmtSession.findTaskInstancesByIds").setParameterList("taskInstanceIds", (Collection)taskInstanceIds).list();
        }
        catch (HibernateException e) {
            this.handle(e);
            throw new JbpmPersistenceException("could not find task instances by identifiers " + taskInstanceIds, e);
        }
    }

    private void handle(HibernateException exception) {
        if (this.jbpmSession != null) {
            this.jbpmSession.handleException();
        }
    }
}

