/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.graph.node;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.dom4j.Element;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.Transition;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.Token;
import org.jbpm.jpdl.el.impl.JbpmExpressionEvaluator;
import org.jbpm.jpdl.xml.JpdlXmlReader;
import org.jbpm.taskmgmt.def.Task;
import org.jbpm.taskmgmt.exe.TaskInstance;
import org.jbpm.taskmgmt.exe.TaskMgmtInstance;

public class TaskNode
extends Node {
    private static final long serialVersionUID = 1L;
    public static final int SIGNAL_UNSYNCHRONIZED = 0;
    public static final int SIGNAL_NEVER = 1;
    public static final int SIGNAL_FIRST = 2;
    public static final int SIGNAL_FIRST_WAIT = 3;
    public static final int SIGNAL_LAST = 4;
    public static final int SIGNAL_LAST_WAIT = 5;
    private Set tasks;
    private int signal = 4;
    private boolean createTasks = true;
    private boolean endTasks;

    public static int parseSignal(String text) {
        if ("unsynchronized".equalsIgnoreCase(text)) {
            return 0;
        }
        if ("never".equalsIgnoreCase(text)) {
            return 1;
        }
        if ("first".equalsIgnoreCase(text)) {
            return 2;
        }
        if ("first-wait".equalsIgnoreCase(text)) {
            return 3;
        }
        if ("last-wait".equalsIgnoreCase(text)) {
            return 5;
        }
        return 4;
    }

    public static String signalToString(int signal) {
        switch (signal) {
            case 0: {
                return "unsynchronized";
            }
            case 1: {
                return "never";
            }
            case 2: {
                return "first";
            }
            case 3: {
                return "first-wait";
            }
            case 4: {
                return "last";
            }
            case 5: {
                return "last-wait";
            }
        }
        return null;
    }

    public TaskNode() {
    }

    public TaskNode(String name) {
        super(name);
    }

    public Node.NodeType getNodeType() {
        return Node.NodeType.Task;
    }

    public void read(Element element, JpdlXmlReader jpdlReader) {
        String signalText = element.attributeValue("signal");
        if (signalText != null) {
            this.signal = TaskNode.parseSignal(signalText);
        }
        String createTasksText = element.attributeValue("create-tasks");
        this.createTasks = jpdlReader.readBoolean(createTasksText, true);
        String removeTasksText = element.attributeValue("end-tasks");
        this.endTasks = jpdlReader.readBoolean(removeTasksText, false);
        jpdlReader.readTasks(element, this);
    }

    public void addTask(Task task) {
        if (this.tasks == null) {
            this.tasks = new HashSet();
        }
        task.setTaskNode(this);
        this.tasks.add(task);
    }

    public void execute(ExecutionContext executionContext) {
        boolean continueExecution;
        TaskMgmtInstance tmi = executionContext.getTaskMgmtInstance();
        if (this.createTasks && this.tasks != null) {
            for (Task task : this.tasks) {
                executionContext.setTask(task);
                if (!this.evaluateTaskCondition(task.getCondition(), executionContext)) continue;
                tmi.createTaskInstance(task, executionContext);
            }
        }
        switch (this.signal) {
            case 0: {
                continueExecution = true;
                break;
            }
            case 2: 
            case 4: {
                continueExecution = tmi.getSignallingTasks(executionContext).isEmpty();
                break;
            }
            default: {
                continueExecution = false;
            }
        }
        if (continueExecution) {
            this.leave(executionContext);
        }
    }

    private boolean evaluateTaskCondition(String condition, ExecutionContext executionContext) {
        if (condition == null) {
            return true;
        }
        Boolean result = (Boolean)JbpmExpressionEvaluator.evaluate(condition, executionContext, Boolean.class);
        return Boolean.TRUE.equals(result);
    }

    public void leave(ExecutionContext executionContext, Transition transition) {
        Token token;
        TaskMgmtInstance tmi = executionContext.getTaskMgmtInstance();
        if (tmi.hasBlockingTaskInstances(token = executionContext.getToken())) {
            throw new IllegalStateException(this + " still has blocking tasks");
        }
        this.removeTaskInstanceSynchronization(token);
        super.leave(executionContext, transition);
    }

    public boolean completionTriggersSignal(TaskInstance taskInstance) {
        boolean completionTriggersSignal;
        switch (this.signal) {
            case 2: 
            case 3: {
                completionTriggersSignal = true;
                break;
            }
            case 4: 
            case 5: {
                completionTriggersSignal = this.isLastToComplete(taskInstance);
                break;
            }
            default: {
                completionTriggersSignal = false;
            }
        }
        return completionTriggersSignal;
    }

    private boolean isLastToComplete(TaskInstance taskInstance) {
        Token token = taskInstance.getToken();
        TaskMgmtInstance tmi = taskInstance.getTaskMgmtInstance();
        boolean isLastToComplete = true;
        Iterator iter = tmi.getTaskInstances().iterator();
        while (iter.hasNext() && isLastToComplete) {
            TaskInstance other = (TaskInstance)iter.next();
            if (token == null || !token.equals(other.getToken()) || other.equals(taskInstance) || !other.isSignalling() || other.hasEnded()) continue;
            isLastToComplete = false;
        }
        return isLastToComplete;
    }

    public void removeTaskInstanceSynchronization(Token token) {
        TaskMgmtInstance tmi = token.getProcessInstance().getTaskMgmtInstance();
        Collection taskInstances = tmi.getTaskInstances();
        if (taskInstances != null) {
            for (TaskInstance taskInstance : taskInstances) {
                if (!token.equals(taskInstance.getToken())) continue;
                if (taskInstance.isSignalling()) {
                    taskInstance.setSignalling(false);
                }
                if (taskInstance.isBlocking()) {
                    taskInstance.setBlocking(false);
                }
                if (taskInstance.hasEnded() || !this.endTasks || !this.tasks.contains(taskInstance.getTask())) continue;
                taskInstance.end();
            }
        }
    }

    public Map getTasksMap() {
        HashMap<String, Task> tasksMap = new HashMap<String, Task>();
        if (this.tasks != null) {
            for (Task task : this.tasks) {
                tasksMap.put(task.getName(), task);
            }
        }
        return tasksMap;
    }

    public Task getTask(String taskName) {
        return (Task)this.getTasksMap().get(taskName);
    }

    public Set getTasks() {
        return this.tasks;
    }

    public int getSignal() {
        return this.signal;
    }

    public boolean getCreateTasks() {
        return this.createTasks;
    }

    public boolean isEndTasks() {
        return this.endTasks;
    }

    public void setCreateTasks(boolean createTasks) {
        this.createTasks = createTasks;
    }

    public void setEndTasks(boolean endTasks) {
        this.endTasks = endTasks;
    }

    public void setSignal(int signal) {
        this.signal = signal;
    }

    public void setTasks(Set tasks) {
        this.tasks = tasks;
    }
}

