/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.contexts;

import org.jboss.seam.contexts.PassivatedEntity;
import org.jboss.seam.contexts.Wrapper;

abstract class AbstractEntityBeanCollection
implements Wrapper {
    private transient boolean initialized = true;

    protected AbstractEntityBeanCollection() {
    }

    @Override
    public final void activate() {
        if (this.isPassivatedEntitiesInitialized() && this.isAnyVersioned()) {
            this.activateAll();
            this.initialized = true;
        } else {
            this.initialized = false;
        }
    }

    @Override
    public final Object getInstance() {
        if (!this.initialized && this.isPassivatedEntitiesInitialized()) {
            this.activateAll();
        }
        this.initialized = true;
        return this.getEntityCollection();
    }

    @Override
    public final boolean passivate() {
        if (PassivatedEntity.isTransactionRolledBackOrMarkedRollback()) {
            this.clearPassivatedEntities();
        } else {
            this.passivateAll();
        }
        return true;
    }

    private boolean isAnyVersioned() {
        for (PassivatedEntity passivatedEntity : this.getPassivatedEntities()) {
            if (passivatedEntity == null || !passivatedEntity.isVersioned()) continue;
            return true;
        }
        return false;
    }

    protected abstract void activateAll();

    protected abstract void passivateAll();

    protected abstract Iterable<PassivatedEntity> getPassivatedEntities();

    protected abstract void clearPassivatedEntities();

    protected abstract boolean isPassivatedEntitiesInitialized();

    protected abstract Object getEntityCollection();
}

