/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.framework;

import javax.persistence.EntityManager;
import javax.transaction.SystemException;
import org.jboss.seam.annotations.Transactional;
import org.jboss.seam.framework.Home;
import org.jboss.seam.persistence.PersistenceProvider;
import org.jboss.seam.transaction.Transaction;

public class EntityHome<E>
extends Home<EntityManager, E> {
    private static final long serialVersionUID = -3140094990727574632L;

    @Override
    public void create() {
        super.create();
        if (this.getEntityManager() == null) {
            throw new IllegalStateException("entityManager is null");
        }
    }

    @Transactional
    public boolean isManaged() {
        return this.getInstance() != null && this.getEntityManager().contains(this.getInstance());
    }

    @Transactional
    public String update() {
        this.joinTransaction();
        this.getEntityManager().flush();
        this.updatedMessage();
        this.raiseAfterTransactionSuccessEvent();
        return "updated";
    }

    @Transactional
    public String persist() {
        this.getEntityManager().persist(this.getInstance());
        this.getEntityManager().flush();
        this.assignId(PersistenceProvider.instance().getId(this.getInstance(), this.getEntityManager()));
        this.createdMessage();
        this.raiseAfterTransactionSuccessEvent();
        return "persisted";
    }

    @Transactional
    public String remove() {
        this.getEntityManager().remove(this.getInstance());
        this.getEntityManager().flush();
        this.deletedMessage();
        this.raiseAfterTransactionSuccessEvent();
        return "removed";
    }

    @Override
    @Transactional
    public E find() {
        if (this.getEntityManager().isOpen()) {
            E result = this.loadInstance();
            if (result == null) {
                result = this.handleNotFound();
            }
            return result;
        }
        return null;
    }

    protected E loadInstance() {
        return (E)this.getEntityManager().find(this.getEntityClass(), this.getId());
    }

    @Override
    protected void joinTransaction() {
        if (this.getEntityManager().isOpen()) {
            try {
                Transaction.instance().enlist(this.getEntityManager());
            }
            catch (SystemException se) {
                throw new RuntimeException("could not join transaction", se);
            }
        }
    }

    public EntityManager getEntityManager() {
        return (EntityManager)this.getPersistenceContext();
    }

    public void setEntityManager(EntityManager entityManager) {
        this.setPersistenceContext(entityManager);
    }

    @Override
    protected String getPersistenceContextName() {
        return "entityManager";
    }

    @Override
    protected String getEntityName() {
        try {
            return PersistenceProvider.instance().getName(this.getInstance(), this.getEntityManager());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }
}

