/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.mux;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.ChannelClosedException;
import org.jgroups.ChannelNotConnectedException;
import org.jgroups.Event;
import org.jgroups.JChannel;
import org.jgroups.JChannelFactory;
import org.jgroups.MergeView;
import org.jgroups.Message;
import org.jgroups.TimeoutException;
import org.jgroups.UpHandler;
import org.jgroups.View;
import org.jgroups.mux.MuxChannel;
import org.jgroups.mux.MuxHeader;
import org.jgroups.mux.ServiceInfo;
import org.jgroups.protocols.pbcast.FLUSH;
import org.jgroups.stack.StateTransferInfo;
import org.jgroups.util.Promise;
import org.jgroups.util.Util;

public class Multiplexer
implements UpHandler {
    private final Map services = new HashMap();
    private final JChannel channel;
    static final Log log = LogFactory.getLog((Class)Multiplexer.class);
    static final String SEPARATOR = "::";
    static final short SEPARATOR_LEN = (short)"::".length();
    static final String NAME = "MUX";
    private final BlockOkCollector block_ok_collector = new BlockOkCollector();
    private MergeView temp_merge_view = null;
    private boolean flush_present = true;
    private boolean blocked = false;
    View view = null;
    Address local_addr = null;
    private final Map state_transfer_listeners = new HashMap();
    private final Map service_state = new HashMap();
    private final Promise service_state_promise = new Promise();
    private final Map service_responses = new HashMap();
    private long SERVICES_RSP_TIMEOUT = 10000L;

    public Multiplexer() {
        this.channel = null;
        this.flush_present = this.isFlushPresent();
    }

    public Multiplexer(JChannel channel) {
        this.channel = channel;
        this.channel.setUpHandler(this);
        this.channel.setOpt(0, Boolean.TRUE);
        this.flush_present = this.isFlushPresent();
    }

    public Set getApplicationIds() {
        return this.services != null ? this.services.keySet() : null;
    }

    public Set getServiceIds() {
        return this.services != null ? this.services.keySet() : null;
    }

    public long getServicesResponseTimeout() {
        return this.SERVICES_RSP_TIMEOUT;
    }

    public void setServicesResponseTimeout(long services_rsp_timeout) {
        this.SERVICES_RSP_TIMEOUT = services_rsp_timeout;
    }

    public View getServiceView(String service_id) {
        List hosts = (List)this.service_state.get(service_id);
        if (hosts == null) {
            return null;
        }
        return this.generateServiceView(hosts);
    }

    public boolean stateTransferListenersPresent() {
        return this.state_transfer_listeners != null && this.state_transfer_listeners.size() > 0;
    }

    public void blockOk() {
        this.block_ok_collector.increment();
    }

    public synchronized void registerForStateTransfer(String appl_id, String substate_id) {
        String key = appl_id;
        if (substate_id != null && substate_id.length() > 0) {
            key = key + SEPARATOR + substate_id;
        }
        this.state_transfer_listeners.put(key, Boolean.FALSE);
    }

    public synchronized boolean getState(Address target, String id, long timeout) throws ChannelNotConnectedException, ChannelClosedException {
        Collection values;
        boolean all_true;
        if (this.state_transfer_listeners == null) {
            return false;
        }
        Iterator it = this.state_transfer_listeners.entrySet().iterator();
        while (it.hasNext()) {
            boolean match;
            Map.Entry entry = it.next();
            String key = (String)entry.getKey();
            int index = key.indexOf(SEPARATOR);
            if (index > -1) {
                String tmp = key.substring(0, index);
                match = id.equals(tmp);
            } else {
                match = id.equals(key);
            }
            if (!match) continue;
            entry.setValue(Boolean.TRUE);
            break;
        }
        if (!(all_true = Util.all(values = this.state_transfer_listeners.values(), Boolean.TRUE))) {
            return true;
        }
        boolean rc = false;
        HashSet keys = new HashSet(this.state_transfer_listeners.keySet());
        rc = this.fetchServiceStates(target, keys, timeout);
        this.state_transfer_listeners.clear();
        return rc;
    }

    private boolean fetchServiceStates(Address target, Set keys, long timeout) throws ChannelClosedException, ChannelNotConnectedException {
        boolean all_rcs = true;
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            String appl_id = (String)it.next();
            boolean rc = this.channel.getState(target, appl_id, timeout);
            if (rc) continue;
            all_rcs = false;
        }
        return all_rcs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fetchServiceInformation() throws Exception {
        while (true) {
            boolean is_coord;
            Address coord = this.getCoordinator();
            Address local_address = this.channel != null ? this.channel.getLocalAddress() : null;
            boolean bl = is_coord = coord != null && local_address != null && local_address.equals(coord);
            if (is_coord) {
                if (!log.isTraceEnabled()) break;
                log.trace((Object)"I'm coordinator, will not fetch service state information");
                break;
            }
            ServiceInfo si = new ServiceInfo(1, null, null, null);
            MuxHeader hdr = new MuxHeader(si);
            Message state_req = new Message(coord, null, null);
            state_req.putHeader(NAME, hdr);
            this.service_state_promise.reset();
            this.channel.send(state_req);
            try {
                byte[] state = (byte[])this.service_state_promise.getResultWithTimeout(2000L);
                if (state != null) {
                    Map new_state = (Map)Util.objectFromByteBuffer(state);
                    Map map = this.service_state;
                    synchronized (map) {
                        this.service_state.clear();
                        this.service_state.putAll(new_state);
                    }
                    if (!log.isTraceEnabled()) break;
                    log.trace((Object)("service state was set successfully (" + this.service_state.size() + " entries)"));
                    break;
                }
                if (!log.isWarnEnabled()) break;
                log.warn((Object)"received service state was null");
            }
            catch (TimeoutException e) {
                if (!log.isTraceEnabled()) continue;
                log.trace((Object)("timed out waiting for service state from " + coord + ", retrying"));
                continue;
            }
            break;
        }
    }

    public void sendServiceUpMessage(String service, Address host, boolean bypassFlush) throws Exception {
        this.sendServiceMessage((byte)3, service, host, bypassFlush);
        if (this.local_addr != null && host != null && this.local_addr.equals(host)) {
            this.handleServiceUp(service, host, false);
        }
    }

    public void sendServiceDownMessage(String service, Address host, boolean bypassFlush) throws Exception {
        this.sendServiceMessage((byte)4, service, host, bypassFlush);
        if (this.local_addr != null && host != null && this.local_addr.equals(host)) {
            this.handleServiceDown(service, host, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                msg = (Message)evt.getArg();
                hdr = (MuxHeader)msg.getHeader("MUX");
                if (hdr == null) {
                    Multiplexer.log.error((Object)("MuxHeader not present - discarding message " + msg));
                    return;
                }
                if (hdr.info != null) {
                    try {
                        this.handleServiceStateRequest(hdr.info, msg.getSrc());
                    }
                    catch (Exception e) {
                        if (!Multiplexer.log.isErrorEnabled()) break;
                        Multiplexer.log.error((Object)"failure in handling service state request", (Throwable)e);
                    }
                    break;
                }
                mux_ch = (MuxChannel)this.services.get(hdr.id);
                if (mux_ch == null) {
                    Multiplexer.log.warn((Object)("service " + hdr.id + " not currently running, discarding messgage " + msg));
                    return;
                }
                mux_ch.up(evt);
                break;
            }
            case 6: {
                old_members = this.view != null ? this.view.getMembers() : null;
                this.view = (View)evt.getArg();
                new_members = this.view != null ? this.view.getMembers() : null;
                left_members = Util.determineLeftMembers(old_members, new_members);
                if (this.view instanceof MergeView) {
                    this.temp_merge_view = (MergeView)this.view.clone();
                    if (Multiplexer.log.isTraceEnabled()) {
                        Multiplexer.log.trace((Object)("received a MergeView: " + this.temp_merge_view + ", adjusting the service view"));
                    }
                    if (!this.flush_present && this.temp_merge_view != null) {
                        try {
                            if (Multiplexer.log.isTraceEnabled()) {
                                Multiplexer.log.trace((Object)("calling handleMergeView() from VIEW_CHANGE (flush_present=" + this.flush_present + ")"));
                            }
                            merge_handler = new Thread(){

                                public void run() {
                                    block2: {
                                        try {
                                            Multiplexer.this.handleMergeView(Multiplexer.this.temp_merge_view);
                                        }
                                        catch (Exception e) {
                                            if (!log.isErrorEnabled()) break block2;
                                            log.error((Object)"problems handling merge view", (Throwable)e);
                                        }
                                    }
                                }
                            };
                            merge_handler.setName("merge handler view_change");
                            merge_handler.setDaemon(false);
                            merge_handler.start();
                        }
                        catch (Exception e) {
                            if (Multiplexer.log.isErrorEnabled()) {
                                Multiplexer.log.error((Object)"failed handling merge view", (Throwable)e);
                            }
                        }
                    }
                } else {
                    e = this.service_responses;
                    synchronized (e) {
                        this.service_responses.clear();
                    }
                }
                if (left_members.size() <= 0) break;
                this.adjustServiceViews(left_members);
                break;
            }
            case 9: {
                suspected_mbr = (Address)evt.getArg();
                var9_14 = this.service_responses;
                synchronized (var9_14) {
                    this.service_responses.put(suspected_mbr, null);
                    this.service_responses.notifyAll();
                }
                this.passToAllMuxChannels(evt);
                break;
            }
            case 17: 
            case 72: {
                this.handleStateRequest(evt);
                break;
            }
            case 20: 
            case 71: {
                this.handleStateResponse(evt);
                break;
            }
            case 8: {
                this.local_addr = (Address)evt.getArg();
                this.passToAllMuxChannels(evt);
                break;
            }
            case 10: {
                this.blocked = true;
                num_services = this.services.size();
                if (num_services == 0) {
                    this.channel.blockOk();
                    return;
                }
                this.block_ok_collector.reset();
                this.passToAllMuxChannels(evt);
                this.block_ok_collector.waitUntil(num_services);
                this.channel.blockOk();
                return;
            }
            case 75: {
                if (!this.blocked) {
                    this.passToAllMuxChannels(evt);
                    return;
                }
                this.blocked = false;
                if (this.temp_merge_view == null) ** GOTO lbl106
                if (Multiplexer.log.isTraceEnabled()) {
                    Multiplexer.log.trace((Object)("calling handleMergeView() from UNBLOCK (flush_present=" + this.flush_present + ")"));
                }
                try {
                    merge_handler = new Thread(){

                        public void run() {
                            block2: {
                                try {
                                    Multiplexer.this.handleMergeView(Multiplexer.this.temp_merge_view);
                                }
                                catch (Exception e) {
                                    if (!log.isErrorEnabled()) break block2;
                                    log.error((Object)"problems handling merge view", (Throwable)e);
                                }
                            }
                        }
                    };
                    merge_handler.setName("merge handler (unblock)");
                    merge_handler.setDaemon(false);
                    merge_handler.start();
                }
                catch (Exception e) {
                    if (!Multiplexer.log.isErrorEnabled()) ** GOTO lbl106
                    Multiplexer.log.error((Object)"failed handling merge view", (Throwable)e);
                }
lbl106:
                // 4 sources

                this.passToAllMuxChannels(evt);
                break;
            }
            default: {
                this.passToAllMuxChannels(evt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Channel createMuxChannel(JChannelFactory f, String id, String stack_name) throws Exception {
        MuxChannel ch;
        Map map = this.services;
        synchronized (map) {
            if (this.services.containsKey(id)) {
                throw new Exception("service ID \"" + id + "\" is already registered, cannot register duplicate ID");
            }
            ch = new MuxChannel(f, this.channel, id, stack_name, this);
            this.services.put(id, ch);
        }
        return ch;
    }

    private void passToAllMuxChannels(Event evt) {
        Iterator it = this.services.values().iterator();
        while (it.hasNext()) {
            MuxChannel ch = (MuxChannel)it.next();
            ch.up(evt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MuxChannel remove(String id) {
        Map map = this.services;
        synchronized (map) {
            return (MuxChannel)this.services.remove(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        boolean all_disconnected = true;
        Map map = this.services;
        synchronized (map) {
            Iterator it = this.services.values().iterator();
            while (it.hasNext()) {
                MuxChannel mux_ch = (MuxChannel)it.next();
                if (!mux_ch.isConnected()) continue;
                all_disconnected = false;
                break;
            }
            if (all_disconnected) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"disconnecting underlying JChannel as all MuxChannels are disconnected");
                }
                this.channel.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(String appl_id) {
        Map map = this.services;
        synchronized (map) {
            this.services.remove(appl_id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean close() {
        boolean all_closed = true;
        Map map = this.services;
        synchronized (map) {
            Iterator it = this.services.values().iterator();
            while (it.hasNext()) {
                MuxChannel mux_ch = (MuxChannel)it.next();
                if (!mux_ch.isOpen()) continue;
                all_closed = false;
                break;
            }
            if (all_closed) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"closing underlying JChannel as all MuxChannels are closed");
                }
                this.channel.close();
                this.services.clear();
            }
            return all_closed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAll() {
        Map map = this.services;
        synchronized (map) {
            Iterator it = this.services.values().iterator();
            while (it.hasNext()) {
                MuxChannel mux_ch = (MuxChannel)it.next();
                mux_ch.setConnected(false);
                mux_ch.setClosed(true);
                mux_ch.closeMessageQueue(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shutdown() {
        boolean all_closed = true;
        Map map = this.services;
        synchronized (map) {
            Iterator it = this.services.values().iterator();
            while (it.hasNext()) {
                MuxChannel mux_ch = (MuxChannel)it.next();
                if (!mux_ch.isOpen()) continue;
                all_closed = false;
                break;
            }
            if (all_closed) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"shutting down underlying JChannel as all MuxChannels are closed");
                }
                this.channel.shutdown();
                this.services.clear();
            }
            return all_closed;
        }
    }

    private boolean isFlushPresent() {
        return this.channel.getProtocolStack().findProtocol("FLUSH") != null;
    }

    private void sendServiceState() throws Exception {
        Object[] my_services = this.services.keySet().toArray();
        byte[] data = Util.objectToByteBuffer(my_services);
        ServiceInfo sinfo = new ServiceInfo(5, null, this.channel.getLocalAddress(), data);
        Message rsp = new Message();
        MuxHeader hdr = new MuxHeader(sinfo);
        rsp.putHeader(NAME, hdr);
        this.channel.send(rsp);
    }

    private Address getLocalAddress() {
        if (this.local_addr != null) {
            return this.local_addr;
        }
        if (this.channel != null) {
            this.local_addr = this.channel.getLocalAddress();
        }
        return this.local_addr;
    }

    private Address getCoordinator() {
        Vector members;
        View v;
        if (this.channel != null && (v = this.channel.getView()) != null && (members = v.getMembers()) != null && members.size() > 0) {
            return (Address)members.firstElement();
        }
        return null;
    }

    public Address getServiceCoordinator(String service_id) {
        List hosts = (List)this.service_state.get(service_id);
        if (hosts == null || hosts.size() == 0) {
            return null;
        }
        return (Address)hosts.get(0);
    }

    private void sendServiceMessage(byte type, String service, Address host, boolean bypassFlush) throws Exception {
        if (host == null) {
            host = this.getLocalAddress();
        }
        if (host == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("local_addr is null, cannot send ServiceInfo." + ServiceInfo.typeToString(type) + " message"));
            }
            return;
        }
        ServiceInfo si = new ServiceInfo(type, service, host, null);
        MuxHeader hdr = new MuxHeader(si);
        Message service_msg = new Message();
        service_msg.putHeader(NAME, hdr);
        if (bypassFlush) {
            service_msg.putHeader("FLUSH", new FLUSH.FlushHeader(6));
        }
        this.channel.send(service_msg);
    }

    private void handleStateRequest(Event evt) {
        String id;
        StateTransferInfo info = (StateTransferInfo)evt.getArg();
        String original_id = id = info.state_id;
        MuxChannel mux_ch = null;
        try {
            int index = id.indexOf(SEPARATOR);
            if (index > -1) {
                info.state_id = id.substring(index + SEPARATOR_LEN);
                id = id.substring(0, index);
            } else {
                info.state_id = null;
            }
            mux_ch = (MuxChannel)this.services.get(id);
            if (mux_ch == null) {
                throw new IllegalArgumentException("didn't find service with ID=" + id + " to fetch state from");
            }
            mux_ch.up(evt);
        }
        catch (Throwable ex) {
            if (log.isErrorEnabled()) {
                log.error((Object)"failed returning the application state, will return null", ex);
            }
            this.channel.returnState(null, original_id);
        }
    }

    private void handleStateResponse(Event evt) {
        String substate_id;
        String appl_id;
        StateTransferInfo info = (StateTransferInfo)evt.getArg();
        String tmp = info.state_id;
        if (tmp == null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("state is null, not passing up: " + info));
            }
            return;
        }
        int index = tmp.indexOf(SEPARATOR);
        if (index > -1) {
            appl_id = tmp.substring(0, index);
            substate_id = tmp.substring(index + SEPARATOR_LEN);
        } else {
            appl_id = tmp;
            substate_id = null;
        }
        MuxChannel mux_ch = (MuxChannel)this.services.get(appl_id);
        if (mux_ch == null) {
            log.error((Object)("didn't find service with ID=" + appl_id + " to fetch state from"));
        } else {
            StateTransferInfo tmp_info = info.copy();
            tmp_info.state_id = substate_id;
            evt.setArg(tmp_info);
            mux_ch.up(evt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleServiceStateRequest(ServiceInfo info, Address sender) throws Exception {
        switch (info.type) {
            case 1: {
                byte[] state;
                Map map = this.service_state;
                synchronized (map) {
                    state = Util.objectToByteBuffer(this.service_state);
                }
                ServiceInfo si = new ServiceInfo(2, null, null, state);
                MuxHeader hdr = new MuxHeader(si);
                Message state_rsp = new Message(sender);
                state_rsp.putHeader(NAME, hdr);
                this.channel.send(state_rsp);
                break;
            }
            case 2: {
                this.service_state_promise.setResult(info.state);
                break;
            }
            case 3: {
                this.handleServiceUp(info.service, info.host, true);
                break;
            }
            case 4: {
                this.handleServiceDown(info.service, info.host, true);
                break;
            }
            case 5: {
                this.handleServicesRsp(sender, info.state);
                break;
            }
            default: {
                if (!log.isErrorEnabled()) break;
                log.error((Object)("service request type " + info.type + " not known"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleServicesRsp(Address sender, byte[] state) throws Exception {
        Object[] keys = (Object[])Util.objectFromByteBuffer(state);
        HashSet<Object> s = new HashSet<Object>();
        for (int i = 0; i < keys.length; ++i) {
            s.add(keys[i]);
        }
        Map map = this.service_responses;
        synchronized (map) {
            HashSet tmp = (HashSet)this.service_responses.get(sender);
            if (tmp == null) {
                tmp = new HashSet();
            }
            tmp.addAll(s);
            this.service_responses.put(sender, tmp);
            if (log.isTraceEnabled()) {
                log.trace((Object)("received service response: " + sender + "(" + ((Object)s).toString() + ")"));
            }
            this.service_responses.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleServiceDown(String service, Address host, boolean received) {
        Address local_address;
        View service_view;
        ArrayList hosts_copy;
        boolean removed = false;
        if (received && host != null && this.local_addr != null && this.local_addr.equals(host)) {
            return;
        }
        Map map = this.service_state;
        synchronized (map) {
            List hosts = (List)this.service_state.get(service);
            if (hosts == null) {
                return;
            }
            removed = hosts.remove(host);
            hosts_copy = new ArrayList(hosts);
        }
        if (removed && (service_view = this.generateServiceView(hosts_copy)) != null) {
            MuxChannel ch = (MuxChannel)this.services.get(service);
            if (ch != null) {
                Event view_evt = new Event(6, service_view);
                ch.up(view_evt);
            } else if (log.isTraceEnabled()) {
                log.trace((Object)("service " + service + " not found, cannot dispatch service view " + service_view));
            }
        }
        if ((local_address = this.getLocalAddress()) != null && host != null && host.equals(local_address)) {
            this.unregister(service);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleServiceUp(String service, Address host, boolean received) {
        View service_view;
        ArrayList hosts_copy;
        boolean added = false;
        if (received && host != null && this.local_addr != null && this.local_addr.equals(host)) {
            return;
        }
        Map map = this.service_state;
        synchronized (map) {
            ArrayList<Address> hosts = (ArrayList<Address>)this.service_state.get(service);
            if (hosts == null) {
                hosts = new ArrayList<Address>();
                this.service_state.put(service, hosts);
            }
            if (!hosts.contains(host)) {
                hosts.add(host);
                added = true;
            }
            hosts_copy = new ArrayList(hosts);
        }
        if (added && (service_view = this.generateServiceView(hosts_copy)) != null) {
            MuxChannel ch = (MuxChannel)this.services.get(service);
            if (ch != null) {
                Event view_evt = new Event(6, service_view);
                ch.up(view_evt);
            } else if (log.isTraceEnabled()) {
                log.trace((Object)("service " + service + " not found, cannot dispatch service view " + service_view));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMergeView(MergeView view) throws Exception {
        int num_members = view.size();
        HashMap copy = null;
        this.sendServiceState();
        Map map = this.service_responses;
        synchronized (map) {
            block7: {
                long start = System.currentTimeMillis();
                try {
                    for (long time_to_wait = this.SERVICES_RSP_TIMEOUT; time_to_wait > 0L && this.numResponses(this.service_responses) < num_members; time_to_wait -= System.currentTimeMillis() - start) {
                        this.service_responses.wait(time_to_wait);
                    }
                    copy = new HashMap(this.service_responses);
                }
                catch (Exception ex) {
                    if (!log.isErrorEnabled()) break block7;
                    log.error((Object)("failed fetching a list of services from other members in the cluster, cannot handle merge view " + view), (Throwable)ex);
                }
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("merging service state, my service_state: " + this.service_state + ", received responses: " + copy));
        }
        this.mergeServiceState(view, copy);
        this.service_responses.clear();
        this.temp_merge_view = null;
    }

    private int numResponses(Map m) {
        int num = 0;
        Collection values = m.values();
        Iterator it = values.iterator();
        while (it.hasNext()) {
            if (it.next() == null) continue;
            ++num;
        }
        return num;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeServiceState(MergeView view, Map copy) {
        List<Address> my_services;
        String service;
        HashSet<String> modified_services = new HashSet<String>();
        Map map = this.service_state;
        synchronized (map) {
            Iterator it = copy.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                Address host = (Address)entry.getKey();
                Set service_list = (Set)entry.getValue();
                if (service_list == null) continue;
                Iterator it2 = service_list.iterator();
                while (it2.hasNext()) {
                    boolean was_modified;
                    service = (String)it2.next();
                    my_services = (List)this.service_state.get(service);
                    if (my_services == null) {
                        my_services = new ArrayList<Address>();
                        this.service_state.put(service, my_services);
                    }
                    if (!(was_modified = my_services.add(host))) continue;
                    modified_services.add(service);
                }
            }
        }
        Iterator it = modified_services.iterator();
        while (it.hasNext()) {
            service = (String)it.next();
            MuxChannel ch = (MuxChannel)this.services.get(service);
            my_services = (ArrayList<Address>)this.service_state.get(service);
            MergeView v = (MergeView)view.clone();
            v.getMembers().retainAll(my_services);
            Event evt = new Event(6, v);
            ch.up(evt);
        }
    }

    private void adjustServiceViews(Vector left_members) {
        if (left_members != null) {
            for (int i = 0; i < left_members.size(); ++i) {
                try {
                    this.adjustServiceView((Address)left_members.elementAt(i));
                    continue;
                }
                catch (Throwable t) {
                    if (!log.isErrorEnabled()) continue;
                    log.error((Object)"failed adjusting service views", t);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void adjustServiceView(Address host) {
        boolean removed = false;
        Map map = this.service_state;
        synchronized (map) {
            Iterator it = this.service_state.entrySet().iterator();
            while (it.hasNext()) {
                Address local_address;
                View service_view;
                Map.Entry entry = it.next();
                String service = (String)entry.getKey();
                List hosts = (List)entry.getValue();
                if (hosts == null) continue;
                removed = hosts.remove(host);
                ArrayList hosts_copy = new ArrayList(hosts);
                if (removed && (service_view = this.generateServiceView(hosts_copy)) != null) {
                    MuxChannel ch = (MuxChannel)this.services.get(service);
                    if (ch != null) {
                        Event view_evt = new Event(6, service_view);
                        ch.up(view_evt);
                    } else if (log.isTraceEnabled()) {
                        log.trace((Object)("service " + service + " not found, cannot dispatch service view " + service_view));
                    }
                }
                if ((local_address = this.getLocalAddress()) == null || host == null || !host.equals(local_address)) continue;
                this.unregister(service);
            }
        }
    }

    private View generateServiceView(List hosts) {
        Vector members = new Vector(this.view.getMembers());
        members.retainAll(hosts);
        return new View(this.view.getVid(), members);
    }

    private void startFlush() {
        this.channel.down(new Event(68));
    }

    private void stopFlush() {
        this.channel.down(new Event(70));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addServiceIfNotPresent(String id, MuxChannel ch) {
        Map map = this.services;
        synchronized (map) {
            MuxChannel tmp = (MuxChannel)this.services.get(id);
            if (tmp == null) {
                this.services.put(id, ch);
            }
        }
    }

    private static class BlockOkCollector {
        int num_block_oks = 0;

        private BlockOkCollector() {
        }

        synchronized void reset() {
            this.num_block_oks = 0;
        }

        synchronized void increment() {
            ++this.num_block_oks;
        }

        synchronized void waitUntil(int num) {
            while (this.num_block_oks < num) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        public String toString() {
            return String.valueOf(this.num_block_oks);
        }
    }
}

