/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.aether.ant.com.ning.http.client.generators;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.sonatype.aether.ant.com.ning.http.client.Body;
import org.sonatype.aether.ant.com.ning.http.client.BodyGenerator;

public class ByteArrayBodyGenerator
implements BodyGenerator {
    private final byte[] bytes;

    public ByteArrayBodyGenerator(byte[] bytes) {
        this.bytes = bytes;
    }

    public Body createBody() throws IOException {
        return new ByteBody();
    }

    protected final class ByteBody
    implements Body {
        private boolean eof = false;
        private int lastPosition = 0;

        protected ByteBody() {
        }

        public long getContentLength() {
            return ByteArrayBodyGenerator.this.bytes.length;
        }

        public long read(ByteBuffer byteBuffer) throws IOException {
            if (this.eof) {
                return -1L;
            }
            if (ByteArrayBodyGenerator.this.bytes.length - this.lastPosition <= byteBuffer.capacity()) {
                byteBuffer.put(ByteArrayBodyGenerator.this.bytes, this.lastPosition, ByteArrayBodyGenerator.this.bytes.length);
                this.eof = true;
            } else {
                byteBuffer.put(ByteArrayBodyGenerator.this.bytes, this.lastPosition, byteBuffer.capacity());
                this.lastPosition = ByteArrayBodyGenerator.this.bytes.length - byteBuffer.capacity();
            }
            return ByteArrayBodyGenerator.this.bytes.length;
        }

        public void close() throws IOException {
            this.lastPosition = 0;
            this.eof = false;
        }
    }
}

