/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.ioc.spring;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jboss.seam.Component;
import org.jboss.seam.ioc.spring.SeamLifecycleUtils;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.util.ClassUtils;

public class SeamManagedSessionFactoryBean
extends AbstractFactoryBean {
    private String sessionName;
    private SessionFactory baseSessionFactory;

    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        if (this.sessionName == null || "".equals(this.sessionName)) {
            throw new IllegalArgumentException("SesssionName cannot be empty");
        }
    }

    protected Object createInstance() throws Exception {
        Class[] sessionFactoryInterfaces = this.baseSessionFactory != null ? ClassUtils.getAllInterfaces((Object)this.baseSessionFactory) : new Class[]{SessionFactory.class};
        return Proxy.newProxyInstance(((Object)((Object)this)).getClass().getClassLoader(), sessionFactoryInterfaces, (InvocationHandler)new SeamManagedSessionFactoryHandler(this.sessionName, this.baseSessionFactory));
    }

    public Class getObjectType() {
        if (this.baseSessionFactory != null) {
            return this.baseSessionFactory.getClass();
        }
        return SessionFactory.class;
    }

    public void setBaseSessionFactory(SessionFactory baseSessionFactory) {
        this.baseSessionFactory = baseSessionFactory;
    }

    @Required
    public void setSessionName(String sessionName) {
        this.sessionName = sessionName;
    }

    public static class SeamManagedSessionHandler
    implements InvocationHandler,
    Serializable {
        private static final LogProvider log = Logging.getLogProvider(SeamManagedSessionHandler.class);
        private Session delegate;
        private SessionFactory sessionFactory;
        private boolean closed = false;

        public SeamManagedSessionHandler(SessionFactory sessionFactory, Session delegate) {
            this.delegate = delegate;
            this.sessionFactory = sessionFactory;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("getSessionFactory")) {
                return this.sessionFactory;
            }
            if (method.getName().equals("equals")) {
                return proxy == args[0] ? Boolean.TRUE : Boolean.FALSE;
            }
            if (method.getName().equals("hashCode")) {
                return new Integer(this.hashCode());
            }
            if (method.getName().equals("isOpen")) {
                return this.delegate.isOpen() && !this.closed;
            }
            if (!this.delegate.isOpen()) {
                try {
                    return method.invoke((Object)this.delegate, args);
                }
                catch (InvocationTargetException ex) {
                    throw ex.getTargetException();
                }
            }
            if (this.closed) {
                throw new IllegalStateException("This Session is closed.");
            }
            if (method.getName().equals("close")) {
                log.debug((Object)"Closing Session Proxy.");
                this.delegate.disconnect();
                this.closed = true;
                return null;
            }
            try {
                return method.invoke((Object)this.delegate, args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
    }

    public static class SeamManagedSessionFactoryHandler
    implements InvocationHandler,
    Serializable {
        private SessionFactory rawSessionFactory;
        private String sessionName;
        private boolean isClosed = false;

        public SeamManagedSessionFactoryHandler(String sessionName, SessionFactory rawSessionFactory) {
            this.rawSessionFactory = rawSessionFactory;
            this.sessionName = sessionName;
        }

        private synchronized SessionFactory getRawSessionFactory() {
            if (this.rawSessionFactory == null) {
                this.rawSessionFactory = this.getSession().getSessionFactory();
            }
            return this.rawSessionFactory;
        }

        private Session getSession() {
            SeamLifecycleUtils.beginTransactionalSeamCall();
            return (Session)Component.getInstance((String)this.sessionName);
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("equals")) {
                return proxy == args[0] ? Boolean.TRUE : Boolean.FALSE;
            }
            if (method.getName().equals("hashCode")) {
                return new Integer(this.hashCode());
            }
            SessionFactory delegate = this.getRawSessionFactory();
            if (method.getName().equals("isClosed")) {
                return delegate.isClosed() || this.isClosed;
            }
            if (delegate.isClosed()) {
                try {
                    return method.invoke((Object)delegate, args);
                }
                catch (InvocationTargetException ex) {
                    throw ex.getTargetException();
                }
            }
            if (this.isClosed) {
                throw new IllegalStateException("This SessionFactory is closed.");
            }
            if (method.getName().equals("close")) {
                Session session = this.getSession();
                session.disconnect();
                this.isClosed = true;
                return null;
            }
            if (method.getName().equals("getCurrentSession")) {
                try {
                    return this.getSession();
                }
                catch (IllegalStateException ex) {
                    throw new HibernateException(ex.getMessage());
                }
            }
            if (method.getName().equals("openSession")) {
                if (method.getParameterTypes().length == 0) {
                    Session session = this.getSession();
                    ClassUtils.getAllInterfaces((Object)session);
                    ArrayList<Class> interfaces = new ArrayList<Class>(Arrays.asList(ClassUtils.getAllInterfaces((Object)session)));
                    interfaces.add(Session.class);
                    return Proxy.newProxyInstance(this.getClass().getClassLoader(), interfaces.toArray(new Class[interfaces.size()]), (InvocationHandler)new SeamManagedSessionHandler((SessionFactory)proxy, session));
                }
                throw new HibernateException("This SeamManagedSessionFactory will only return a session from a call to noarg openSession()");
            }
            if (method.getName().equals("openStatelessSession")) {
                throw new HibernateException("This SessionFactory does not support StatelessSessions");
            }
            if (method.getName().equals("getReference")) {
                throw new HibernateException("A SeamManagedSessionFactory is not referencable.  If this is a requirement file a feature request.");
            }
            try {
                if (method.getDeclaringClass().equals(Session.class) && !(delegate instanceof Session)) {
                    throw new UnsupportedOperationException("Unable to execute method: " + method.toString() + " Seam managed session does not support classic.Session methods.");
                }
                return method.invoke((Object)delegate, args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
    }
}

