/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.ioc.spring;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpSessionActivationListener;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.contexts.Lifecycle;
import org.jboss.seam.core.Expressions;
import org.jboss.seam.core.Mutable;
import org.jboss.seam.intercept.Proxy;
import org.springframework.aop.TargetSource;

public class SeamTargetSource
implements TargetSource,
Serializable {
    private ScopeType scope;
    private String name;
    private Boolean create;
    private Expressions.ValueExpression valueExpression;
    private Class type;

    public SeamTargetSource(String name, ScopeType scope, Boolean create, Class type) {
        this(name, scope, create);
        this.type = type;
    }

    public SeamTargetSource(String name, ScopeType scope, Boolean create) {
        if (name == null || "".equals(name)) {
            throw new IllegalArgumentException("Name is required.");
        }
        this.name = name;
        this.scope = scope;
        this.create = create;
        if (name.startsWith("#")) {
            this.valueExpression = Expressions.instance().createValueExpression(name);
        }
    }

    public Object getTarget() throws Exception {
        if (this.valueExpression != null) {
            return this.valueExpression.getValue();
        }
        if (this.scope == null && this.create == null) {
            return Component.getInstance((String)this.name);
        }
        if (this.scope == null) {
            return Component.getInstance((String)this.name, (boolean)this.create);
        }
        if (this.create == null) {
            return Component.getInstance((String)this.name, (ScopeType)this.scope);
        }
        return Component.getInstance((String)this.name, (ScopeType)this.scope, (boolean)this.create);
    }

    public Class getTargetClass() {
        if (this.type != null) {
            return this.type;
        }
        Component component = this.getComponent();
        if (component == null) {
            return null;
        }
        if (component.hasUnwrapMethod()) {
            return component.getUnwrapMethod().getReturnType();
        }
        return component.getBeanClass();
    }

    public List<Class> getSeamInterfaces() {
        ArrayList<Class> interfaces = new ArrayList<Class>();
        Component component = this.getComponent();
        if (component != null && component.isInterceptionEnabled()) {
            if (component.getType().isSessionBean()) {
                interfaces.addAll(component.getBusinessInterfaces());
            } else {
                interfaces.add(HttpSessionActivationListener.class);
                interfaces.add(Mutable.class);
            }
            interfaces.add(Proxy.class);
        }
        return interfaces;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component getComponent() {
        if (this.valueExpression != null) {
            return null;
        }
        boolean unmockApplication = false;
        if (!Contexts.isApplicationContextActive()) {
            Lifecycle.setupApplication();
            unmockApplication = true;
        }
        try {
            Component component = Component.forName((String)this.name);
            if (component == null) {
                throw new IllegalStateException("Cannot find targetClass for seam component: " + this.name + ".  Make sure Seam is being configured before Spring.");
            }
            Component component2 = component;
            return component2;
        }
        finally {
            if (unmockApplication) {
                Lifecycle.cleanupApplication();
            }
        }
    }

    public boolean isStatic() {
        return false;
    }

    public void releaseTarget(Object target) throws Exception {
    }
}

