/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.ide.completion;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.tool.ide.completion.EntityNameReference;

class CompletionHelper {
    private CompletionHelper() {
    }

    public static String getCanonicalPath(List qts, String name) {
        HashMap<String, String> alias2Type = new HashMap<String, String>();
        for (EntityNameReference qt : qts) {
            alias2Type.put(qt.getAlias(), qt.getEntityName());
        }
        if (qts.size() == 1) {
            EntityNameReference visible = (EntityNameReference)qts.get(0);
            String alias = visible.getAlias();
            if (name.equals(alias)) {
                return visible.getEntityName();
            }
            if (alias == null || alias.length() == 0 || alias.equals(visible.getEntityName())) {
                return visible.getEntityName() + "/" + name;
            }
        }
        return CompletionHelper.getCanonicalPath(new HashSet(), alias2Type, name);
    }

    private static String getCanonicalPath(Set resolved, Map alias2Type, String name) {
        if (resolved.contains(name)) {
            return name;
        }
        resolved.add(name);
        String type = (String)alias2Type.get(name);
        if (type != null) {
            return name.equals(type) ? name : CompletionHelper.getCanonicalPath(resolved, alias2Type, type);
        }
        int idx = name.lastIndexOf(46);
        if (idx == -1) {
            return type != null ? type : name;
        }
        String baseName = name.substring(0, idx);
        String prop = name.substring(idx + 1);
        if (CompletionHelper.isAliasNown(alias2Type, baseName)) {
            return CompletionHelper.getCanonicalPath(resolved, alias2Type, baseName) + "/" + prop;
        }
        return name;
    }

    private static boolean isAliasNown(Map alias2Type, String alias) {
        if (alias2Type.containsKey(alias)) {
            return true;
        }
        int idx = alias.lastIndexOf(46);
        if (idx == -1) {
            return false;
        }
        return CompletionHelper.isAliasNown(alias2Type, alias.substring(0, idx));
    }
}

