/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.server.servlet;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.RuntimeDelegate;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.util.CaseInsensitiveMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpServletResponseHeaders
implements MultivaluedMap<String, Object> {
    private CaseInsensitiveMap cachedHeaders = new CaseInsensitiveMap();
    private HttpServletResponse response;
    private ResteasyProviderFactory factory;

    public HttpServletResponseHeaders(HttpServletResponse response, ResteasyProviderFactory factory) {
        this.response = response;
        this.factory = factory;
    }

    public void putSingle(String key, Object value) {
        this.cachedHeaders.putSingle(key, value);
        RuntimeDelegate.HeaderDelegate<?> delegate = this.factory.createHeaderDelegate(value.getClass());
        if (delegate != null) {
            this.response.setHeader(key, delegate.toString(value));
        } else {
            this.response.setHeader(key, value.toString());
        }
    }

    public void add(String key, Object value) {
        this.cachedHeaders.add(key, value);
        this.addResponseHeader(key, value);
    }

    protected void addResponseHeader(String key, Object value) {
        RuntimeDelegate.HeaderDelegate<?> delegate = this.factory.createHeaderDelegate(value.getClass());
        if (delegate != null) {
            this.response.addHeader(key, delegate.toString(value));
        } else {
            this.response.addHeader(key, value.toString());
        }
    }

    public Object getFirst(String key) {
        return this.cachedHeaders.getFirst(key);
    }

    public int size() {
        return this.cachedHeaders.size();
    }

    public boolean isEmpty() {
        return this.cachedHeaders.isEmpty();
    }

    public boolean containsKey(Object o) {
        return this.cachedHeaders.containsKey(o);
    }

    public boolean containsValue(Object o) {
        return this.cachedHeaders.containsValue(o);
    }

    public List<Object> get(Object o) {
        return this.cachedHeaders.get(o);
    }

    public List<Object> put(String s, List<Object> objs) {
        for (Object obj : objs) {
            this.addResponseHeader(s, obj);
        }
        return this.cachedHeaders.put(s, objs);
    }

    public List<Object> remove(Object o) {
        throw new RuntimeException("Removing a header is illegal for an HttpServletResponse");
    }

    public void putAll(Map<? extends String, ? extends List<Object>> map) {
        for (Map.Entry<? extends String, ? extends List<Object>> entry : map.entrySet()) {
            List<Object> objs = entry.getValue();
            for (Object obj : objs) {
                this.add(entry.getKey(), obj);
            }
        }
    }

    public void clear() {
        throw new RuntimeException("Removing a header is illegal for an HttpServletResponse");
    }

    public Set<String> keySet() {
        return this.cachedHeaders.keySet();
    }

    public Collection<List<Object>> values() {
        return this.cachedHeaders.values();
    }

    public Set<Map.Entry<String, List<Object>>> entrySet() {
        return this.cachedHeaders.entrySet();
    }

    public boolean equals(Object o) {
        return this.cachedHeaders.equals(o);
    }

    public int hashCode() {
        return this.cachedHeaders.hashCode();
    }
}

