/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.resolver.v2.spi;

import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.jboss.osgi.resolver.v2.XAttributeSupport;
import org.jboss.osgi.resolver.v2.XCapability;
import org.jboss.osgi.resolver.v2.XDirectiveSupport;
import org.jboss.osgi.resolver.v2.XRequirement;
import org.jboss.osgi.resolver.v2.spi.AbstractElement;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.resource.Capability;
import org.osgi.framework.resource.Resource;

public class AbstractRequirement
extends AbstractElement
implements XRequirement {
    private final Resource resource;
    private final String namespace;
    private final XAttributeSupport attributes;
    private final XDirectiveSupport directives;
    private final boolean optional;
    private final Filter filter;

    protected AbstractRequirement(Resource resource, String namespace, Map<String, Object> atts, Map<String, String> dirs) {
        if (resource == null) {
            throw new IllegalArgumentException("Null resource");
        }
        if (namespace == null) {
            throw new IllegalArgumentException("Null namespace");
        }
        if (atts == null) {
            throw new IllegalArgumentException("Null attributes");
        }
        if (dirs == null) {
            throw new IllegalArgumentException("Null directives");
        }
        this.resource = resource;
        this.namespace = namespace;
        this.attributes = new AbstractElement.AttributeSupporter(atts);
        this.directives = new AbstractElement.DirectiveSupporter(dirs);
        String resdir = dirs.get("resolution");
        this.optional = "optional".equals(resdir);
        String filterdir = this.getDirective("filter");
        if (filterdir != null) {
            try {
                this.filter = FrameworkUtil.createFilter((String)filterdir);
            }
            catch (InvalidSyntaxException e) {
                throw new IllegalArgumentException("Invalid filter directive: " + filterdir);
            }
        } else {
            this.filter = null;
        }
        this.validateAttributes(atts);
    }

    protected void validateAttributes(Map<String, Object> atts) {
        for (String name : this.getMandatoryAttributes()) {
            if (atts.get(name) != null) continue;
            throw new IllegalArgumentException("Cannot obtain attribute: " + name);
        }
    }

    protected Set<String> getMandatoryAttributes() {
        return Collections.emptySet();
    }

    public Resource getResource() {
        return this.resource;
    }

    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public boolean isOptional() {
        return this.optional;
    }

    @Override
    public Map<String, String> getDirectives() {
        return this.directives.getDirectives();
    }

    @Override
    public String getDirective(String key) {
        return this.directives.getDirective(key);
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.attributes.getAttributes();
    }

    @Override
    public Object getAttribute(String key) {
        return this.attributes.getAttribute(key);
    }

    public boolean matches(Capability cap) {
        boolean matches = this.namespace.equals(cap.getNamespace());
        matches &= this.matchNamespaceValue(cap);
        return matches &= this.matchFilterValue(cap);
    }

    protected boolean matchNamespaceValue(Capability cap) {
        XCapability xcap = (XCapability)cap;
        Object thisatt = this.getAttribute(this.namespace);
        Object otheratt = xcap.getAttribute(this.namespace);
        return thisatt.equals(otheratt);
    }

    protected boolean matchFilterValue(Capability cap) {
        return this.filter != null ? this.filter.match(new Hashtable(cap.getAttributes())) : true;
    }

    public String toString() {
        String attstr = !this.getAttributes().isEmpty() ? ",attributes=" + this.attributes : "";
        String dirstr = !this.getDirectives().isEmpty() ? ",directives=" + this.directives : "";
        return this.getClass().getSimpleName() + "[" + this.namespace + attstr + dirstr + "]";
    }
}

