/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.resolver.v2.spi;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.osgi.resolver.v2.XIdentityCapability;
import org.jboss.osgi.resolver.v2.XResource;
import org.jboss.osgi.resolver.v2.spi.AbstractElement;
import org.osgi.framework.resource.Capability;
import org.osgi.framework.resource.Requirement;

public class AbstractResource
extends AbstractElement
implements XResource {
    private final Map<String, List<Capability>> capabilities = new HashMap<String, List<Capability>>();
    private final Map<String, List<Requirement>> requirements = new HashMap<String, List<Requirement>>();
    private XIdentityCapability identityCapability;
    private Boolean fragment;

    protected void addCapability(Capability cap) {
        String namespace = cap.getNamespace();
        this.getCaplist(namespace).add(cap);
        this.getCaplist(null).add(cap);
    }

    protected void addRequirement(Requirement req) {
        String namespace = req.getNamespace();
        this.getReqlist(namespace).add(req);
        this.getReqlist(null).add(req);
    }

    public List<Capability> getCapabilities(String namespace) {
        return Collections.unmodifiableList(this.getCaplist(namespace));
    }

    public List<Requirement> getRequirements(String namespace) {
        return Collections.unmodifiableList(this.getReqlist(namespace));
    }

    @Override
    public XIdentityCapability getIdentityCapability() {
        if (this.identityCapability == null) {
            List<Capability> caps = this.getCapabilities("osgi.identity");
            if (caps.size() > 1) {
                throw new IllegalStateException("Multiple identities detected: " + caps);
            }
            this.identityCapability = (XIdentityCapability)caps.get(0);
        }
        return this.identityCapability;
    }

    @Override
    public boolean isFragment() {
        if (this.fragment == null) {
            List<Requirement> reqs = this.getRequirements("osgi.wiring.host");
            this.fragment = new Boolean(reqs.size() > 0);
        }
        return this.fragment;
    }

    private List<Capability> getCaplist(String namespace) {
        List<Capability> caplist = this.capabilities.get(namespace);
        if (caplist == null) {
            caplist = new ArrayList<Capability>();
            this.capabilities.put(namespace, caplist);
        }
        return caplist;
    }

    private List<Requirement> getReqlist(String namespace) {
        List<Requirement> reqlist = this.requirements.get(namespace);
        if (reqlist == null) {
            reqlist = new ArrayList<Requirement>();
            this.requirements.put(namespace, reqlist);
        }
        return reqlist;
    }

    @Override
    public InputStream getContent() {
        return null;
    }

    public String toString() {
        XIdentityCapability id = this.getIdentityCapability();
        String idstr = id != null ? id.getSymbolicName() + ":" + id.getVersion() : "anonymous";
        return this.getClass().getSimpleName() + "[" + idstr + "]";
    }
}

