/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.geometry;

import org.apache.lucene.spatial.geometry.FixedLatLng;
import org.apache.lucene.spatial.geometry.LatLng;

@Deprecated
public class FloatLatLng
extends LatLng {
    private double lat;
    private double lng;
    private boolean normalized;

    public FloatLatLng(double lat, double lng) {
        if (lat > 90.0 || lat < -90.0) {
            throw new IllegalArgumentException("Illegal latitude value " + lat);
        }
        this.lat = lat;
        this.lng = lng;
    }

    public FloatLatLng(LatLng ll) {
        this.lat = ll.getLat();
        this.lng = ll.getLng();
    }

    public LatLng copy() {
        return new FloatLatLng(this);
    }

    public int getFixedLat() {
        return FixedLatLng.doubleToFixed(this.lat);
    }

    public int getFixedLng() {
        return FixedLatLng.doubleToFixed(this.lng);
    }

    public double getLat() {
        return this.lat;
    }

    public double getLng() {
        return this.lng;
    }

    public boolean isFixedPoint() {
        return false;
    }

    public FixedLatLng toFixed() {
        return new FixedLatLng(this);
    }

    public FloatLatLng toFloat() {
        return this;
    }

    public boolean isNormalized() {
        return this.normalized || this.lng >= -180.0 && this.lng <= 180.0;
    }

    public LatLng normalize() {
        double newLng;
        if (this.isNormalized()) {
            return this;
        }
        double delta = 0.0;
        if (this.lng < 0.0) {
            delta = 360.0;
        }
        if (this.lng >= 0.0) {
            delta = -360.0;
        }
        for (newLng = this.lng; newLng <= -180.0 || newLng >= 180.0; newLng += delta) {
        }
        FloatLatLng ret = new FloatLatLng(this.lat, newLng);
        ret.normalized = true;
        return ret;
    }

    public LatLng calculateMidpoint(LatLng other) {
        return new FloatLatLng((this.lat + other.getLat()) / 2.0, (this.lng + other.getLng()) / 2.0);
    }

    public int hashCode() {
        int prime = 31;
        long temp = Double.doubleToLongBits(this.lat);
        int result = 31 + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.lng);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.normalized ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FloatLatLng other = (FloatLatLng)obj;
        if (Double.doubleToLongBits(this.lat) != Double.doubleToLongBits(other.lat)) {
            return false;
        }
        if (Double.doubleToLongBits(this.lng) != Double.doubleToLongBits(other.lng)) {
            return false;
        }
        return this.normalized == other.normalized;
    }
}

