/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.bind.annotation.support;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.core.Conventions;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.MethodParameter;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.ui.ExtendedModelMap;
import org.springframework.ui.Model;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ReflectionUtils;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.support.HandlerMethodInvocationException;
import org.springframework.web.bind.annotation.support.HandlerMethodResolver;
import org.springframework.web.bind.support.DefaultSessionAttributeStore;
import org.springframework.web.bind.support.SessionAttributeStore;
import org.springframework.web.bind.support.SessionStatus;
import org.springframework.web.bind.support.SimpleSessionStatus;
import org.springframework.web.bind.support.WebArgumentResolver;
import org.springframework.web.bind.support.WebBindingInitializer;
import org.springframework.web.bind.support.WebRequestDataBinder;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.multipart.MultipartRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandlerMethodInvoker {
    private static final String MODEL_KEY_PREFIX_STALE = String.valueOf(SessionAttributeStore.class.getName()) + ".STALE.";
    private static final Log logger = LogFactory.getLog(HandlerMethodInvoker.class);
    private final HandlerMethodResolver methodResolver;
    private final WebBindingInitializer bindingInitializer;
    private final SessionAttributeStore sessionAttributeStore;
    private final ParameterNameDiscoverer parameterNameDiscoverer;
    private final WebArgumentResolver[] customArgumentResolvers;
    private final HttpMessageConverter[] messageConverters;
    private final SimpleSessionStatus sessionStatus = new SimpleSessionStatus();

    public HandlerMethodInvoker(HandlerMethodResolver methodResolver) {
        this(methodResolver, null);
    }

    public HandlerMethodInvoker(HandlerMethodResolver methodResolver, WebBindingInitializer bindingInitializer) {
        this(methodResolver, bindingInitializer, new DefaultSessionAttributeStore(), null, null, null);
    }

    public HandlerMethodInvoker(HandlerMethodResolver methodResolver, WebBindingInitializer bindingInitializer, SessionAttributeStore sessionAttributeStore, ParameterNameDiscoverer parameterNameDiscoverer, WebArgumentResolver[] customArgumentResolvers, HttpMessageConverter[] messageConverters) {
        this.methodResolver = methodResolver;
        this.bindingInitializer = bindingInitializer;
        this.sessionAttributeStore = sessionAttributeStore;
        this.parameterNameDiscoverer = parameterNameDiscoverer;
        this.customArgumentResolvers = customArgumentResolvers;
        this.messageConverters = messageConverters;
    }

    public final Object invokeHandlerMethod(Method handlerMethod, Object handler, NativeWebRequest webRequest, ExtendedModelMap implicitModel) throws Exception {
        Method handlerMethodToInvoke = BridgeMethodResolver.findBridgedMethod((Method)handlerMethod);
        try {
            boolean debug = logger.isDebugEnabled();
            for (String attrName : this.methodResolver.getActualSessionAttributeNames()) {
                Object attrValue = this.sessionAttributeStore.retrieveAttribute(webRequest, attrName);
                if (attrValue == null) continue;
                implicitModel.addAttribute(attrName, attrValue);
            }
            for (Method attributeMethod : this.methodResolver.getModelAttributeMethods()) {
                String attrName;
                Method attributeMethodToInvoke = BridgeMethodResolver.findBridgedMethod((Method)attributeMethod);
                Object[] args = this.resolveHandlerArguments(attributeMethodToInvoke, handler, webRequest, implicitModel);
                if (debug) {
                    logger.debug((Object)("Invoking model attribute method: " + attributeMethodToInvoke));
                }
                if (!"".equals(attrName = ((ModelAttribute)AnnotationUtils.findAnnotation((Method)attributeMethod, ModelAttribute.class)).value()) && implicitModel.containsAttribute(attrName)) continue;
                ReflectionUtils.makeAccessible((Method)attributeMethodToInvoke);
                Object attrValue = attributeMethodToInvoke.invoke(handler, args);
                if ("".equals(attrName)) {
                    Class resolvedType = GenericTypeResolver.resolveReturnType((Method)attributeMethodToInvoke, handler.getClass());
                    attrName = Conventions.getVariableNameForReturnType((Method)attributeMethodToInvoke, (Class)resolvedType, (Object)attrValue);
                }
                if (implicitModel.containsAttribute(attrName)) continue;
                implicitModel.addAttribute(attrName, attrValue);
            }
            Object[] args = this.resolveHandlerArguments(handlerMethodToInvoke, handler, webRequest, implicitModel);
            if (debug) {
                logger.debug((Object)("Invoking request handler method: " + handlerMethodToInvoke));
            }
            ReflectionUtils.makeAccessible((Method)handlerMethodToInvoke);
            return handlerMethodToInvoke.invoke(handler, args);
        }
        catch (IllegalStateException ex) {
            throw new HandlerMethodInvocationException(handlerMethodToInvoke, ex);
        }
        catch (InvocationTargetException ex) {
            ReflectionUtils.rethrowException((Throwable)ex.getTargetException());
            return null;
        }
    }

    public final void updateModelAttributes(Object handler, Map<String, Object> mavModel, ExtendedModelMap implicitModel, NativeWebRequest webRequest) throws Exception {
        ExtendedModelMap model;
        if (this.methodResolver.hasSessionAttributes() && this.sessionStatus.isComplete()) {
            for (String attrName : this.methodResolver.getActualSessionAttributeNames()) {
                this.sessionAttributeStore.cleanupAttribute(webRequest, attrName);
            }
        }
        ExtendedModelMap extendedModelMap = model = mavModel != null ? mavModel : implicitModel;
        if (model != null) {
            try {
                String[] originalAttrNames;
                String[] stringArray = originalAttrNames = model.keySet().toArray(new String[model.size()]);
                int n = originalAttrNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String attrName;
                    Object attrValue = model.get(attrName = stringArray[n2]);
                    boolean isSessionAttr = this.methodResolver.isSessionAttribute(attrName, attrValue != null ? attrValue.getClass() : null);
                    if (isSessionAttr) {
                        if (this.sessionStatus.isComplete()) {
                            implicitModel.put((Object)(String.valueOf(MODEL_KEY_PREFIX_STALE) + attrName), (Object)Boolean.TRUE);
                        } else if (!implicitModel.containsKey((Object)(String.valueOf(MODEL_KEY_PREFIX_STALE) + attrName))) {
                            this.sessionAttributeStore.storeAttribute(webRequest, attrName, attrValue);
                        }
                    }
                    if (!attrName.startsWith(BindingResult.MODEL_KEY_PREFIX) && (isSessionAttr || this.isBindingCandidate(attrValue))) {
                        String bindingResultKey = String.valueOf(BindingResult.MODEL_KEY_PREFIX) + attrName;
                        if (mavModel != null && !model.containsKey(bindingResultKey)) {
                            WebDataBinder binder = this.createBinder(webRequest, attrValue, attrName);
                            this.initBinder(handler, attrName, binder, webRequest);
                            mavModel.put(bindingResultKey, binder.getBindingResult());
                        }
                    }
                    ++n2;
                }
            }
            catch (InvocationTargetException ex) {
                ReflectionUtils.rethrowException((Throwable)ex.getTargetException());
            }
        }
    }

    private Object[] resolveHandlerArguments(Method handlerMethod, Object handler, NativeWebRequest webRequest, ExtendedModelMap implicitModel) throws Exception {
        Class<?>[] paramTypes = handlerMethod.getParameterTypes();
        Object[] args = new Object[paramTypes.length];
        int i = 0;
        while (i < args.length) {
            Annotation[] paramAnns;
            MethodParameter methodParam = new MethodParameter(handlerMethod, i);
            methodParam.initParameterNameDiscovery(this.parameterNameDiscoverer);
            GenericTypeResolver.resolveParameterType((MethodParameter)methodParam, handler.getClass());
            String paramName = null;
            String headerName = null;
            boolean requestBodyFound = false;
            String cookieName = null;
            String pathVarName = null;
            String attrName = null;
            boolean required = false;
            String defaultValue = null;
            boolean validate = false;
            Object[] validationHints = null;
            int annotationsFound = 0;
            Annotation[] annotationArray = paramAnns = methodParam.getParameterAnnotations();
            int n = paramAnns.length;
            int n2 = 0;
            while (n2 < n) {
                Annotation paramAnn = annotationArray[n2];
                if (RequestParam.class.isInstance(paramAnn)) {
                    RequestParam requestParam = (RequestParam)paramAnn;
                    paramName = requestParam.value();
                    required = requestParam.required();
                    defaultValue = this.parseDefaultValueAttribute(requestParam.defaultValue());
                    ++annotationsFound;
                } else if (RequestHeader.class.isInstance(paramAnn)) {
                    RequestHeader requestHeader = (RequestHeader)paramAnn;
                    headerName = requestHeader.value();
                    required = requestHeader.required();
                    defaultValue = this.parseDefaultValueAttribute(requestHeader.defaultValue());
                    ++annotationsFound;
                } else if (RequestBody.class.isInstance(paramAnn)) {
                    requestBodyFound = true;
                    ++annotationsFound;
                } else if (CookieValue.class.isInstance(paramAnn)) {
                    CookieValue cookieValue = (CookieValue)paramAnn;
                    cookieName = cookieValue.value();
                    required = cookieValue.required();
                    defaultValue = this.parseDefaultValueAttribute(cookieValue.defaultValue());
                    ++annotationsFound;
                } else if (PathVariable.class.isInstance(paramAnn)) {
                    PathVariable pathVar = (PathVariable)paramAnn;
                    pathVarName = pathVar.value();
                    ++annotationsFound;
                } else if (ModelAttribute.class.isInstance(paramAnn)) {
                    ModelAttribute attr = (ModelAttribute)paramAnn;
                    attrName = attr.value();
                    ++annotationsFound;
                } else if (Value.class.isInstance(paramAnn)) {
                    defaultValue = ((Value)paramAnn).value();
                } else if (paramAnn.annotationType().getSimpleName().startsWith("Valid")) {
                    Object[] objectArray;
                    validate = true;
                    Object value = AnnotationUtils.getValue((Annotation)paramAnn);
                    if (value instanceof Object[]) {
                        objectArray = (Object[])value;
                    } else {
                        Object[] objectArray2 = new Object[1];
                        objectArray = objectArray2;
                        objectArray2[0] = value;
                    }
                    validationHints = objectArray;
                }
                ++n2;
            }
            if (annotationsFound > 1) {
                throw new IllegalStateException("Handler parameter annotations are exclusive choices - do not specify more than one such annotation on the same parameter: " + handlerMethod);
            }
            if (annotationsFound == 0) {
                Object argValue = this.resolveCommonArgument(methodParam, webRequest);
                if (argValue != WebArgumentResolver.UNRESOLVED) {
                    args[i] = argValue;
                } else if (defaultValue != null) {
                    args[i] = this.resolveDefaultValue(defaultValue);
                } else {
                    Class paramType = methodParam.getParameterType();
                    if (Model.class.isAssignableFrom(paramType) || Map.class.isAssignableFrom(paramType)) {
                        if (!paramType.isAssignableFrom(implicitModel.getClass())) {
                            throw new IllegalStateException("Argument [" + paramType.getSimpleName() + "] is of type " + "Model or Map but is not assignable from the actual model. You may need to switch " + "newer MVC infrastructure classes to use this argument.");
                        }
                        args[i] = implicitModel;
                    } else if (SessionStatus.class.isAssignableFrom(paramType)) {
                        args[i] = this.sessionStatus;
                    } else if (HttpEntity.class.isAssignableFrom(paramType)) {
                        args[i] = this.resolveHttpEntityRequest(methodParam, webRequest);
                    } else {
                        if (Errors.class.isAssignableFrom(paramType)) {
                            throw new IllegalStateException("Errors/BindingResult argument declared without preceding model attribute. Check your handler method signature!");
                        }
                        if (BeanUtils.isSimpleProperty((Class)paramType)) {
                            paramName = "";
                        } else {
                            attrName = "";
                        }
                    }
                }
            }
            if (paramName != null) {
                args[i] = this.resolveRequestParam(paramName, required, defaultValue, methodParam, webRequest, handler);
            } else if (headerName != null) {
                args[i] = this.resolveRequestHeader(headerName, required, defaultValue, methodParam, webRequest, handler);
            } else if (requestBodyFound) {
                args[i] = this.resolveRequestBody(methodParam, webRequest, handler);
            } else if (cookieName != null) {
                args[i] = this.resolveCookieValue(cookieName, required, defaultValue, methodParam, webRequest, handler);
            } else if (pathVarName != null) {
                args[i] = this.resolvePathVariable(pathVarName, methodParam, webRequest, handler);
            } else if (attrName != null) {
                boolean assignBindingResult;
                WebDataBinder binder = this.resolveModelAttribute(attrName, methodParam, implicitModel, webRequest, handler);
                boolean bl = assignBindingResult = args.length > i + 1 && Errors.class.isAssignableFrom(paramTypes[i + 1]);
                if (binder.getTarget() != null) {
                    this.doBind(binder, webRequest, validate, validationHints, !assignBindingResult);
                }
                args[i] = binder.getTarget();
                if (assignBindingResult) {
                    args[i + 1] = binder.getBindingResult();
                    ++i;
                }
                implicitModel.putAll(binder.getBindingResult().getModel());
            }
            ++i;
        }
        return args;
    }

    protected void initBinder(Object handler, String attrName, WebDataBinder binder, NativeWebRequest webRequest) throws Exception {
        Set<Method> initBinderMethods;
        if (this.bindingInitializer != null) {
            this.bindingInitializer.initBinder(binder, webRequest);
        }
        if (handler != null && !(initBinderMethods = this.methodResolver.getInitBinderMethods()).isEmpty()) {
            boolean debug = logger.isDebugEnabled();
            for (Method initBinderMethod : initBinderMethods) {
                Method methodToInvoke = BridgeMethodResolver.findBridgedMethod((Method)initBinderMethod);
                String[] targetNames = ((InitBinder)AnnotationUtils.findAnnotation((Method)initBinderMethod, InitBinder.class)).value();
                if (targetNames.length != 0 && !Arrays.asList(targetNames).contains(attrName)) continue;
                Object[] initBinderArgs = this.resolveInitBinderArguments(handler, methodToInvoke, binder, webRequest);
                if (debug) {
                    logger.debug((Object)("Invoking init-binder method: " + methodToInvoke));
                }
                ReflectionUtils.makeAccessible((Method)methodToInvoke);
                Object returnValue = methodToInvoke.invoke(handler, initBinderArgs);
                if (returnValue == null) continue;
                throw new IllegalStateException("InitBinder methods must not have a return value: " + methodToInvoke);
            }
        }
    }

    private Object[] resolveInitBinderArguments(Object handler, Method initBinderMethod, WebDataBinder binder, NativeWebRequest webRequest) throws Exception {
        Class<?>[] initBinderParams = initBinderMethod.getParameterTypes();
        Object[] initBinderArgs = new Object[initBinderParams.length];
        int i = 0;
        while (i < initBinderArgs.length) {
            Annotation[] paramAnns;
            MethodParameter methodParam = new MethodParameter(initBinderMethod, i);
            methodParam.initParameterNameDiscovery(this.parameterNameDiscoverer);
            GenericTypeResolver.resolveParameterType((MethodParameter)methodParam, handler.getClass());
            String paramName = null;
            boolean paramRequired = false;
            String paramDefaultValue = null;
            String pathVarName = null;
            Annotation[] annotationArray = paramAnns = methodParam.getParameterAnnotations();
            int n = paramAnns.length;
            int n2 = 0;
            while (n2 < n) {
                Annotation paramAnn = annotationArray[n2];
                if (RequestParam.class.isInstance(paramAnn)) {
                    RequestParam requestParam = (RequestParam)paramAnn;
                    paramName = requestParam.value();
                    paramRequired = requestParam.required();
                    paramDefaultValue = this.parseDefaultValueAttribute(requestParam.defaultValue());
                    break;
                }
                if (ModelAttribute.class.isInstance(paramAnn)) {
                    throw new IllegalStateException("@ModelAttribute is not supported on @InitBinder methods: " + initBinderMethod);
                }
                if (PathVariable.class.isInstance(paramAnn)) {
                    PathVariable pathVar = (PathVariable)paramAnn;
                    pathVarName = pathVar.value();
                }
                ++n2;
            }
            if (paramName == null && pathVarName == null) {
                Object argValue = this.resolveCommonArgument(methodParam, webRequest);
                if (argValue != WebArgumentResolver.UNRESOLVED) {
                    initBinderArgs[i] = argValue;
                } else {
                    Class<?> paramType = initBinderParams[i];
                    if (paramType.isInstance((Object)binder)) {
                        initBinderArgs[i] = binder;
                    } else if (BeanUtils.isSimpleProperty(paramType)) {
                        paramName = "";
                    } else {
                        throw new IllegalStateException("Unsupported argument [" + paramType.getName() + "] for @InitBinder method: " + initBinderMethod);
                    }
                }
            }
            if (paramName != null) {
                initBinderArgs[i] = this.resolveRequestParam(paramName, paramRequired, paramDefaultValue, methodParam, webRequest, null);
            } else if (pathVarName != null) {
                initBinderArgs[i] = this.resolvePathVariable(pathVarName, methodParam, webRequest, null);
            }
            ++i;
        }
        return initBinderArgs;
    }

    private Object resolveRequestParam(String paramName, boolean required, String defaultValue, MethodParameter methodParam, NativeWebRequest webRequest, Object handlerForInitBinderCall) throws Exception {
        String[] paramValues;
        String[] files;
        Class paramType = methodParam.getParameterType();
        if (Map.class.isAssignableFrom(paramType) && paramName.length() == 0) {
            return this.resolveRequestParamMap(paramType, webRequest);
        }
        if (paramName.length() == 0) {
            paramName = this.getRequiredParameterName(methodParam);
        }
        Object paramValue = null;
        MultipartRequest multipartRequest = webRequest.getNativeRequest(MultipartRequest.class);
        if (multipartRequest != null && !(files = multipartRequest.getFiles(paramName)).isEmpty()) {
            Object object = paramValue = files.size() == 1 ? files.get(0) : files;
        }
        if (paramValue == null && (paramValues = webRequest.getParameterValues(paramName)) != null) {
            Object object = paramValue = paramValues.length == 1 ? paramValues[0] : paramValues;
        }
        if (paramValue == null) {
            if (defaultValue != null) {
                paramValue = this.resolveDefaultValue(defaultValue);
            } else if (required) {
                this.raiseMissingParameterException(paramName, paramType);
            }
            paramValue = this.checkValue(paramName, paramValue, paramType);
        }
        WebDataBinder binder = this.createBinder(webRequest, null, paramName);
        this.initBinder(handlerForInitBinderCall, paramName, binder, webRequest);
        return binder.convertIfNecessary(paramValue, paramType, methodParam);
    }

    private Map resolveRequestParamMap(Class<? extends Map> mapType, NativeWebRequest webRequest) {
        Map<String, String[]> parameterMap = webRequest.getParameterMap();
        if (MultiValueMap.class.isAssignableFrom(mapType)) {
            LinkedMultiValueMap result = new LinkedMultiValueMap(parameterMap.size());
            for (Map.Entry<String, String[]> entry : parameterMap.entrySet()) {
                String[] stringArray = entry.getValue();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String value = stringArray[n2];
                    result.add((Object)entry.getKey(), (Object)value);
                    ++n2;
                }
            }
            return result;
        }
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(parameterMap.size());
        for (Map.Entry<String, String[]> entry : parameterMap.entrySet()) {
            if (entry.getValue().length <= 0) continue;
            result.put(entry.getKey(), entry.getValue()[0]);
        }
        return result;
    }

    private Object resolveRequestHeader(String headerName, boolean required, String defaultValue, MethodParameter methodParam, NativeWebRequest webRequest, Object handlerForInitBinderCall) throws Exception {
        Class paramType = methodParam.getParameterType();
        if (Map.class.isAssignableFrom(paramType)) {
            return this.resolveRequestHeaderMap(paramType, webRequest);
        }
        if (headerName.length() == 0) {
            headerName = this.getRequiredParameterName(methodParam);
        }
        Object headerValue = null;
        String[] headerValues = webRequest.getHeaderValues(headerName);
        if (headerValues != null) {
            Object object = headerValue = headerValues.length == 1 ? headerValues[0] : headerValues;
        }
        if (headerValue == null) {
            if (defaultValue != null) {
                headerValue = this.resolveDefaultValue(defaultValue);
            } else if (required) {
                this.raiseMissingHeaderException(headerName, paramType);
            }
            headerValue = this.checkValue(headerName, headerValue, paramType);
        }
        WebDataBinder binder = this.createBinder(webRequest, null, headerName);
        this.initBinder(handlerForInitBinderCall, headerName, binder, webRequest);
        return binder.convertIfNecessary(headerValue, paramType, methodParam);
    }

    private Map resolveRequestHeaderMap(Class<? extends Map> mapType, NativeWebRequest webRequest) {
        if (MultiValueMap.class.isAssignableFrom(mapType)) {
            HttpHeaders result = HttpHeaders.class.isAssignableFrom(mapType) ? new HttpHeaders() : new LinkedMultiValueMap();
            Iterator<String> iterator = webRequest.getHeaderNames();
            while (iterator.hasNext()) {
                String headerName = iterator.next();
                String[] stringArray = webRequest.getHeaderValues(headerName);
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String headerValue = stringArray[n2];
                    result.add(headerName, headerValue);
                    ++n2;
                }
            }
            return result;
        }
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        Iterator<String> iterator = webRequest.getHeaderNames();
        while (iterator.hasNext()) {
            String headerName = iterator.next();
            String headerValue = webRequest.getHeader(headerName);
            result.put(headerName, headerValue);
        }
        return result;
    }

    protected Object resolveRequestBody(MethodParameter methodParam, NativeWebRequest webRequest, Object handler) throws Exception {
        return this.readWithMessageConverters(methodParam, this.createHttpInputMessage(webRequest), methodParam.getParameterType());
    }

    private HttpEntity resolveHttpEntityRequest(MethodParameter methodParam, NativeWebRequest webRequest) throws Exception {
        HttpInputMessage inputMessage = this.createHttpInputMessage(webRequest);
        Class<?> paramType = this.getHttpEntityType(methodParam);
        Object body = this.readWithMessageConverters(methodParam, inputMessage, paramType);
        return new HttpEntity<Object>(body, inputMessage.getHeaders());
    }

    private Object readWithMessageConverters(MethodParameter methodParam, HttpInputMessage inputMessage, Class paramType) throws Exception {
        MediaType contentType = inputMessage.getHeaders().getContentType();
        if (contentType == null) {
            StringBuilder builder = new StringBuilder(ClassUtils.getShortName((Class)methodParam.getParameterType()));
            String paramName = methodParam.getParameterName();
            if (paramName != null) {
                builder.append(' ');
                builder.append(paramName);
            }
            throw new HttpMediaTypeNotSupportedException("Cannot extract parameter (" + builder.toString() + "): no Content-Type found");
        }
        ArrayList<MediaType> allSupportedMediaTypes = new ArrayList<MediaType>();
        if (this.messageConverters != null) {
            HttpMessageConverter[] httpMessageConverterArray = this.messageConverters;
            int n = this.messageConverters.length;
            int n2 = 0;
            while (n2 < n) {
                HttpMessageConverter messageConverter = httpMessageConverterArray[n2];
                allSupportedMediaTypes.addAll(messageConverter.getSupportedMediaTypes());
                if (messageConverter.canRead(paramType, contentType)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Reading [" + paramType.getName() + "] as \"" + contentType + "\" using [" + messageConverter + "]"));
                    }
                    return messageConverter.read(paramType, inputMessage);
                }
                ++n2;
            }
        }
        throw new HttpMediaTypeNotSupportedException(contentType, allSupportedMediaTypes);
    }

    private Class<?> getHttpEntityType(MethodParameter methodParam) {
        Assert.isAssignable(HttpEntity.class, (Class)methodParam.getParameterType());
        ParameterizedType type = (ParameterizedType)methodParam.getGenericParameterType();
        if (type.getActualTypeArguments().length == 1) {
            Type componentType;
            Type typeArgument = type.getActualTypeArguments()[0];
            if (typeArgument instanceof Class) {
                return (Class)typeArgument;
            }
            if (typeArgument instanceof GenericArrayType && (componentType = ((GenericArrayType)typeArgument).getGenericComponentType()) instanceof Class) {
                Object array = Array.newInstance((Class)componentType, 0);
                return array.getClass();
            }
        }
        throw new IllegalArgumentException("HttpEntity parameter (" + methodParam.getParameterName() + ") is not parameterized");
    }

    private Object resolveCookieValue(String cookieName, boolean required, String defaultValue, MethodParameter methodParam, NativeWebRequest webRequest, Object handlerForInitBinderCall) throws Exception {
        Object cookieValue;
        Class paramType = methodParam.getParameterType();
        if (cookieName.length() == 0) {
            cookieName = this.getRequiredParameterName(methodParam);
        }
        if ((cookieValue = this.resolveCookieValue(cookieName, paramType, webRequest)) == null) {
            if (defaultValue != null) {
                cookieValue = this.resolveDefaultValue(defaultValue);
            } else if (required) {
                this.raiseMissingCookieException(cookieName, paramType);
            }
            cookieValue = this.checkValue(cookieName, cookieValue, paramType);
        }
        WebDataBinder binder = this.createBinder(webRequest, null, cookieName);
        this.initBinder(handlerForInitBinderCall, cookieName, binder, webRequest);
        return binder.convertIfNecessary(cookieValue, paramType, methodParam);
    }

    protected Object resolveCookieValue(String cookieName, Class paramType, NativeWebRequest webRequest) throws Exception {
        throw new UnsupportedOperationException("@CookieValue not supported");
    }

    private Object resolvePathVariable(String pathVarName, MethodParameter methodParam, NativeWebRequest webRequest, Object handlerForInitBinderCall) throws Exception {
        Class paramType = methodParam.getParameterType();
        if (pathVarName.length() == 0) {
            pathVarName = this.getRequiredParameterName(methodParam);
        }
        String pathVarValue = this.resolvePathVariable(pathVarName, paramType, webRequest);
        WebDataBinder binder = this.createBinder(webRequest, null, pathVarName);
        this.initBinder(handlerForInitBinderCall, pathVarName, binder, webRequest);
        return binder.convertIfNecessary(pathVarValue, paramType, methodParam);
    }

    protected String resolvePathVariable(String pathVarName, Class paramType, NativeWebRequest webRequest) throws Exception {
        throw new UnsupportedOperationException("@PathVariable not supported");
    }

    private String getRequiredParameterName(MethodParameter methodParam) {
        String name = methodParam.getParameterName();
        if (name == null) {
            throw new IllegalStateException("No parameter name specified for argument of type [" + methodParam.getParameterType().getName() + "], and no parameter name information found in class file either.");
        }
        return name;
    }

    private Object checkValue(String name, Object value, Class paramType) {
        if (value == null) {
            if (Boolean.TYPE.equals(paramType)) {
                return Boolean.FALSE;
            }
            if (paramType.isPrimitive()) {
                throw new IllegalStateException("Optional " + paramType + " parameter '" + name + "' is not present but cannot be translated into a null value due to being declared as a " + "primitive type. Consider declaring it as object wrapper for the corresponding primitive type.");
            }
        }
        return value;
    }

    private WebDataBinder resolveModelAttribute(String attrName, MethodParameter methodParam, ExtendedModelMap implicitModel, NativeWebRequest webRequest, Object handler) throws Exception {
        Object bindObject;
        String name = attrName;
        if ("".equals(name)) {
            name = Conventions.getVariableNameForParameter((MethodParameter)methodParam);
        }
        Class paramType = methodParam.getParameterType();
        if (implicitModel.containsKey((Object)name)) {
            bindObject = implicitModel.get((Object)name);
        } else if (this.methodResolver.isSessionAttribute(name, paramType)) {
            bindObject = this.sessionAttributeStore.retrieveAttribute(webRequest, name);
            if (bindObject == null) {
                this.raiseSessionRequiredException("Session attribute '" + name + "' required - not found in session");
            }
        } else {
            bindObject = BeanUtils.instantiateClass((Class)paramType);
        }
        WebDataBinder binder = this.createBinder(webRequest, bindObject, name);
        this.initBinder(handler, name, binder, webRequest);
        return binder;
    }

    protected boolean isBindingCandidate(Object value) {
        return value != null && !value.getClass().isArray() && !(value instanceof Collection) && !(value instanceof Map) && !BeanUtils.isSimpleValueType(value.getClass());
    }

    protected void raiseMissingParameterException(String paramName, Class paramType) throws Exception {
        throw new IllegalStateException("Missing parameter '" + paramName + "' of type [" + paramType.getName() + "]");
    }

    protected void raiseMissingHeaderException(String headerName, Class paramType) throws Exception {
        throw new IllegalStateException("Missing header '" + headerName + "' of type [" + paramType.getName() + "]");
    }

    protected void raiseMissingCookieException(String cookieName, Class paramType) throws Exception {
        throw new IllegalStateException("Missing cookie value '" + cookieName + "' of type [" + paramType.getName() + "]");
    }

    protected void raiseSessionRequiredException(String message) throws Exception {
        throw new IllegalStateException(message);
    }

    protected WebDataBinder createBinder(NativeWebRequest webRequest, Object target, String objectName) throws Exception {
        return new WebRequestDataBinder(target, objectName);
    }

    private void doBind(WebDataBinder binder, NativeWebRequest webRequest, boolean validate, Object[] validationHints, boolean failOnErrors) throws Exception {
        this.doBind(binder, webRequest);
        if (validate) {
            binder.validate(validationHints);
        }
        if (failOnErrors && binder.getBindingResult().hasErrors()) {
            throw new BindException(binder.getBindingResult());
        }
    }

    protected void doBind(WebDataBinder binder, NativeWebRequest webRequest) throws Exception {
        ((WebRequestDataBinder)binder).bind(webRequest);
    }

    protected HttpInputMessage createHttpInputMessage(NativeWebRequest webRequest) throws Exception {
        throw new UnsupportedOperationException("@RequestBody not supported");
    }

    protected HttpOutputMessage createHttpOutputMessage(NativeWebRequest webRequest) throws Exception {
        throw new UnsupportedOperationException("@Body not supported");
    }

    protected String parseDefaultValueAttribute(String value) {
        return "\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n".equals(value) ? null : value;
    }

    protected Object resolveDefaultValue(String value) {
        return value;
    }

    protected Object resolveCommonArgument(MethodParameter methodParameter, NativeWebRequest webRequest) throws Exception {
        Class paramType;
        Object value;
        if (this.customArgumentResolvers != null) {
            WebArgumentResolver[] webArgumentResolverArray = this.customArgumentResolvers;
            int n = this.customArgumentResolvers.length;
            int n2 = 0;
            while (n2 < n) {
                WebArgumentResolver argumentResolver = webArgumentResolverArray[n2];
                Object value2 = argumentResolver.resolveArgument(methodParameter, webRequest);
                if (value2 != WebArgumentResolver.UNRESOLVED) {
                    return value2;
                }
                ++n2;
            }
        }
        if ((value = this.resolveStandardArgument(paramType = methodParameter.getParameterType(), webRequest)) != WebArgumentResolver.UNRESOLVED && !ClassUtils.isAssignableValue((Class)paramType, (Object)value)) {
            throw new IllegalStateException("Standard argument type [" + paramType.getName() + "] resolved to incompatible value of type [" + (value != null ? value.getClass() : null) + "]. Consider declaring the argument type in a less specific fashion.");
        }
        return value;
    }

    protected Object resolveStandardArgument(Class<?> parameterType, NativeWebRequest webRequest) throws Exception {
        if (WebRequest.class.isAssignableFrom(parameterType)) {
            return webRequest;
        }
        return WebArgumentResolver.UNRESOLVED;
    }

    protected final void addReturnValueAsModelAttribute(Method handlerMethod, Class handlerType, Object returnValue, ExtendedModelMap implicitModel) {
        String attrName;
        ModelAttribute attr = (ModelAttribute)AnnotationUtils.findAnnotation((Method)handlerMethod, ModelAttribute.class);
        String string = attrName = attr != null ? attr.value() : "";
        if ("".equals(attrName)) {
            Class resolvedType = GenericTypeResolver.resolveReturnType((Method)handlerMethod, (Class)handlerType);
            attrName = Conventions.getVariableNameForReturnType((Method)handlerMethod, (Class)resolvedType, (Object)returnValue);
        }
        implicitModel.addAttribute(attrName, returnValue);
    }
}

