/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.multipart.support;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.Part;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.multipart.MultipartException;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.MultipartResolver;
import org.springframework.web.multipart.support.StandardMultipartHttpServletRequest;

public class StandardServletMultipartResolver
implements MultipartResolver {
    public boolean isMultipart(HttpServletRequest request) {
        if (!"post".equals(request.getMethod().toLowerCase())) {
            return false;
        }
        String contentType = request.getContentType();
        return contentType != null && contentType.toLowerCase().startsWith("multipart/");
    }

    public MultipartHttpServletRequest resolveMultipart(HttpServletRequest request) throws MultipartException {
        return new StandardMultipartHttpServletRequest(request);
    }

    public void cleanupMultipart(MultipartHttpServletRequest request) {
        try {
            for (Part part : request.getParts()) {
                part.delete();
            }
        }
        catch (Exception ex) {
            LogFactory.getLog(this.getClass()).warn((Object)"Failed to perform cleanup of multipart items", (Throwable)ex);
        }
    }
}

