/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security.permission;

import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.annotations.security.permission.PermissionAction;
import org.jboss.seam.annotations.security.permission.PermissionDiscriminator;
import org.jboss.seam.annotations.security.permission.PermissionRole;
import org.jboss.seam.annotations.security.permission.PermissionTarget;
import org.jboss.seam.annotations.security.permission.PermissionUser;
import org.jboss.seam.core.Expressions;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.security.Role;
import org.jboss.seam.security.SimplePrincipal;
import org.jboss.seam.security.management.IdentityManager;
import org.jboss.seam.security.management.IdentityStore;
import org.jboss.seam.security.management.JpaIdentityStore;
import org.jboss.seam.security.permission.IdentifierPolicy;
import org.jboss.seam.security.permission.Permission;
import org.jboss.seam.security.permission.PermissionMetadata;
import org.jboss.seam.security.permission.PermissionStore;
import org.jboss.seam.util.AnnotatedBeanProperty;

@Name(value="org.jboss.seam.security.jpaPermissionStore")
@Install(precedence=0, value=false)
@Scope(value=ScopeType.APPLICATION)
@BypassInterceptors
public class JpaPermissionStore
implements PermissionStore,
Serializable {
    private static final LogProvider log = Logging.getLogProvider(JpaPermissionStore.class);
    private Expressions.ValueExpression<EntityManager> entityManager;
    private Class userPermissionClass;
    private Class rolePermissionClass;
    private AnnotatedBeanProperty<PermissionUser> userProperty;
    private AnnotatedBeanProperty<PermissionRole> roleProperty;
    private AnnotatedBeanProperty<PermissionTarget> targetProperty;
    private AnnotatedBeanProperty<PermissionAction> actionProperty;
    private AnnotatedBeanProperty<PermissionDiscriminator> discriminatorProperty;
    private AnnotatedBeanProperty<PermissionTarget> roleTargetProperty;
    private AnnotatedBeanProperty<PermissionAction> roleActionProperty;
    private Map<Integer, String> queryCache = new HashMap<Integer, String>();
    private IdentifierPolicy identifierPolicy;
    private PermissionMetadata metadata;

    @Create
    public void init() {
        this.metadata = new PermissionMetadata();
        if (this.userPermissionClass == null) {
            log.debug("No permissionClass set, JpaPermissionStore will be unavailable.");
            return;
        }
        if (this.entityManager == null) {
            this.entityManager = Expressions.instance().createValueExpression("#{entityManager}", EntityManager.class);
        }
        this.initProperties();
        this.identifierPolicy = (IdentifierPolicy)Component.getInstance(IdentifierPolicy.class, true);
    }

    protected void initProperties() {
        this.userProperty = new AnnotatedBeanProperty(this.userPermissionClass, PermissionUser.class);
        this.targetProperty = new AnnotatedBeanProperty(this.userPermissionClass, PermissionTarget.class);
        this.actionProperty = new AnnotatedBeanProperty(this.userPermissionClass, PermissionAction.class);
        if (this.rolePermissionClass != null) {
            this.roleProperty = new AnnotatedBeanProperty(this.rolePermissionClass, PermissionRole.class);
            if (this.roleProperty.isSet()) {
                this.roleTargetProperty = new AnnotatedBeanProperty(this.rolePermissionClass, PermissionTarget.class);
                this.roleActionProperty = new AnnotatedBeanProperty(this.rolePermissionClass, PermissionAction.class);
            }
        } else {
            this.roleProperty = new AnnotatedBeanProperty(this.userPermissionClass, PermissionRole.class);
            if (this.roleProperty.isSet()) {
                this.discriminatorProperty = new AnnotatedBeanProperty(this.userPermissionClass, PermissionDiscriminator.class);
            }
        }
        if (!this.userProperty.isSet()) {
            throw new RuntimeException("Invalid userPermissionClass " + this.userPermissionClass.getName() + " - required annotation @PermissionUser not found on any Field or Method.");
        }
        if (this.rolePermissionClass != null) {
            if (!this.roleProperty.isSet()) {
                throw new RuntimeException("Invalid rolePermissionClass " + this.rolePermissionClass.getName() + " - required annotation @PermissionRole not found on any Field or Method.");
            }
            if (!this.roleTargetProperty.isSet()) {
                throw new RuntimeException("Invalid rolePermissionClass " + this.rolePermissionClass.getName() + " - required annotation @PermissionTarget not found on any Field or Method.");
            }
            if (!this.roleActionProperty.isSet()) {
                throw new RuntimeException("Invalid rolePermissionClass " + this.rolePermissionClass.getName() + " - required annotation @PermissionAction not found on any Field or Method.");
            }
        } else if (!this.discriminatorProperty.isSet()) {
            throw new RuntimeException("Invalid userPermissionClass " + this.userPermissionClass.getName() + " - no rolePermissionClass set and @PermissionDiscriminator annotation not found on " + "any Field or Method");
        }
    }

    protected Query createPermissionQuery(Object target, Set targets, Principal recipient, Discrimination discrimination) {
        boolean useRoleTable;
        if (target != null && targets != null) {
            throw new IllegalArgumentException("Cannot specify both target and targets");
        }
        int queryKey = target != null ? 1 : 0;
        queryKey |= targets != null ? 2 : 0;
        queryKey |= recipient != null ? 4 : 0;
        queryKey |= discrimination.equals((Object)Discrimination.user) ? 8 : 0;
        queryKey |= discrimination.equals((Object)Discrimination.role) ? 16 : 0;
        boolean isRole = discrimination.equals((Object)Discrimination.role);
        boolean bl = useRoleTable = isRole && this.rolePermissionClass != null;
        if (!this.queryCache.containsKey(queryKey |= discrimination.equals((Object)Discrimination.either) ? 32 : 0)) {
            boolean conditionsAdded = false;
            StringBuilder q = new StringBuilder();
            q.append("select p from ");
            q.append(useRoleTable ? this.rolePermissionClass.getName() : this.userPermissionClass.getName());
            q.append(" p");
            if (target != null) {
                q.append(" where p.");
                q.append(useRoleTable ? this.roleTargetProperty.getName() : this.targetProperty.getName());
                q.append(" = :target");
                conditionsAdded = true;
            }
            if (targets != null) {
                q.append(" where p.");
                q.append(useRoleTable ? this.roleTargetProperty.getName() : this.targetProperty.getName());
                q.append(" in (:targets)");
                conditionsAdded = true;
            }
            if (recipient != null) {
                q.append(conditionsAdded ? " and p." : " where p.");
                q.append(isRole ? this.roleProperty.getName() : this.userProperty.getName());
                q.append(" = :recipient");
                conditionsAdded = true;
            }
            if (!discrimination.equals((Object)Discrimination.either) && this.discriminatorProperty != null) {
                q.append(conditionsAdded ? " and p." : " where p.");
                q.append(this.discriminatorProperty.getName());
                q.append(" = :discriminator");
                conditionsAdded = true;
            }
            this.queryCache.put(queryKey, q.toString());
        }
        Query query = this.lookupEntityManager().createQuery(this.queryCache.get(queryKey));
        if (target != null) {
            query.setParameter("target", (Object)this.identifierPolicy.getIdentifier(target));
        }
        if (targets != null) {
            HashSet<String> identifiers = new HashSet<String>();
            for (Object t : targets) {
                identifiers.add(this.identifierPolicy.getIdentifier(t));
            }
            query.setParameter("targets", identifiers);
        }
        if (recipient != null) {
            query.setParameter("recipient", this.resolvePrincipalEntity(recipient));
        }
        if (!discrimination.equals((Object)Discrimination.either) && this.discriminatorProperty != null) {
            query.setParameter("discriminator", (Object)this.getDiscriminatorValue(discrimination.equals((Object)Discrimination.role)));
        }
        return query;
    }

    @Override
    public boolean grantPermission(Permission permission) {
        return this.updatePermissionActions(permission.getTarget(), permission.getRecipient(), new String[]{permission.getAction()}, true);
    }

    @Override
    public boolean revokePermission(Permission permission) {
        return this.updatePermissionActions(permission.getTarget(), permission.getRecipient(), new String[]{permission.getAction()}, false);
    }

    protected boolean updatePermissionActions(Object target, Principal recipient, String[] actions, boolean set) {
        boolean recipientIsRole = recipient instanceof Role;
        try {
            if (recipientIsRole) {
                if (this.rolePermissionClass != null) {
                    List permissions = this.createPermissionQuery(target, null, recipient, Discrimination.role).getResultList();
                    if (permissions.isEmpty()) {
                        if (!set) {
                            return true;
                        }
                        PermissionMetadata.ActionSet actionSet = this.metadata.createActionSet(target.getClass(), null);
                        for (String action : actions) {
                            actionSet.add(action);
                        }
                        Object instance = this.rolePermissionClass.newInstance();
                        this.roleTargetProperty.setValue(instance, this.identifierPolicy.getIdentifier(target));
                        this.roleActionProperty.setValue(instance, actionSet.toString());
                        this.roleProperty.setValue(instance, this.resolvePrincipalEntity(recipient));
                        this.lookupEntityManager().persist(instance);
                        return true;
                    }
                    Object instance = permissions.get(0);
                    PermissionMetadata.ActionSet actionSet = this.metadata.createActionSet(target.getClass(), this.roleActionProperty.getValue(instance).toString());
                    for (String action : actions) {
                        if (set) {
                            actionSet.add(action);
                            continue;
                        }
                        actionSet.remove(action);
                    }
                    if (permissions.size() > 1) {
                        for (Object p : permissions) {
                            actionSet.addMembers(this.roleActionProperty.getValue(p).toString());
                            if (p.equals(instance)) continue;
                            this.lookupEntityManager().remove(p);
                        }
                    }
                    if (!actionSet.isEmpty()) {
                        this.roleActionProperty.setValue(instance, actionSet.toString());
                        this.lookupEntityManager().merge(instance);
                    } else {
                        this.lookupEntityManager().remove(instance);
                    }
                    return true;
                }
                if (!this.discriminatorProperty.isSet()) {
                    throw new RuntimeException("Could not grant permission, rolePermissionClass not set");
                }
            }
            if (this.userPermissionClass == null) {
                throw new RuntimeException("Could not grant permission, userPermissionClass not set");
            }
            List permissions = this.createPermissionQuery(target, null, recipient, recipientIsRole ? Discrimination.role : Discrimination.user).getResultList();
            if (permissions.isEmpty()) {
                if (!set) {
                    return true;
                }
                PermissionMetadata.ActionSet actionSet = this.metadata.createActionSet(target.getClass(), null);
                for (String action : actions) {
                    actionSet.add(action);
                }
                Object instance = this.userPermissionClass.newInstance();
                this.targetProperty.setValue(instance, this.identifierPolicy.getIdentifier(target));
                this.actionProperty.setValue(instance, actionSet.toString());
                if (recipientIsRole) {
                    this.roleProperty.setValue(instance, this.resolvePrincipalEntity(recipient));
                } else {
                    this.userProperty.setValue(instance, this.resolvePrincipalEntity(recipient));
                }
                if (this.discriminatorProperty.isSet()) {
                    PermissionDiscriminator discriminator = this.discriminatorProperty.getAnnotation();
                    this.discriminatorProperty.setValue(instance, recipientIsRole ? discriminator.roleValue() : discriminator.userValue());
                }
                this.lookupEntityManager().persist(instance);
                return true;
            }
            Object instance = permissions.get(0);
            PermissionMetadata.ActionSet actionSet = this.metadata.createActionSet(target.getClass(), this.actionProperty.getValue(instance).toString());
            for (String action : actions) {
                if (set) {
                    actionSet.add(action);
                    continue;
                }
                actionSet.remove(action);
            }
            if (permissions.size() > 1) {
                for (Object p : permissions) {
                    actionSet.addMembers(this.actionProperty.getValue(p).toString());
                    if (p.equals(instance)) continue;
                    this.lookupEntityManager().remove(p);
                }
            }
            if (!actionSet.isEmpty()) {
                this.actionProperty.setValue(instance, actionSet.toString());
                this.lookupEntityManager().merge(instance);
            } else {
                this.lookupEntityManager().remove(instance);
            }
            return true;
        }
        catch (Exception ex) {
            throw new RuntimeException("Could not grant permission", ex);
        }
    }

    @Override
    public boolean grantPermissions(List<Permission> permissions) {
        Map<Object, Map<Principal, List<Permission>>> groupedPermissions = this.groupPermissions(permissions);
        for (Object target : groupedPermissions.keySet()) {
            Map<Principal, List<Permission>> recipientPermissions = groupedPermissions.get(target);
            for (Principal recipient : recipientPermissions.keySet()) {
                List<Permission> ps = recipientPermissions.get(recipient);
                String[] actions = new String[ps.size()];
                for (int i = 0; i < ps.size(); ++i) {
                    actions[i] = ps.get(i).getAction();
                }
                this.updatePermissionActions(target, recipient, actions, true);
            }
        }
        return true;
    }

    @Override
    public boolean revokePermissions(List<Permission> permissions) {
        Map<Object, Map<Principal, List<Permission>>> groupedPermissions = this.groupPermissions(permissions);
        for (Object target : groupedPermissions.keySet()) {
            Map<Principal, List<Permission>> recipientPermissions = groupedPermissions.get(target);
            for (Principal recipient : recipientPermissions.keySet()) {
                List<Permission> ps = recipientPermissions.get(recipient);
                String[] actions = new String[ps.size()];
                for (int i = 0; i < ps.size(); ++i) {
                    actions[i] = ps.get(i).getAction();
                }
                this.updatePermissionActions(target, recipient, actions, false);
            }
        }
        return true;
    }

    private Map<Object, Map<Principal, List<Permission>>> groupPermissions(List<Permission> permissions) {
        HashMap<Object, Map<Principal, List<Permission>>> groupedPermissions = new HashMap<Object, Map<Principal, List<Permission>>>();
        for (Permission permission : permissions) {
            Map recipientPermissions;
            if (!groupedPermissions.containsKey(permission.getTarget())) {
                groupedPermissions.put(permission.getTarget(), new HashMap());
            }
            if (!(recipientPermissions = (Map)groupedPermissions.get(permission.getTarget())).containsKey(permission.getRecipient())) {
                ArrayList<Permission> perms = new ArrayList<Permission>();
                perms.add(permission);
                recipientPermissions.put(permission.getRecipient(), perms);
                continue;
            }
            ((List)recipientPermissions.get(permission.getRecipient())).add(permission);
        }
        return groupedPermissions;
    }

    private String getDiscriminatorValue(boolean isRole) {
        PermissionDiscriminator discriminator = this.discriminatorProperty.getAnnotation();
        return isRole ? discriminator.roleValue() : discriminator.userValue();
    }

    protected Object resolvePrincipalEntity(Principal recipient) {
        boolean recipientIsRole = recipient instanceof Role;
        JpaIdentityStore identityStore = (JpaIdentityStore)Component.getInstance(JpaIdentityStore.class, true);
        if (identityStore != null) {
            if (recipientIsRole && this.roleProperty.isSet() && this.roleProperty.getPropertyType().equals(identityStore.getRoleClass())) {
                return identityStore.lookupRole(recipient.getName());
            }
            if (this.userProperty.getPropertyType().equals(identityStore.getUserClass())) {
                return identityStore.lookupUser(recipient.getName());
            }
        }
        return recipient.getName();
    }

    protected Principal resolvePrincipal(Object principal, boolean isUser) {
        IdentityStore ids = IdentityManager.instance().getRoleIdentityStore();
        JpaIdentityStore identityStore = null;
        if (ids instanceof JpaIdentityStore) {
            identityStore = (JpaIdentityStore)ids;
        }
        if (principal instanceof String) {
            return isUser ? new SimplePrincipal((String)principal) : new Role((String)principal, identityStore == null ? false : identityStore.isRoleConditional((String)principal));
        }
        if (identityStore != null) {
            if (isUser && identityStore.getUserClass().isAssignableFrom(principal.getClass())) {
                return new SimplePrincipal(identityStore.getUserName(principal));
            }
            if (!isUser && identityStore.getRoleClass().isAssignableFrom(principal.getClass())) {
                String name = identityStore.getRoleName(principal);
                return new Role(name, identityStore.isRoleConditional(name));
            }
        }
        throw new IllegalArgumentException("Cannot resolve principal name for principal " + principal);
    }

    @Override
    public List<Permission> listPermissions(Set<Object> targets, String action) {
        return this.listPermissions(null, targets, action);
    }

    @Override
    public List<Permission> listPermissions(Object target, String action) {
        return this.listPermissions(target, null, action);
    }

    protected List<Permission> listPermissions(Object target, Set<Object> targets, String action) {
        Principal principal;
        if (target != null && targets != null) {
            throw new IllegalArgumentException("Cannot specify both target and targets");
        }
        ArrayList<Permission> permissions = new ArrayList<Permission>();
        if (targets != null && targets.isEmpty()) {
            return permissions;
        }
        Query permissionQuery = targets != null ? this.createPermissionQuery(null, targets, null, Discrimination.either) : this.createPermissionQuery(target, null, null, Discrimination.either);
        List userPermissions = permissionQuery.getResultList();
        HashMap<String, Principal> principalCache = new HashMap<String, Principal>();
        boolean useDiscriminator = this.rolePermissionClass == null && this.discriminatorProperty.isSet();
        HashMap<String, Object> identifierCache = null;
        if (targets != null) {
            identifierCache = new HashMap<String, Object>();
            for (Object t : targets) {
                identifierCache.put(this.identifierPolicy.getIdentifier(t), t);
            }
        }
        for (Object permission : userPermissions) {
            PermissionMetadata.ActionSet actionSet = null;
            if (targets != null) {
                target = identifierCache.get(this.targetProperty.getValue(permission));
                if (target != null) {
                    actionSet = this.metadata.createActionSet(target.getClass(), this.actionProperty.getValue(permission).toString());
                }
            } else {
                actionSet = this.metadata.createActionSet(target.getClass(), this.actionProperty.getValue(permission).toString());
            }
            if (target == null || action != null && (actionSet == null || !actionSet.contains(action))) continue;
            boolean isUser = true;
            if (useDiscriminator && this.discriminatorProperty.getAnnotation().roleValue().equals(this.discriminatorProperty.getValue(permission))) {
                isUser = false;
            }
            principal = this.lookupPrincipal(principalCache, permission, isUser);
            if (action != null) {
                permissions.add(new Permission(target, action, principal));
                continue;
            }
            for (String a : actionSet.members()) {
                permissions.add(new Permission(target, a, principal));
            }
        }
        if (this.rolePermissionClass != null) {
            permissionQuery = targets != null ? this.createPermissionQuery(null, targets, null, Discrimination.role) : this.createPermissionQuery(target, null, null, Discrimination.role);
            List rolePermissions = permissionQuery.getResultList();
            for (Object permission : rolePermissions) {
                PermissionMetadata.ActionSet actionSet = null;
                if (targets != null) {
                    target = identifierCache.get(this.roleTargetProperty.getValue(permission));
                    if (target != null) {
                        actionSet = this.metadata.createActionSet(target.getClass(), this.roleActionProperty.getValue(permission).toString());
                    }
                } else {
                    actionSet = this.metadata.createActionSet(target.getClass(), this.roleActionProperty.getValue(permission).toString());
                }
                if (target == null || action != null && (actionSet == null || !actionSet.contains(action))) continue;
                principal = this.lookupPrincipal(principalCache, permission, false);
                if (action != null) {
                    permissions.add(new Permission(target, action, principal));
                    continue;
                }
                for (String a : actionSet.members()) {
                    permissions.add(new Permission(target, a, principal));
                }
            }
        }
        return permissions;
    }

    private Principal lookupPrincipal(Map<String, Principal> cache, Object permission, boolean isUser) {
        Principal principal = this.resolvePrincipal(isUser ? this.userProperty.getValue(permission) : this.roleProperty.getValue(permission), isUser);
        String key = (isUser ? "u:" : "r:") + principal.getName();
        if (!cache.containsKey(key)) {
            cache.put(key, principal);
        } else {
            principal = cache.get(key);
        }
        return principal;
    }

    @Override
    public List<Permission> listPermissions(Object target) {
        return this.listPermissions(target, null);
    }

    @Override
    public List<String> listAvailableActions(Object target) {
        return this.metadata.listAllowableActions(target.getClass());
    }

    private EntityManager lookupEntityManager() {
        return this.entityManager.getValue();
    }

    public Expressions.ValueExpression getEntityManager() {
        return this.entityManager;
    }

    public void setEntityManager(Expressions.ValueExpression expression) {
        this.entityManager = expression;
    }

    public Class getUserPermissionClass() {
        return this.userPermissionClass;
    }

    public void setUserPermissionClass(Class userPermissionClass) {
        this.userPermissionClass = userPermissionClass;
    }

    public Class getRolePermissionClass() {
        return this.rolePermissionClass;
    }

    public void setRolePermissionClass(Class rolePermissionClass) {
        this.rolePermissionClass = rolePermissionClass;
    }

    @Override
    public void clearPermissions(Object target) {
        EntityManager em = this.lookupEntityManager();
        String identifier = this.identifierPolicy.getIdentifier(target);
        em.createQuery("delete from " + this.userPermissionClass.getName() + " p where p." + this.targetProperty.getName() + " = :target").setParameter("target", (Object)identifier).executeUpdate();
        if (this.rolePermissionClass != null) {
            em.createQuery("delete from " + this.rolePermissionClass.getName() + " p where p." + this.roleTargetProperty.getName() + " = :target").setParameter("target", (Object)identifier).executeUpdate();
        }
    }

    private static enum Discrimination {
        user,
        role,
        either;

    }
}

