/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.jboss.as.domain.management.DomainManagementMessages;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class SSLIdentityService
implements Service<SSLIdentityService> {
    public static final String SERVICE_SUFFIX = "ssl";
    private final String protocol;
    private final char[] password;
    private final InjectedValue<KeyStore> keystore = new InjectedValue();
    private final InjectedValue<KeyStore> truststore = new InjectedValue();
    private volatile SSLContext sslContext;

    public SSLIdentityService(String protocol, char[] password) {
        this.protocol = protocol;
        this.password = password;
    }

    public void start(StartContext context) throws StartException {
        try {
            KeyManager[] keyManagers = null;
            KeyStore theKeyStore = (KeyStore)this.keystore.getOptionalValue();
            if (theKeyStore != null) {
                KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
                keyManagerFactory.init(theKeyStore, this.password);
                keyManagers = keyManagerFactory.getKeyManagers();
            }
            TrustManager[] trustManagers = null;
            KeyStore theTrustStore = (KeyStore)this.truststore.getOptionalValue();
            if (theTrustStore != null) {
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("SunX509");
                trustManagerFactory.init(theTrustStore);
                trustManagers = trustManagerFactory.getTrustManagers();
            }
            SSLContext sslContext = SSLContext.getInstance(this.protocol);
            sslContext.init(keyManagers, trustManagers, null);
            this.sslContext = sslContext;
        }
        catch (NoSuchAlgorithmException nsae) {
            throw DomainManagementMessages.MESSAGES.unableToStart(nsae);
        }
        catch (KeyManagementException kme) {
            throw DomainManagementMessages.MESSAGES.unableToStart(kme);
        }
        catch (KeyStoreException kse) {
            throw DomainManagementMessages.MESSAGES.unableToStart(kse);
        }
        catch (UnrecoverableKeyException e) {
            throw DomainManagementMessages.MESSAGES.unableToStart(e);
        }
    }

    public void stop(StopContext context) {
    }

    public SSLIdentityService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public InjectedValue<KeyStore> getKeyStoreInjector() {
        return this.keystore;
    }

    public InjectedValue<KeyStore> getTrustStoreInjector() {
        return this.truststore;
    }

    SSLContext getSSLContext() {
        return this.sslContext;
    }

    boolean hasTrustStore() {
        return this.truststore.getOptionalValue() != null;
    }
}

