/*
 * Decompiled with CFR 0.152.
 */
package flex.management.runtime.messaging.services;

import flex.management.BaseControl;
import flex.management.runtime.messaging.services.HTTPProxyServiceControlMBean;
import flex.management.runtime.messaging.services.ServiceControl;
import flex.messaging.services.HTTPProxyService;
import flex.messaging.services.Service;
import java.util.Date;

public class HTTPProxyServiceControl
extends ServiceControl
implements HTTPProxyServiceControlMBean {
    private static final String TYPE = "HTTPProxyService";
    private int invokeSOAPCount = 0;
    private Date lastInvokeSOAPTimestamp;
    private long invokeSOAPStart;
    private int invokeHTTPCount = 0;
    private Date lastInvokeHTTPTimestamp;
    private long invokeHTTPStart = this.invokeSOAPStart = System.currentTimeMillis();

    public HTTPProxyServiceControl(HTTPProxyService service, BaseControl parent) {
        super((Service)service, parent);
    }

    public String getType() {
        return TYPE;
    }

    public Integer getInvokeSOAPCount() {
        return new Integer(this.invokeSOAPCount);
    }

    public void resetInvokeSOAPCount() {
        this.invokeSOAPStart = System.currentTimeMillis();
        this.invokeSOAPCount = 0;
        this.lastInvokeSOAPTimestamp = null;
    }

    public void incrementInvokeSOAPCount() {
        ++this.invokeSOAPCount;
        this.lastInvokeSOAPTimestamp = new Date();
    }

    public Date getLastInvokeSOAPTimestamp() {
        return this.lastInvokeSOAPTimestamp;
    }

    public Double getInvokeSOAPFrequency() {
        if (this.invokeSOAPCount > 0) {
            double runtime = this.differenceInMinutes(this.invokeSOAPStart, System.currentTimeMillis());
            return new Double((double)this.invokeSOAPCount / runtime);
        }
        return new Double(0.0);
    }

    public Integer getInvokeHTTPCount() {
        return new Integer(this.invokeHTTPCount);
    }

    public void resetInvokeHTTPCount() {
        this.invokeHTTPStart = System.currentTimeMillis();
        this.invokeHTTPCount = 0;
        this.lastInvokeHTTPTimestamp = null;
    }

    public void incrementInvokeHTTPCount() {
        ++this.invokeHTTPCount;
        this.lastInvokeHTTPTimestamp = new Date();
    }

    public Date getLastInvokeHTTPTimestamp() {
        return this.lastInvokeHTTPTimestamp;
    }

    public Double getInvokeHTTPFrequency() {
        if (this.invokeHTTPCount > 0) {
            double runtime = this.differenceInMinutes(this.invokeHTTPStart, System.currentTimeMillis());
            return new Double((double)this.invokeHTTPCount / runtime);
        }
        return new Double(0.0);
    }
}

