/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.resolver.spi;

import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.resolver.XModuleIdentity;
import org.osgi.framework.Version;

final class AbstractModuleIdentity
implements XModuleIdentity {
    private String name;
    private Version version;
    private int revision;

    AbstractModuleIdentity(OSGiMetaData metadata, int revision) {
        if (metadata == null) {
            throw new IllegalArgumentException("Null metadata");
        }
        this.name = metadata.getBundleSymbolicName();
        this.version = metadata.getBundleVersion();
        this.revision = revision;
    }

    AbstractModuleIdentity(String name, Version version, int revision) {
        if (name == null) {
            throw new IllegalArgumentException("Null name part");
        }
        if (version == null) {
            version = Version.emptyVersion;
        }
        this.name = name;
        this.version = version;
        this.revision = revision;
    }

    public String getName() {
        return this.name;
    }

    public Version getVersion() {
        return this.version;
    }

    public int getRevision() {
        return this.revision;
    }

    public static AbstractModuleIdentity parse(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Null string");
        }
        String[] parts = string.split(":");
        if (parts.length < 2 || parts.length > 3) {
            throw new IllegalArgumentException("Invalid string: " + string);
        }
        int revision = 0;
        if (parts.length > 2) {
            if (!parts[2].startsWith("rev")) {
                throw new IllegalArgumentException("Invalid revision part: " + parts[2]);
            }
            revision = Integer.parseInt(parts[2].substring(3));
        }
        return new AbstractModuleIdentity(parts[0], Version.parseVersion((String)parts[1]), revision);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AbstractModuleIdentity)) {
            return false;
        }
        return this.toString().equals(obj.toString());
    }

    public String toString() {
        String string = this.name + ":" + this.version;
        if (this.revision > 0) {
            string = string + ":rev" + this.revision;
        }
        return string;
    }
}

