/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.client;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.jboss.as.controller.client.ControllerClientMessages;
import org.jboss.as.controller.client.Operation;
import org.jboss.as.controller.client.OperationImpl;
import org.jboss.dmr.ModelNode;

public class OperationBuilder {
    private final ModelNode operation;
    private volatile List<InputStream> inputStreams;
    private boolean autoCloseStreams = false;

    public OperationBuilder(ModelNode operation) {
        this(operation, false);
    }

    public OperationBuilder(ModelNode operation, boolean autoCloseStreams) {
        if (operation == null) {
            throw ControllerClientMessages.MESSAGES.nullVar("operation");
        }
        this.operation = operation;
        this.autoCloseStreams = autoCloseStreams;
    }

    public OperationBuilder addInputStream(InputStream in) {
        if (in == null) {
            throw ControllerClientMessages.MESSAGES.nullVar("input-stream");
        }
        if (this.inputStreams == null) {
            this.inputStreams = new ArrayList<InputStream>();
        }
        this.inputStreams.add(in);
        return this;
    }

    public int getInputStreamCount() {
        List<InputStream> list = this.inputStreams;
        return list == null ? 0 : list.size();
    }

    public void setAutoCloseStreams(boolean autoCloseStreams) {
        this.autoCloseStreams = autoCloseStreams;
    }

    public Operation build() {
        return new OperationImpl(this.operation, this.inputStreams, this.autoCloseStreams);
    }

    public static OperationBuilder create(ModelNode operation) {
        return new OperationBuilder(operation);
    }

    public static OperationBuilder create(ModelNode operation, boolean autoCloseStreams) {
        return new OperationBuilder(operation, autoCloseStreams);
    }
}

