/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache;

import org.jboss.cache.CacheSPI;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.notifications.annotation.CacheListener;
import org.jboss.cache.notifications.annotation.CacheStarted;
import org.jboss.cache.notifications.annotation.CacheStopped;
import org.jboss.cache.notifications.annotation.NodeActivated;
import org.jboss.cache.notifications.annotation.NodeCreated;
import org.jboss.cache.notifications.annotation.NodeEvicted;
import org.jboss.cache.notifications.annotation.NodeLoaded;
import org.jboss.cache.notifications.annotation.NodeModified;
import org.jboss.cache.notifications.annotation.NodeMoved;
import org.jboss.cache.notifications.annotation.NodePassivated;
import org.jboss.cache.notifications.annotation.NodeRemoved;
import org.jboss.cache.notifications.annotation.NodeVisited;
import org.jboss.cache.notifications.annotation.ViewChanged;
import org.jboss.cache.notifications.event.Event;
import org.jboss.cache.notifications.event.NodeEvent;
import org.jboss.cache.notifications.event.ViewChangedEvent;

@CacheListener
public class ConsoleListener {
    private CacheSPI cache;
    private boolean startCache;

    public ConsoleListener(CacheSPI cache) throws Exception {
        this(cache, true, true);
    }

    public ConsoleListener(CacheSPI cache, boolean startCache, boolean stopCache) throws Exception {
        this.cache = cache;
        this.startCache = startCache;
        if (stopCache) {
            new ListenerShutdownHook().register();
        }
    }

    public void listen() throws Exception {
        this.listen(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void listen(boolean wait) throws Exception {
        this.cache.getNotifier().addCacheListener(this);
        if (this.startCache) {
            this.cache.start();
        }
        ConsoleListener consoleListener = this;
        synchronized (consoleListener) {
            while (wait) {
                this.wait();
            }
        }
    }

    @CacheStarted
    @CacheStopped
    public void printDetails(Event e) {
        this.printEvent("Cache started.");
    }

    @NodeCreated
    @NodeLoaded
    @NodeModified
    @NodeRemoved
    @NodeVisited
    @NodeMoved
    @NodeEvicted
    @NodeActivated
    @NodePassivated
    public void printDetailsWithFqn(NodeEvent e) {
        if (e.isPre()) {
            this.printEvent("Event " + (Object)((Object)e.getType()) + " on node [" + e.getFqn() + "] about to be invoked");
        } else {
            this.printEvent("Event " + (Object)((Object)e.getType()) + " on node [" + e.getFqn() + "] invoked");
        }
    }

    @ViewChanged
    public void printNewView(ViewChangedEvent e) {
        this.printEvent("View change: " + e.getNewView());
    }

    private void printEvent(String eventSuffix) {
        System.out.print("EVENT");
        System.out.print(' ');
        System.out.println(eventSuffix);
    }

    public static void main(String[] args) {
        String DEFAULT_CONFIG_FILE_NAME = "jboss-cache.xml";
        try {
            String configFileName = "jboss-cache.xml";
            if (args.length >= 1) {
                configFileName = args[0];
            } else {
                System.out.print("No xml config file argument is supplied. Will use jboss-cache.xml from classpath");
            }
            CacheSPI cache = (CacheSPI)new DefaultCacheFactory().createCache(configFileName);
            ConsoleListener listener = new ConsoleListener(cache);
            listener.listen();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private class ListenerShutdownHook
    extends Thread {
        private ListenerShutdownHook() {
        }

        public void register() {
            Runtime.getRuntime().addShutdownHook(this);
        }

        public void run() {
            ConsoleListener.this.cache.stop();
        }
    }
}

