/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.transaction.Transaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.commands.VisitableCommand;
import org.jboss.cache.config.Option;
import org.jboss.cache.lock.NodeLock;
import org.jboss.cache.marshall.MethodCall;
import org.jboss.cache.transaction.GlobalTransaction;
import org.jboss.cache.transaction.TransactionEntry;
import org.jboss.cache.transaction.TransactionTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvocationContext
implements Cloneable {
    private static final Log log = LogFactory.getLog(InvocationContext.class);
    private static final boolean trace = log.isTraceEnabled();
    private Transaction transaction;
    private GlobalTransaction globalTransaction;
    private TransactionEntry transactionEntry;
    private Option optionOverrides;
    private boolean originLocal = true;
    private boolean txHasMods;
    private boolean localRollbackOnly;
    @Deprecated
    private MethodCall methodCall;
    @Deprecated
    private VisitableCommand command;
    List<NodeLock> invocationLocks;

    public void setLocalRollbackOnly(boolean localRollbackOnly) {
        this.localRollbackOnly = localRollbackOnly;
    }

    public Transaction getTransaction() {
        return this.transaction;
    }

    public void setTransaction(Transaction transaction) {
        this.transaction = transaction;
    }

    public TransactionEntry getTransactionEntry() {
        return this.transactionEntry;
    }

    public void setTransactionEntry(TransactionEntry transactionEntry) {
        this.transactionEntry = transactionEntry;
    }

    public GlobalTransaction getGlobalTransaction() {
        return this.globalTransaction;
    }

    public void setGlobalTransaction(GlobalTransaction globalTransaction) {
        this.globalTransaction = globalTransaction;
    }

    public Option getOptionOverrides() {
        if (this.optionOverrides == null) {
            this.optionOverrides = new Option();
        }
        return this.optionOverrides;
    }

    public boolean isOptionsUninitialised() {
        return this.optionOverrides == null;
    }

    public void setOptionOverrides(Option optionOverrides) {
        this.optionOverrides = optionOverrides;
    }

    public boolean isOriginLocal() {
        return this.originLocal;
    }

    public List<NodeLock> getInvocationLocksAcquired() {
        return this.invocationLocks;
    }

    public void addInvocationLocksAcquired(Collection<NodeLock> locks) {
        if (this.invocationLocks == null) {
            this.invocationLocks = new ArrayList<NodeLock>(5);
        }
        this.invocationLocks.addAll(locks);
    }

    public void addInvocationLockAcquired(NodeLock l) {
        if (this.invocationLocks == null) {
            this.invocationLocks = new ArrayList<NodeLock>(5);
        }
        this.invocationLocks.add(l);
    }

    public boolean isLockingSuppressed() {
        return this.getOptionOverrides() != null && this.getOptionOverrides().isSuppressLocking();
    }

    public void setOriginLocal(boolean originLocal) {
        this.originLocal = originLocal;
    }

    public String toString() {
        return "InvocationContext{transaction=" + this.transaction + ", globalTransaction=" + this.globalTransaction + ", optionOverrides=" + this.optionOverrides + ", originLocal=" + this.originLocal + ", txHasMods=" + this.txHasMods + '}';
    }

    public boolean isTxHasMods() {
        return this.txHasMods;
    }

    public void setTxHasMods(boolean b) {
        this.txHasMods = b;
    }

    public boolean isLocalRollbackOnly() {
        return this.localRollbackOnly;
    }

    public void reset() {
        this.transaction = null;
        this.globalTransaction = null;
        this.optionOverrides = null;
        this.originLocal = true;
        this.txHasMods = false;
        this.invocationLocks = null;
        this.methodCall = null;
        this.command = null;
    }

    public InvocationContext clone() throws CloneNotSupportedException {
        InvocationContext clone = (InvocationContext)super.clone();
        clone.setOptionOverrides(this.getOptionOverrides().clone());
        return clone;
    }

    public void setState(InvocationContext template) {
        if (template == null) {
            throw new NullPointerException("Template InvocationContext passed in to InvocationContext.setState() passed in is null");
        }
        this.setGlobalTransaction(template.getGlobalTransaction());
        this.setLocalRollbackOnly(template.isLocalRollbackOnly());
        this.setOptionOverrides(template.getOptionOverrides());
        this.setOriginLocal(template.isOriginLocal());
        this.setTransaction(template.getTransaction());
        this.setTxHasMods(template.isTxHasMods());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InvocationContext that = (InvocationContext)o;
        if (this.localRollbackOnly != that.localRollbackOnly) {
            return false;
        }
        if (this.originLocal != that.originLocal) {
            return false;
        }
        if (this.txHasMods != that.txHasMods) {
            return false;
        }
        if (this.globalTransaction != null ? !this.globalTransaction.equals(that.globalTransaction) : that.globalTransaction != null) {
            return false;
        }
        if (this.optionOverrides != null ? !this.optionOverrides.equals(that.optionOverrides) : that.optionOverrides != null) {
            return false;
        }
        return !(this.transaction != null ? !this.transaction.equals(that.transaction) : that.transaction != null);
    }

    public int hashCode() {
        int result = this.transaction != null ? this.transaction.hashCode() : 0;
        result = 29 * result + (this.globalTransaction != null ? this.globalTransaction.hashCode() : 0);
        result = 29 * result + (this.optionOverrides != null ? this.optionOverrides.hashCode() : 0);
        result = 29 * result + (this.originLocal ? 1 : 0);
        result = 29 * result + (this.txHasMods ? 1 : 0);
        result = 29 * result + (this.localRollbackOnly ? 1 : 0);
        return result;
    }

    @Deprecated
    public MethodCall getMethodCall() {
        if (this.methodCall == null) {
            this.methodCall = this.createMethodCall();
        }
        return this.methodCall;
    }

    private MethodCall createMethodCall() {
        if (this.command == null) {
            return null;
        }
        MethodCall call = new MethodCall();
        call.setMethodId(this.command.getCommandId());
        call.setArgs(this.command.getParameters());
        return call;
    }

    @Deprecated
    public void setMethodCall(MethodCall methodCall) {
        this.methodCall = methodCall;
    }

    public static InvocationContext fromMethodCall(MethodCall methodCall) {
        InvocationContext ctx = new InvocationContext();
        ctx.methodCall = methodCall;
        return ctx;
    }

    public long getContextLockAcquisitionTimeout(long timeout) {
        if (this.getOptionOverrides() != null && this.getOptionOverrides().getLockAcquisitionTimeout() >= 0) {
            timeout = this.getOptionOverrides().getLockAcquisitionTimeout();
        }
        return timeout;
    }

    @Deprecated
    public void setCommand(VisitableCommand cacheCommand) {
        this.command = cacheCommand;
    }

    @Deprecated
    public VisitableCommand getCommand() {
        return this.command;
    }

    public boolean isValidTransaction() {
        return this.transaction != null && TransactionTable.isValid(this.transaction);
    }

    public void throwIfNeeded(Throwable e) throws Throwable {
        boolean shouldRethtrow;
        Option optionOverride = this.getOptionOverrides();
        boolean bl = shouldRethtrow = optionOverride == null || !optionOverride.isFailSilently();
        if (!shouldRethtrow) {
            if (trace) {
                log.trace((Object)"There was a problem handling this request, but failSilently was set, so suppressing exception", e);
            }
            return;
        }
        throw e;
    }
}

