/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.buddyreplication;

import java.util.ArrayList;
import org.jboss.cache.CacheException;
import org.jboss.cache.Fqn;
import org.jgroups.Address;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuddyFqnTransformer {
    public static final String BUDDY_BACKUP_SUBTREE = "_BUDDY_BACKUP_";
    public static final Fqn<String> BUDDY_BACKUP_SUBTREE_FQN = Fqn.fromString("_BUDDY_BACKUP_");

    public Fqn getBackupFqn(Address dataOwnerAddress, Fqn origFqn) {
        return this.getBackupFqn(this.getGroupNameFromAddress(dataOwnerAddress), origFqn);
    }

    public Fqn getBackupFqn(String buddyGroupName, Fqn origFqn) {
        if (this.isBackupFqn(origFqn)) {
            throw new CacheException("Cannot make a backup Fqn from a backup Fqn! Attempting to create a backup of " + origFqn);
        }
        ArrayList<String> elements = new ArrayList<String>(origFqn.size() + 2);
        elements.add(BUDDY_BACKUP_SUBTREE);
        elements.add(buddyGroupName);
        elements.addAll(origFqn.peekElements());
        return Fqn.fromList(elements);
    }

    public Fqn getBackupFqn(Fqn buddyGroupRoot, Fqn origFqn) {
        if (this.isBackupFqn(origFqn)) {
            throw new CacheException("Cannot make a backup Fqn from a backup Fqn! Attempting to create a backup of " + origFqn);
        }
        ArrayList<String> elements = new ArrayList<String>(origFqn.size() + 2);
        elements.add(BUDDY_BACKUP_SUBTREE);
        elements.add((String)buddyGroupRoot.get(1));
        elements.addAll(origFqn.peekElements());
        return Fqn.fromList(elements);
    }

    public boolean isBackupFqn(Fqn name) {
        return name != null && name.hasElement(BUDDY_BACKUP_SUBTREE);
    }

    public Fqn getActualFqn(Fqn fqn) {
        if (!this.isBackupFqn(fqn)) {
            return fqn;
        }
        if (fqn.equals(BUDDY_BACKUP_SUBTREE_FQN)) {
            return Fqn.ROOT;
        }
        return fqn.getSubFqn(this.isDeadBackupFqn(fqn) ? 3 : 2, fqn.size());
    }

    public boolean isDeadBackupFqn(Fqn name) {
        if (name == null || name.size() < 2) {
            return false;
        }
        Object elem1 = name.get(1);
        if (elem1 instanceof String) {
            String strElem1 = (String)elem1;
            return name.hasElement(BUDDY_BACKUP_SUBTREE) && strElem1.endsWith(":DEAD");
        }
        return false;
    }

    public Fqn<String> getBackupRoot(Address dataOwner) {
        return Fqn.fromRelativeElements(BUDDY_BACKUP_SUBTREE_FQN, this.getGroupNameFromAddress(dataOwner));
    }

    public Fqn<String> getDeadBackupRoot(Address dataOwner) {
        return Fqn.fromRelativeElements(BUDDY_BACKUP_SUBTREE_FQN, this.getGroupNameFromAddress(dataOwner) + ":DEAD");
    }

    public boolean isDeadBackupRoot(Fqn f) {
        return f.getParent().equals(BUDDY_BACKUP_SUBTREE_FQN) && f.getLastElementAsString().endsWith(":DEAD");
    }

    public String getGroupNameFromAddress(Address address) {
        return address.toString().replace(':', '_');
    }

    public Fqn getBackupRootFromFqn(Fqn fqn) {
        if (this.isBackupFqn(fqn) && fqn.size() > 1) {
            return fqn.getSubFqn(0, this.isDeadBackupFqn(fqn) ? 3 : 2);
        }
        return Fqn.ROOT;
    }
}

