/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.commands.read;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.Node;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.commands.Visitor;
import org.jboss.cache.commands.read.AbstractDataCommand;

public class GetChildrenNamesCommand
extends AbstractDataCommand {
    public static final int METHOD_ID = 23;

    public GetChildrenNamesCommand() {
    }

    public GetChildrenNamesCommand(Fqn fqn) {
        this.fqn = fqn;
    }

    public Object perform(InvocationContext ctx) {
        NodeSPI n = this.dataContainer.peek(this.fqn);
        if (n == null) {
            return null;
        }
        Map childrenMap = n.getChildrenMapDirect();
        if (childrenMap == null || childrenMap.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet childNames = new HashSet();
        Collection s = childrenMap.values();
        for (Node c : s) {
            NodeSPI child = (NodeSPI)c;
            if (child.isDeleted()) continue;
            Object e = child.getFqn().getLastElement();
            childNames.add(e);
        }
        return childNames;
    }

    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitGetChildrenNamesCommand(ctx, this);
    }

    public int getCommandId() {
        return 23;
    }
}

