/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.commands.write;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.DataContainer;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.NodeNotExistsException;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.commands.ReversibleCommand;
import org.jboss.cache.commands.Visitor;
import org.jboss.cache.commands.read.AbstractDataCommand;
import org.jboss.cache.notifications.Notifier;
import org.jboss.cache.transaction.GlobalTransaction;

public class MoveCommand
extends AbstractDataCommand
implements ReversibleCommand {
    public static final int METHOD_ID = 36;
    private static final Log log = LogFactory.getLog(MoveCommand.class);
    private static boolean trace = log.isTraceEnabled();
    private Notifier notifier;
    private Fqn to;
    private GlobalTransaction globalTransaction;

    public MoveCommand() {
    }

    public void initialize(Notifier notifier, DataContainer dataContainer) {
        this.notifier = notifier;
        this.dataContainer = dataContainer;
    }

    public MoveCommand(Fqn from, Fqn to) {
        this.fqn = from;
        this.to = to;
    }

    public GlobalTransaction getGlobalTransaction() {
        return this.globalTransaction;
    }

    public void setGlobalTransaction(GlobalTransaction globalTransaction) {
        this.globalTransaction = globalTransaction;
    }

    public Object perform(InvocationContext ctx) {
        this.move(this.fqn, this.to, false, ctx);
        return null;
    }

    public void rollback() {
        this.move(Fqn.fromRelativeElements(this.to, this.fqn.getLastElement()), this.fqn.getParent(), true, null);
    }

    private void adjustFqn(NodeSPI node, Fqn newBase) {
        Fqn<Object> newFqn = Fqn.fromRelativeElements(newBase, node.getFqn().getLastElement());
        node.setFqn(newFqn);
    }

    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitMoveCommand(ctx, this);
    }

    private void move(Fqn toMoveFqn, Fqn newParentFqn, boolean skipNotifications, InvocationContext ctx) {
        NodeSPI newParent = this.dataContainer.peek(newParentFqn, false, false);
        if (newParent == null) {
            throw new NodeNotExistsException("New parent node " + newParentFqn + " does not exist when attempting to move node!!");
        }
        NodeSPI node = this.dataContainer.peek(toMoveFqn, false, false);
        if (node == null) {
            throw new NodeNotExistsException("Node " + toMoveFqn + " does not exist when attempting to move node!!");
        }
        if (trace) {
            log.trace((Object)("Moving " + this.fqn + " to sit under " + this.to));
        }
        NodeSPI oldParent = node.getParent();
        Object nodeName = toMoveFqn.getLastElement();
        oldParent.removeChildDirect(nodeName);
        newParent.addChild(nodeName, node);
        if (!skipNotifications) {
            this.notifier.notifyNodeMoved(toMoveFqn, Fqn.fromRelativeElements(newParentFqn, toMoveFqn.getLastElement()), true, ctx);
        }
        this.adjustFqn(node, newParent.getFqn());
        if (!skipNotifications) {
            this.notifier.notifyNodeMoved(toMoveFqn, Fqn.fromRelativeElements(newParentFqn, toMoveFqn.getLastElement()), false, ctx);
        }
    }

    public Fqn getTo() {
        return this.to;
    }

    public int getCommandId() {
        return 36;
    }

    public Object[] getParameters() {
        return new Object[]{this.fqn, this.to};
    }

    public void setParameters(int commandId, Object[] args) {
        this.fqn = (Fqn)args[0];
        this.to = (Fqn)args[1];
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MoveCommand that = (MoveCommand)o;
        return !(this.to != null ? !this.to.equals(that.to) : that.to != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.to != null ? this.to.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "MoveCommand{fqn=" + this.fqn + ", to=" + this.to + '}';
    }
}

