/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.commands.write;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.commands.Visitor;
import org.jboss.cache.commands.write.AbstractVersionedDataCommand;
import org.jboss.cache.notifications.event.NodeModifiedEvent;
import org.jboss.cache.optimistic.DataVersion;
import org.jboss.cache.transaction.GlobalTransaction;

public class PutDataMapCommand
extends AbstractVersionedDataCommand {
    public static final int METHOD_ID = 1;
    public static final int ERASE_METHOD_ID = 2;
    public static final int VERSIONED_METHOD_ID = 37;
    public static final int ERASE_VERSIONED_METHOD_ID = 38;
    private static final Log log = LogFactory.getLog(PutDataMapCommand.class);
    private static boolean trace = log.isTraceEnabled();
    private Map data;
    private Map oldData;

    public PutDataMapCommand(GlobalTransaction globalTransaction, Fqn fqn, Map data) {
        this.globalTransaction = globalTransaction;
        this.fqn = fqn;
        this.data = data;
    }

    public PutDataMapCommand() {
    }

    public Object perform(InvocationContext ctx) {
        NodeSPI nodeSPI;
        Map existingData;
        if (trace) {
            log.trace((Object)("perform(" + this.globalTransaction + ", \"" + this.fqn + "\", " + this.data + ")"));
        }
        if (!(existingData = (nodeSPI = this.dataContainer.peekStrict(this.globalTransaction, this.fqn, false)).getDataDirect()).isEmpty()) {
            this.oldData = new HashMap(existingData);
        }
        if (this.notifier.shouldNotifyOnNodeModified()) {
            this.notifier.notifyNodeModified(this.fqn, true, NodeModifiedEvent.ModificationType.PUT_MAP, this.oldData == null ? Collections.emptyMap() : this.oldData, ctx);
        }
        nodeSPI.putAllDirect(this.data);
        if (this.notifier.shouldNotifyOnNodeModified()) {
            this.notifier.notifyNodeModified(this.fqn, false, NodeModifiedEvent.ModificationType.PUT_MAP, nodeSPI.getDataDirect(), ctx);
        }
        return null;
    }

    public void rollback() {
        NodeSPI n;
        if (trace) {
            log.trace((Object)("rollback(" + this.globalTransaction + ", " + this.fqn + ", " + this.data + ")"));
        }
        if ((n = this.dataContainer.peek(this.fqn, false, true)) != null) {
            n.clearDataDirect();
            if (this.oldData != null) {
                n.putAllDirect(this.oldData);
            }
        }
    }

    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitPutDataMapCommand(ctx, this);
    }

    public Map getData() {
        return this.data;
    }

    public void setData(Map data) {
        this.data = data;
    }

    public int getCommandId() {
        if (this.isVersioned()) {
            return 37;
        }
        return 1;
    }

    public Object[] getParameters() {
        if (this.isVersioned()) {
            return new Object[]{this.globalTransaction, this.fqn, this.data, false, this.dataVersion};
        }
        return new Object[]{this.globalTransaction, this.fqn, this.data, false};
    }

    public void setParameters(int commandId, Object[] args) {
        this.globalTransaction = (GlobalTransaction)args[0];
        this.fqn = (Fqn)args[1];
        this.data = (Map)args[2];
        if (this.isVersionedId(commandId)) {
            this.dataVersion = (DataVersion)args[4];
        }
    }

    protected boolean isVersionedId(int id) {
        return id == 37 || id == 38;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PutDataMapCommand that = (PutDataMapCommand)o;
        if (this.data != null ? !((Object)this.data).equals(that.data) : that.data != null) {
            return false;
        }
        return !(this.globalTransaction != null ? !this.globalTransaction.equals(that.globalTransaction) : that.globalTransaction != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.globalTransaction != null ? this.globalTransaction.hashCode() : 0);
        result = 31 * result + (this.data != null ? ((Object)this.data).hashCode() : 0);
        return result;
    }

    public String toString() {
        return "PutDataMapCommand{fqn=" + this.fqn + ", dataVersion=" + this.dataVersion + ", data=" + this.data + ", globalTransaction=" + this.globalTransaction + '}';
    }

    Map getOldData() {
        return this.oldData;
    }
}

