/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import org.jboss.cache.Fqn;
import org.jboss.cache.Region;
import org.jboss.cache.buddyreplication.BuddyFqnTransformer;
import org.jboss.cache.eviction.NodeEventType;
import org.jboss.cache.factories.annotations.Inject;
import org.jboss.cache.interceptors.EvictionInterceptor;

public class BuddyRegionAwareEvictionInterceptor
extends EvictionInterceptor {
    private BuddyFqnTransformer buddyFqnTransformer;

    @Inject
    public void initialize(BuddyFqnTransformer transformer) {
        this.buddyFqnTransformer = transformer;
    }

    protected Region getRegion(Fqn fqn, NodeEventType type) {
        Region r = super.getRegion(fqn, type);
        if (r != null) {
            return r;
        }
        if (this.buddyFqnTransformer.isBackupFqn(fqn)) {
            Fqn actualFqn = this.buddyFqnTransformer.getActualFqn(fqn);
            Fqn backupRoot = this.buddyFqnTransformer.getBackupRootFromFqn(fqn);
            Region actualRegion = this.regionManager.getRegion(actualFqn, Region.Type.EVICTION, false);
            if (actualRegion == null) {
                return null;
            }
            Region newRegion = this.regionManager.getRegion(Fqn.fromRelativeFqn(backupRoot, actualRegion.getFqn()), Region.Type.EVICTION, true);
            newRegion.setEvictionPolicy(actualRegion.getEvictionPolicyConfig());
            return newRegion;
        }
        return null;
    }
}

