/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import org.jboss.cache.InvocationContext;
import org.jboss.cache.commands.tx.CommitCommand;
import org.jboss.cache.commands.tx.PrepareCommand;
import org.jboss.cache.commands.tx.RollbackCommand;
import org.jboss.cache.factories.annotations.Inject;
import org.jboss.cache.interceptors.BaseTransactionalContextInterceptor;
import org.jboss.cache.notifications.Notifier;

public class NotificationInterceptor
extends BaseTransactionalContextInterceptor {
    private Notifier notifier;

    @Inject
    public void injectDependencies(Notifier notifier) {
        this.notifier = notifier;
    }

    public Object visitPrepareCommand(InvocationContext ctx, PrepareCommand command) throws Throwable {
        Object retval = this.invokeNextInterceptor(ctx, command);
        if (command.isOnePhaseCommit()) {
            this.notifier.notifyTransactionCompleted(ctx.getTransaction(), true, ctx);
        }
        return retval;
    }

    public Object visitCommitCommand(InvocationContext ctx, CommitCommand command) throws Throwable {
        Object retval = this.invokeNextInterceptor(ctx, command);
        this.notifier.notifyTransactionCompleted(ctx.getTransaction(), true, ctx);
        return retval;
    }

    public Object visitRollbackCommand(InvocationContext ctx, RollbackCommand command) throws Throwable {
        Object retval = this.invokeNextInterceptor(ctx, command);
        this.notifier.notifyTransactionCompleted(ctx.getTransaction(), false, ctx);
        return retval;
    }
}

