/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader;

import java.util.Properties;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.loader.TcpDelegatingCacheLoader;
import org.jboss.cache.util.Util;

public class TcpDelegatingCacheLoaderConfig
extends CacheLoaderConfig.IndividualCacheLoaderConfig {
    private static final long serialVersionUID = -3138555335000168505L;
    private String host = "localhost";
    private int port = 7500;
    private int timeout = 5000;
    private int reconnectWaitTime = 500;

    public TcpDelegatingCacheLoaderConfig() {
        this.setClassName(TcpDelegatingCacheLoader.class.getName());
    }

    TcpDelegatingCacheLoaderConfig(CacheLoaderConfig.IndividualCacheLoaderConfig base) {
        this.setClassName(TcpDelegatingCacheLoader.class.getName());
        this.populateFromBaseConfig(base);
    }

    TcpDelegatingCacheLoaderConfig(String host, int port, int timeout) {
        this.setClassName(TcpDelegatingCacheLoader.class.getName());
        this.host = host;
        this.port = port;
        this.timeout = timeout;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.testImmutability("host");
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.testImmutability("port");
        this.port = port;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.testImmutability("timeout");
        this.timeout = timeout;
    }

    public int getReconnectWaitTime() {
        return this.reconnectWaitTime;
    }

    public void setReconnectWaitTime(int reconnectWaitTime) {
        this.testImmutability("reconnectWaitTime");
        this.reconnectWaitTime = reconnectWaitTime;
    }

    public void setProperties(Properties props) {
        super.setProperties(props);
        String s = props.getProperty("host");
        if (s != null && s.length() > 0) {
            this.host = s;
        }
        if ((s = props.getProperty("port")) != null && s.length() > 0) {
            this.port = Integer.parseInt(s);
        }
        if ((s = props.getProperty("timeout")) != null && s.length() > 0) {
            this.timeout = Integer.parseInt(s);
        }
        if ((s = props.getProperty("reconnectWaitTime")) != null && s.length() > 0) {
            this.reconnectWaitTime = Integer.parseInt(s);
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof TcpDelegatingCacheLoaderConfig && this.equalsExcludingProperties(obj)) {
            TcpDelegatingCacheLoaderConfig other = (TcpDelegatingCacheLoaderConfig)obj;
            return Util.safeEquals(this.host, other.host) && this.port == other.port && this.timeout == other.timeout && this.reconnectWaitTime == other.reconnectWaitTime;
        }
        return false;
    }

    public int hashCode() {
        int result = this.hashCodeExcludingProperties();
        result = 31 * result + (this.host == null ? 0 : this.host.hashCode());
        result = 31 * result + this.port;
        result = 31 * result + this.timeout;
        result = 31 * result + this.reconnectWaitTime;
        return result;
    }

    public TcpDelegatingCacheLoaderConfig clone() throws CloneNotSupportedException {
        return (TcpDelegatingCacheLoaderConfig)super.clone();
    }
}

