/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.notifications;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.transaction.Transaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheException;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.buddyreplication.BuddyGroup;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.annotations.Destroy;
import org.jboss.cache.factories.annotations.Inject;
import org.jboss.cache.factories.annotations.NonVolatile;
import org.jboss.cache.factories.annotations.Start;
import org.jboss.cache.factories.annotations.Stop;
import org.jboss.cache.marshall.MarshalledValueMap;
import org.jboss.cache.notifications.IncorrectCacheListenerException;
import org.jboss.cache.notifications.Notifier;
import org.jboss.cache.notifications.annotation.BuddyGroupChanged;
import org.jboss.cache.notifications.annotation.CacheBlocked;
import org.jboss.cache.notifications.annotation.CacheListener;
import org.jboss.cache.notifications.annotation.CacheStarted;
import org.jboss.cache.notifications.annotation.CacheStopped;
import org.jboss.cache.notifications.annotation.CacheUnblocked;
import org.jboss.cache.notifications.annotation.NodeActivated;
import org.jboss.cache.notifications.annotation.NodeCreated;
import org.jboss.cache.notifications.annotation.NodeEvicted;
import org.jboss.cache.notifications.annotation.NodeLoaded;
import org.jboss.cache.notifications.annotation.NodeModified;
import org.jboss.cache.notifications.annotation.NodeMoved;
import org.jboss.cache.notifications.annotation.NodePassivated;
import org.jboss.cache.notifications.annotation.NodeRemoved;
import org.jboss.cache.notifications.annotation.NodeVisited;
import org.jboss.cache.notifications.annotation.TransactionCompleted;
import org.jboss.cache.notifications.annotation.TransactionRegistered;
import org.jboss.cache.notifications.annotation.ViewChanged;
import org.jboss.cache.notifications.event.BuddyGroupChangedEvent;
import org.jboss.cache.notifications.event.CacheBlockedEvent;
import org.jboss.cache.notifications.event.CacheStartedEvent;
import org.jboss.cache.notifications.event.CacheStoppedEvent;
import org.jboss.cache.notifications.event.CacheUnblockedEvent;
import org.jboss.cache.notifications.event.Event;
import org.jboss.cache.notifications.event.EventImpl;
import org.jboss.cache.notifications.event.NodeActivatedEvent;
import org.jboss.cache.notifications.event.NodeCreatedEvent;
import org.jboss.cache.notifications.event.NodeEvictedEvent;
import org.jboss.cache.notifications.event.NodeLoadedEvent;
import org.jboss.cache.notifications.event.NodeModifiedEvent;
import org.jboss.cache.notifications.event.NodeMovedEvent;
import org.jboss.cache.notifications.event.NodePassivatedEvent;
import org.jboss.cache.notifications.event.NodeRemovedEvent;
import org.jboss.cache.notifications.event.NodeVisitedEvent;
import org.jboss.cache.notifications.event.TransactionCompletedEvent;
import org.jboss.cache.notifications.event.TransactionRegisteredEvent;
import org.jboss.cache.notifications.event.ViewChangedEvent;
import org.jboss.cache.util.MapCopy;
import org.jgroups.View;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonVolatile
public class NotifierImpl
implements Notifier {
    private static final Log log = LogFactory.getLog(NotifierImpl.class);
    private static final Class emptyMap = Collections.emptyMap().getClass();
    private static final Class singletonMap = Collections.singletonMap(null, null).getClass();
    private static final Class[] allowedMethodAnnotations = new Class[]{CacheStarted.class, CacheStopped.class, CacheBlocked.class, CacheUnblocked.class, NodeCreated.class, NodeRemoved.class, NodeVisited.class, NodeModified.class, NodeMoved.class, NodeActivated.class, NodePassivated.class, NodeLoaded.class, NodeEvicted.class, TransactionRegistered.class, TransactionCompleted.class, ViewChanged.class, BuddyGroupChanged.class};
    private static final Class[] parameterTypes = new Class[]{CacheStartedEvent.class, CacheStoppedEvent.class, CacheBlockedEvent.class, CacheUnblockedEvent.class, NodeCreatedEvent.class, NodeRemovedEvent.class, NodeVisitedEvent.class, NodeModifiedEvent.class, NodeMovedEvent.class, NodeActivatedEvent.class, NodePassivatedEvent.class, NodeLoadedEvent.class, NodeEvictedEvent.class, TransactionRegisteredEvent.class, TransactionCompletedEvent.class, ViewChangedEvent.class, BuddyGroupChangedEvent.class};
    private final List<ListenerInvocation> cacheStartedListeners = new CopyOnWriteArrayList<ListenerInvocation>();
    private final List<ListenerInvocation> cacheStoppedListeners = new CopyOnWriteArrayList<ListenerInvocation>();
    private final List<ListenerInvocation> cacheBlockedListeners = new CopyOnWriteArrayList<ListenerInvocation>();
    private final List<ListenerInvocation> cacheUnblockedListeners = new CopyOnWriteArrayList<ListenerInvocation>();
    private final List<ListenerInvocation> nodeCreatedListeners = new CopyOnWriteArrayList<ListenerInvocation>();
    private final List<ListenerInvocation> nodeRemovedListeners = new CopyOnWriteArrayList<ListenerInvocation>();
    private final List<ListenerInvocation> nodeVisitedListeners = new CopyOnWriteArrayList<ListenerInvocation>();
    private final List<ListenerInvocation> nodeModifiedListeners = new CopyOnWriteArrayList<ListenerInvocation>();
    private final List<ListenerInvocation> nodeMovedListeners = new CopyOnWriteArrayList<ListenerInvocation>();
    private final List<ListenerInvocation> nodeActivatedListeners = new CopyOnWriteArrayList<ListenerInvocation>();
    private final List<ListenerInvocation> nodePassivatedListeners = new CopyOnWriteArrayList<ListenerInvocation>();
    private final List<ListenerInvocation> nodeLoadedListeners = new CopyOnWriteArrayList<ListenerInvocation>();
    private final List<ListenerInvocation> nodeEvictedListeners = new CopyOnWriteArrayList<ListenerInvocation>();
    private final List<ListenerInvocation> transactionRegisteredListeners = new CopyOnWriteArrayList<ListenerInvocation>();
    private final List<ListenerInvocation> transactionCompletedListeners = new CopyOnWriteArrayList<ListenerInvocation>();
    private final List<ListenerInvocation> viewChangedListeners = new CopyOnWriteArrayList<ListenerInvocation>();
    private final List<ListenerInvocation> buddyGroupChangedListeners = new CopyOnWriteArrayList<ListenerInvocation>();
    private Cache cache;
    private boolean useMarshalledValueMaps;
    private Configuration config;

    public NotifierImpl() {
    }

    public NotifierImpl(Cache cache) {
        this.cache = cache;
    }

    @Inject
    private void injectDependencies(CacheSPI cache, Configuration config) {
        this.cache = cache;
        this.config = config;
    }

    @Destroy
    protected void destroy() {
        this.removeAllCacheListeners();
    }

    @Start
    protected void start() {
        this.useMarshalledValueMaps = this.config.isUseLazyDeserialization();
    }

    private void validateAndAddListenerInvocation(Object listener) {
        NotifierImpl.testListenerClassValidity(listener.getClass());
        boolean foundMethods = false;
        for (Method m : listener.getClass().getMethods()) {
            for (int i = 0; i < allowedMethodAnnotations.length; ++i) {
                if (!m.isAnnotationPresent(allowedMethodAnnotations[i])) continue;
                NotifierImpl.testListenerMethodValidity(m, parameterTypes[i], allowedMethodAnnotations[i].getName());
                this.addListenerInvocation(allowedMethodAnnotations[i], new ListenerInvocation(listener, m));
                foundMethods = true;
            }
        }
        if (!foundMethods && log.isWarnEnabled()) {
            log.warn((Object)("Attempted to register listener of class " + listener.getClass() + ", but no valid, public methods annotated with method-level event annotations found! Ignoring listener."));
        }
    }

    private static void testListenerClassValidity(Class<?> listenerClass) {
        if (!listenerClass.isAnnotationPresent(CacheListener.class)) {
            throw new IncorrectCacheListenerException("Cache listener class MUST be annotated with org.jboss.cache.notifications.annotation.CacheListener");
        }
        if (!Modifier.isPublic(listenerClass.getModifiers())) {
            throw new IncorrectCacheListenerException("Cache listener class MUST be public!");
        }
    }

    private static void testListenerMethodValidity(Method m, Class allowedParameter, String annotationName) {
        if (m.getParameterTypes().length != 1 || !m.getParameterTypes()[0].isAssignableFrom(allowedParameter)) {
            throw new IncorrectCacheListenerException("Methods annotated with " + annotationName + " must accept exactly one parameter, of assignable from type " + allowedParameter.getName());
        }
        if (!m.getReturnType().equals(Void.TYPE)) {
            throw new IncorrectCacheListenerException("Methods annotated with " + annotationName + " should have a return type of void.");
        }
    }

    private void addListenerInvocation(Class annotation, ListenerInvocation li) {
        List<ListenerInvocation> result = this.getListenersForAnnotation(annotation);
        result.add(li);
    }

    @Override
    public void addCacheListener(Object listener) {
        this.validateAndAddListenerInvocation(listener);
    }

    @Override
    public void removeCacheListener(Object listener) {
        for (Class annotation : allowedMethodAnnotations) {
            this.removeListenerInvocation(annotation, listener);
        }
    }

    private void removeListenerInvocation(Class annotation, Object listener) {
        if (listener == null) {
            return;
        }
        List<ListenerInvocation> l = this.getListenersForAnnotation(annotation);
        HashSet<ListenerInvocation> markedForRemoval = new HashSet<ListenerInvocation>();
        for (ListenerInvocation li : l) {
            if (!listener.equals(li.target)) continue;
            markedForRemoval.add(li);
        }
        l.removeAll(markedForRemoval);
    }

    @Stop(priority=99)
    public void removeAllCacheListeners() {
        this.cacheStartedListeners.clear();
        this.cacheStoppedListeners.clear();
        this.cacheBlockedListeners.clear();
        this.cacheUnblockedListeners.clear();
        this.nodeCreatedListeners.clear();
        this.nodeRemovedListeners.clear();
        this.nodeVisitedListeners.clear();
        this.nodeModifiedListeners.clear();
        this.nodeMovedListeners.clear();
        this.nodeActivatedListeners.clear();
        this.nodePassivatedListeners.clear();
        this.nodeLoadedListeners.clear();
        this.nodeEvictedListeners.clear();
        this.transactionRegisteredListeners.clear();
        this.transactionCompletedListeners.clear();
        this.viewChangedListeners.clear();
        this.buddyGroupChangedListeners.clear();
    }

    @Override
    public Set<Object> getCacheListeners() {
        HashSet result = new HashSet();
        result.addAll(this.getListeningObjects(this.cacheStartedListeners));
        result.addAll(this.getListeningObjects(this.cacheStoppedListeners));
        result.addAll(this.getListeningObjects(this.cacheBlockedListeners));
        result.addAll(this.getListeningObjects(this.cacheUnblockedListeners));
        result.addAll(this.getListeningObjects(this.nodeCreatedListeners));
        result.addAll(this.getListeningObjects(this.nodeRemovedListeners));
        result.addAll(this.getListeningObjects(this.nodeVisitedListeners));
        result.addAll(this.getListeningObjects(this.nodeModifiedListeners));
        result.addAll(this.getListeningObjects(this.nodeMovedListeners));
        result.addAll(this.getListeningObjects(this.nodeActivatedListeners));
        result.addAll(this.getListeningObjects(this.nodePassivatedListeners));
        result.addAll(this.getListeningObjects(this.nodeLoadedListeners));
        result.addAll(this.getListeningObjects(this.nodeEvictedListeners));
        result.addAll(this.getListeningObjects(this.transactionRegisteredListeners));
        result.addAll(this.getListeningObjects(this.transactionCompletedListeners));
        result.addAll(this.getListeningObjects(this.viewChangedListeners));
        result.addAll(this.getListeningObjects(this.buddyGroupChangedListeners));
        return Collections.unmodifiableSet(result);
    }

    @Override
    public void notifyNodeCreated(Fqn fqn, boolean pre, InvocationContext ctx) {
        if (!this.nodeCreatedListeners.isEmpty()) {
            boolean originLocal = ctx.isOriginLocal();
            Transaction tx = ctx.getTransaction();
            InvocationContext backup = this.resetInvocationContext(ctx);
            EventImpl e = new EventImpl();
            e.setCache(this.cache);
            e.setOriginLocal(originLocal);
            e.setPre(pre);
            e.setFqn(fqn);
            e.setTransaction(tx);
            e.setType(Event.Type.NODE_CREATED);
            for (ListenerInvocation listener : this.nodeCreatedListeners) {
                listener.invoke(e);
            }
            this.restoreInvocationContext(backup);
        }
    }

    @Override
    public void notifyNodeModified(Fqn fqn, boolean pre, NodeModifiedEvent.ModificationType modificationType, Map data, InvocationContext ctx) {
        if (!this.nodeModifiedListeners.isEmpty()) {
            boolean originLocal = ctx.isOriginLocal();
            Map dataCopy = NotifierImpl.copy(data, this.useMarshalledValueMaps);
            Transaction tx = ctx.getTransaction();
            InvocationContext backup = this.resetInvocationContext(ctx);
            EventImpl e = new EventImpl();
            e.setCache(this.cache);
            e.setOriginLocal(originLocal);
            e.setPre(pre);
            e.setFqn(fqn);
            e.setTransaction(tx);
            e.setModificationType(modificationType);
            e.setData(dataCopy);
            e.setType(Event.Type.NODE_MODIFIED);
            for (ListenerInvocation listener : this.nodeModifiedListeners) {
                listener.invoke(e);
            }
            this.restoreInvocationContext(backup);
        }
    }

    @Override
    public boolean shouldNotifyOnNodeModified() {
        return !this.nodeModifiedListeners.isEmpty();
    }

    @Override
    public void notifyNodeRemoved(Fqn fqn, boolean pre, Map data, InvocationContext ctx) {
        if (!this.nodeRemovedListeners.isEmpty()) {
            boolean originLocal = ctx.isOriginLocal();
            Map dataCopy = NotifierImpl.copy(data, this.useMarshalledValueMaps);
            Transaction tx = ctx.getTransaction();
            InvocationContext backup = this.resetInvocationContext(ctx);
            EventImpl e = new EventImpl();
            e.setCache(this.cache);
            e.setOriginLocal(originLocal);
            e.setPre(pre);
            e.setFqn(fqn);
            e.setTransaction(tx);
            e.setData(dataCopy);
            e.setType(Event.Type.NODE_REMOVED);
            for (ListenerInvocation listener : this.nodeRemovedListeners) {
                listener.invoke(e);
            }
            this.restoreInvocationContext(backup);
        }
    }

    @Override
    public void notifyNodeVisited(Fqn fqn, boolean pre, InvocationContext ctx) {
        if (!this.nodeVisitedListeners.isEmpty()) {
            Transaction tx = ctx.getTransaction();
            InvocationContext backup = this.resetInvocationContext(ctx);
            EventImpl e = new EventImpl();
            e.setCache(this.cache);
            e.setPre(pre);
            e.setFqn(fqn);
            e.setTransaction(tx);
            e.setType(Event.Type.NODE_VISITED);
            for (ListenerInvocation listener : this.nodeVisitedListeners) {
                listener.invoke(e);
            }
            this.restoreInvocationContext(backup);
        }
    }

    @Override
    public void notifyNodeMoved(Fqn originalFqn, Fqn newFqn, boolean pre, InvocationContext ctx) {
        if (!this.nodeMovedListeners.isEmpty()) {
            boolean originLocal = ctx.isOriginLocal();
            Transaction tx = ctx.getTransaction();
            InvocationContext backup = this.resetInvocationContext(ctx);
            EventImpl e = new EventImpl();
            e.setCache(this.cache);
            e.setOriginLocal(originLocal);
            e.setPre(pre);
            e.setFqn(originalFqn);
            e.setTargetFqn(newFqn);
            e.setTransaction(tx);
            e.setType(Event.Type.NODE_MOVED);
            for (ListenerInvocation listener : this.nodeMovedListeners) {
                listener.invoke(e);
            }
            this.restoreInvocationContext(backup);
        }
    }

    @Override
    public void notifyNodeEvicted(Fqn fqn, boolean pre, InvocationContext ctx) {
        if (!this.nodeEvictedListeners.isEmpty()) {
            boolean originLocal = ctx.isOriginLocal();
            Transaction tx = ctx.getTransaction();
            InvocationContext backup = this.resetInvocationContext(ctx);
            EventImpl e = new EventImpl();
            e.setCache(this.cache);
            e.setOriginLocal(originLocal);
            e.setPre(pre);
            e.setFqn(fqn);
            e.setTransaction(tx);
            e.setType(Event.Type.NODE_EVICTED);
            for (ListenerInvocation listener : this.nodeEvictedListeners) {
                listener.invoke(e);
            }
            this.restoreInvocationContext(backup);
        }
    }

    @Override
    public void notifyNodeLoaded(Fqn fqn, boolean pre, Map data, InvocationContext ctx) {
        if (!this.nodeLoadedListeners.isEmpty()) {
            boolean originLocal = ctx.isOriginLocal();
            Map dataCopy = NotifierImpl.copy(data, this.useMarshalledValueMaps);
            Transaction tx = ctx.getTransaction();
            InvocationContext backup = this.resetInvocationContext(ctx);
            EventImpl e = new EventImpl();
            e.setCache(this.cache);
            e.setOriginLocal(originLocal);
            e.setPre(pre);
            e.setFqn(fqn);
            e.setTransaction(tx);
            e.setData(dataCopy);
            e.setType(Event.Type.NODE_LOADED);
            for (ListenerInvocation listener : this.nodeLoadedListeners) {
                listener.invoke(e);
            }
            this.restoreInvocationContext(backup);
        }
    }

    @Override
    public void notifyNodeActivated(Fqn fqn, boolean pre, Map data, InvocationContext ctx) {
        if (!this.nodeActivatedListeners.isEmpty()) {
            boolean originLocal = ctx.isOriginLocal();
            Map dataCopy = NotifierImpl.copy(data, this.useMarshalledValueMaps);
            Transaction tx = ctx.getTransaction();
            InvocationContext backup = this.resetInvocationContext(ctx);
            EventImpl e = new EventImpl();
            e.setCache(this.cache);
            e.setOriginLocal(originLocal);
            e.setPre(pre);
            e.setFqn(fqn);
            e.setTransaction(tx);
            e.setData(dataCopy);
            e.setType(Event.Type.NODE_ACTIVATED);
            for (ListenerInvocation listener : this.nodeActivatedListeners) {
                listener.invoke(e);
            }
            this.restoreInvocationContext(backup);
        }
    }

    @Override
    public void notifyNodePassivated(Fqn fqn, boolean pre, Map data, InvocationContext ctx) {
        if (!this.nodePassivatedListeners.isEmpty()) {
            Map dataCopy = NotifierImpl.copy(data, this.useMarshalledValueMaps);
            Transaction tx = ctx.getTransaction();
            InvocationContext backup = this.resetInvocationContext(ctx);
            EventImpl e = new EventImpl();
            e.setCache(this.cache);
            e.setPre(pre);
            e.setFqn(fqn);
            e.setTransaction(tx);
            e.setData(dataCopy);
            e.setType(Event.Type.NODE_PASSIVATED);
            for (ListenerInvocation listener : this.nodePassivatedListeners) {
                listener.invoke(e);
            }
            this.restoreInvocationContext(backup);
        }
    }

    @Start(priority=99)
    public void notifyCacheStarted() {
        if (!this.cacheStartedListeners.isEmpty()) {
            EventImpl e = new EventImpl();
            e.setCache(this.cache);
            e.setType(Event.Type.CACHE_STARTED);
            for (ListenerInvocation listener : this.cacheStartedListeners) {
                listener.invoke(e);
            }
        }
    }

    @Stop(priority=98)
    public void notifyCacheStopped() {
        if (!this.cacheStoppedListeners.isEmpty()) {
            EventImpl e = new EventImpl();
            e.setCache(this.cache);
            e.setType(Event.Type.CACHE_STOPPED);
            for (ListenerInvocation listener : this.cacheStoppedListeners) {
                listener.invoke(e);
            }
        }
    }

    @Override
    public void notifyViewChange(View newView, InvocationContext ctx) {
        if (!this.viewChangedListeners.isEmpty()) {
            InvocationContext backup = this.resetInvocationContext(ctx);
            EventImpl e = new EventImpl();
            e.setCache(this.cache);
            e.setNewView(newView);
            e.setType(Event.Type.VIEW_CHANGED);
            for (ListenerInvocation listener : this.viewChangedListeners) {
                listener.invoke(e);
            }
            this.restoreInvocationContext(backup);
        }
    }

    @Override
    public void notifyBuddyGroupChange(BuddyGroup buddyGroup, boolean pre) {
        if (!this.buddyGroupChangedListeners.isEmpty()) {
            EventImpl e = new EventImpl();
            e.setCache(this.cache);
            e.setBuddyGroup(buddyGroup);
            e.setPre(pre);
            e.setType(Event.Type.BUDDY_GROUP_CHANGED);
            for (ListenerInvocation listener : this.buddyGroupChangedListeners) {
                listener.invoke(e);
            }
        }
    }

    @Override
    public void notifyTransactionCompleted(Transaction transaction, boolean successful, InvocationContext ctx) {
        if (!this.transactionCompletedListeners.isEmpty()) {
            boolean isOriginLocal = ctx.isOriginLocal();
            InvocationContext backup = this.resetInvocationContext(ctx);
            EventImpl e = new EventImpl();
            e.setCache(this.cache);
            e.setOriginLocal(isOriginLocal);
            e.setTransaction(transaction);
            e.setSuccessful(successful);
            e.setType(Event.Type.TRANSACTION_COMPLETED);
            for (ListenerInvocation listener : this.transactionCompletedListeners) {
                listener.invoke(e);
            }
            this.restoreInvocationContext(backup);
        }
    }

    @Override
    public void notifyTransactionRegistered(Transaction transaction, InvocationContext ctx) {
        if (!this.transactionRegisteredListeners.isEmpty()) {
            boolean isOriginLocal = ctx.isOriginLocal();
            InvocationContext backup = this.resetInvocationContext(ctx);
            EventImpl e = new EventImpl();
            e.setCache(this.cache);
            e.setOriginLocal(isOriginLocal);
            e.setTransaction(transaction);
            e.setType(Event.Type.TRANSACTION_REGISTERED);
            for (ListenerInvocation listener : this.transactionRegisteredListeners) {
                listener.invoke(e);
            }
            this.restoreInvocationContext(backup);
        }
    }

    @Override
    public void notifyCacheBlocked(boolean pre) {
        if (!this.cacheBlockedListeners.isEmpty()) {
            EventImpl e = new EventImpl();
            e.setCache(this.cache);
            e.setPre(pre);
            e.setType(Event.Type.CACHE_BLOCKED);
            for (ListenerInvocation listener : this.cacheBlockedListeners) {
                listener.invoke(e);
            }
        }
    }

    @Override
    public void notifyCacheUnblocked(boolean pre) {
        if (!this.cacheUnblockedListeners.isEmpty()) {
            EventImpl e = new EventImpl();
            e.setCache(this.cache);
            e.setPre(pre);
            e.setType(Event.Type.CACHE_UNBLOCKED);
            for (ListenerInvocation listener : this.cacheUnblockedListeners) {
                listener.invoke(e);
            }
        }
    }

    private static Map copy(Map data, boolean useMarshalledValueMaps) {
        if (data == null) {
            return null;
        }
        if (data.isEmpty()) {
            return Collections.emptyMap();
        }
        if (NotifierImpl.safe(data)) {
            return useMarshalledValueMaps ? new MarshalledValueMap(data) : data;
        }
        MapCopy defensivelyCopiedData = new MapCopy(data);
        return useMarshalledValueMaps ? new MarshalledValueMap(defensivelyCopiedData) : defensivelyCopiedData;
    }

    private void restoreInvocationContext(InvocationContext backup) {
        this.cache.setInvocationContext(backup);
    }

    private InvocationContext resetInvocationContext(InvocationContext ctx) {
        this.cache.setInvocationContext(null);
        return ctx;
    }

    private static boolean safe(Map map) {
        return map == null || map instanceof MapCopy || map.getClass().equals(emptyMap) || map.getClass().equals(singletonMap);
    }

    private List<ListenerInvocation> getListenersForAnnotation(Class annotation) {
        if (annotation == CacheStarted.class) {
            return this.cacheStartedListeners;
        }
        if (annotation == CacheStopped.class) {
            return this.cacheStoppedListeners;
        }
        if (annotation == CacheBlocked.class) {
            return this.cacheBlockedListeners;
        }
        if (annotation == CacheUnblocked.class) {
            return this.cacheUnblockedListeners;
        }
        if (annotation == NodeCreated.class) {
            return this.nodeCreatedListeners;
        }
        if (annotation == NodeRemoved.class) {
            return this.nodeRemovedListeners;
        }
        if (annotation == NodeVisited.class) {
            return this.nodeVisitedListeners;
        }
        if (annotation == NodeModified.class) {
            return this.nodeModifiedListeners;
        }
        if (annotation == NodeMoved.class) {
            return this.nodeMovedListeners;
        }
        if (annotation == NodeActivated.class) {
            return this.nodeActivatedListeners;
        }
        if (annotation == NodePassivated.class) {
            return this.nodePassivatedListeners;
        }
        if (annotation == NodeLoaded.class) {
            return this.nodeLoadedListeners;
        }
        if (annotation == NodeEvicted.class) {
            return this.nodeEvictedListeners;
        }
        if (annotation == TransactionRegistered.class) {
            return this.transactionRegisteredListeners;
        }
        if (annotation == TransactionCompleted.class) {
            return this.transactionCompletedListeners;
        }
        if (annotation == ViewChanged.class) {
            return this.viewChangedListeners;
        }
        if (annotation == BuddyGroupChanged.class) {
            return this.buddyGroupChangedListeners;
        }
        throw new RuntimeException("Unknown listener class: " + annotation);
    }

    private Collection getListeningObjects(List<ListenerInvocation> cacheStartedListeners) {
        HashSet<Object> result = new HashSet<Object>();
        for (ListenerInvocation li : cacheStartedListeners) {
            result.add(li.target);
        }
        return result;
    }

    public List<ListenerInvocation> getCacheStartedListeners() {
        return this.cacheStartedListeners;
    }

    public List<ListenerInvocation> getCacheStoppedListeners() {
        return this.cacheStoppedListeners;
    }

    public List<ListenerInvocation> getCacheBlockedListeners() {
        return this.cacheBlockedListeners;
    }

    public List<ListenerInvocation> getCacheUnblockedListeners() {
        return this.cacheUnblockedListeners;
    }

    public List<ListenerInvocation> getNodeCreatedListeners() {
        return this.nodeCreatedListeners;
    }

    public List<ListenerInvocation> getNodeRemovedListeners() {
        return this.nodeRemovedListeners;
    }

    public List<ListenerInvocation> getNodeVisitedListeners() {
        return this.nodeVisitedListeners;
    }

    public List<ListenerInvocation> getNodeModifiedListeners() {
        return this.nodeModifiedListeners;
    }

    public List<ListenerInvocation> getNodeMovedListeners() {
        return this.nodeMovedListeners;
    }

    public List<ListenerInvocation> getNodeActivatedListeners() {
        return this.nodeActivatedListeners;
    }

    public List<ListenerInvocation> getNodePassivatedListeners() {
        return this.nodePassivatedListeners;
    }

    public List<ListenerInvocation> getNodeLoadedListeners() {
        return this.nodeLoadedListeners;
    }

    public List<ListenerInvocation> getNodeEvictedListeners() {
        return this.nodeEvictedListeners;
    }

    public List<ListenerInvocation> getTransactionRegisteredListeners() {
        return this.transactionRegisteredListeners;
    }

    public List<ListenerInvocation> getTransactionCompletedListeners() {
        return this.transactionCompletedListeners;
    }

    public List<ListenerInvocation> getViewChangedListeners() {
        return this.viewChangedListeners;
    }

    public List<ListenerInvocation> getBuddyGroupChangedListeners() {
        return this.buddyGroupChangedListeners;
    }

    class ListenerInvocation {
        private final Object target;
        private final Method method;

        public ListenerInvocation(Object target, Method method) {
            this.target = target;
            this.method = method;
        }

        public void invoke(Event e) {
            try {
                this.method.invoke(this.target, e);
            }
            catch (InvocationTargetException e1) {
                Throwable cause = e1.getCause();
                if (cause != null) {
                    throw new CacheException("Caught exception invoking method " + this.method + " on listener instance " + this.target, cause);
                }
                throw new CacheException("Caught exception invoking method " + this.method + " on listener instance " + this.target, e1);
            }
            catch (IllegalAccessException e1) {
                log.warn((Object)("Unable to invoke method " + this.method + " on Object instance " + this.target + " - removing this target object from list of listeners!"), (Throwable)e1);
                NotifierImpl.this.removeCacheListener(this.target);
            }
        }
    }
}

