/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.repository;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.jboss.as.repository.DeploymentRepositoryLogger;
import org.jboss.as.repository.DeploymentRepositoryMessages;
import org.jboss.as.repository.HashUtil;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;

public interface ContentRepository {
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"content-repository"});

    public byte[] addContent(InputStream var1) throws IOException;

    public VirtualFile getContent(byte[] var1);

    public boolean hasContent(byte[] var1);

    public void removeContent(byte[] var1);

    public static class Factory {
        public static void addService(ServiceTarget serviceTarget, File repoRoot) {
            ContentRepositoryImpl contentRepository = new ContentRepositoryImpl(repoRoot);
            serviceTarget.addService(SERVICE_NAME, (Service)contentRepository).install();
        }

        public static ContentRepository create(File repoRoot) {
            return new ContentRepositoryImpl(repoRoot);
        }

        private static class ContentRepositoryImpl
        implements ContentRepository,
        Service<ContentRepository> {
            protected static final String CONTENT = "content";
            private final File repoRoot;
            protected final MessageDigest messageDigest;

            protected ContentRepositoryImpl(File repoRoot) {
                if (repoRoot == null) {
                    throw DeploymentRepositoryMessages.MESSAGES.nullVar("repoRoot");
                }
                if (repoRoot.exists()) {
                    if (!repoRoot.isDirectory()) {
                        throw DeploymentRepositoryMessages.MESSAGES.notADirectory(repoRoot.getAbsolutePath());
                    }
                    if (!repoRoot.canWrite()) {
                        throw DeploymentRepositoryMessages.MESSAGES.directoryNotWritable(repoRoot.getAbsolutePath());
                    }
                } else if (!repoRoot.mkdirs()) {
                    throw DeploymentRepositoryMessages.MESSAGES.cannotCreateDirectory(repoRoot.getAbsolutePath());
                }
                this.repoRoot = repoRoot;
                try {
                    this.messageDigest = MessageDigest.getInstance("SHA-1");
                }
                catch (NoSuchAlgorithmException e) {
                    throw DeploymentRepositoryMessages.MESSAGES.cannotObtainSha1(e, MessageDigest.class.getSimpleName());
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public byte[] addContent(InputStream stream) throws IOException {
                byte[] sha1Bytes;
                File tmp = File.createTempFile(CONTENT, "tmp", this.repoRoot);
                FileOutputStream fos = new FileOutputStream(tmp);
                MessageDigest messageDigest = this.messageDigest;
                synchronized (messageDigest) {
                    this.messageDigest.reset();
                    try {
                        int read;
                        DigestOutputStream dos = new DigestOutputStream(fos, this.messageDigest);
                        BufferedInputStream bis = new BufferedInputStream(stream);
                        byte[] bytes = new byte[8192];
                        while ((read = bis.read(bytes)) > -1) {
                            dos.write(bytes, 0, read);
                        }
                        fos.flush();
                        fos.getFD().sync();
                        fos.close();
                        fos = null;
                    }
                    finally {
                        ContentRepositoryImpl.safeClose(fos);
                    }
                    sha1Bytes = this.messageDigest.digest();
                }
                File realFile = this.getDeploymentContentFile(sha1Bytes, true);
                if (this.hasContent(sha1Bytes)) {
                    if (!tmp.delete()) {
                        tmp.deleteOnExit();
                    }
                    DeploymentRepositoryLogger.ROOT_LOGGER.debugf("Content was already present in repository at location %s", realFile.getAbsolutePath());
                } else {
                    this.moveTempToPermanent(tmp, realFile);
                    DeploymentRepositoryLogger.ROOT_LOGGER.contentAdded(realFile.getAbsolutePath());
                }
                return sha1Bytes;
            }

            @Override
            public VirtualFile getContent(byte[] hash) {
                if (hash == null) {
                    throw DeploymentRepositoryMessages.MESSAGES.nullVar("hash");
                }
                return VFS.getChild((URI)this.getDeploymentContentFile(hash, true).toURI());
            }

            @Override
            public boolean hasContent(byte[] hash) {
                return this.getDeploymentContentFile(hash).exists();
            }

            protected File getRepoRoot() {
                return this.repoRoot;
            }

            protected File getDeploymentContentFile(byte[] deploymentHash) {
                return this.getDeploymentContentFile(deploymentHash, false);
            }

            private File getDeploymentContentFile(byte[] deploymentHash, boolean validate) {
                File hashDir = this.getDeploymentHashDir(deploymentHash, validate);
                return new File(hashDir, CONTENT);
            }

            protected File getDeploymentHashDir(byte[] deploymentHash, boolean validate) {
                String sha1 = HashUtil.bytesToHexString(deploymentHash);
                String partA = sha1.substring(0, 2);
                String partB = sha1.substring(2);
                File base = new File(this.getRepoRoot(), partA);
                if (validate) {
                    this.validateDir(base);
                }
                File hashDir = new File(base, partB);
                if (validate && !hashDir.exists() && !hashDir.mkdirs()) {
                    throw DeploymentRepositoryMessages.MESSAGES.cannotCreateDirectory(hashDir.getAbsolutePath());
                }
                return hashDir;
            }

            protected void validateDir(File dir) {
                if (!dir.exists()) {
                    if (!dir.mkdirs()) {
                        throw DeploymentRepositoryMessages.MESSAGES.cannotCreateDirectory(dir.getAbsolutePath());
                    }
                } else {
                    if (!dir.isDirectory()) {
                        throw DeploymentRepositoryMessages.MESSAGES.notADirectory(dir.getAbsolutePath());
                    }
                    if (!dir.canWrite()) {
                        throw DeploymentRepositoryMessages.MESSAGES.directoryNotWritable(dir.getAbsolutePath());
                    }
                }
            }

            private void moveTempToPermanent(File tmpFile, File permanentFile) throws IOException {
                if (!tmpFile.renameTo(permanentFile)) {
                    File localTmp = new File(permanentFile.getParent(), "tmp");
                    try {
                        this.copyFile(tmpFile, localTmp);
                        if (!localTmp.renameTo(permanentFile)) {
                            this.copyFile(localTmp, permanentFile);
                        }
                    }
                    catch (IOException e) {
                        if (permanentFile.exists()) {
                            permanentFile.delete();
                        }
                        throw e;
                    }
                    catch (RuntimeException e) {
                        if (permanentFile.exists()) {
                            permanentFile.delete();
                        }
                        throw e;
                    }
                    finally {
                        if (!tmpFile.delete()) {
                            tmpFile.deleteOnExit();
                        }
                        if (localTmp.exists() && !localTmp.delete()) {
                            localTmp.deleteOnExit();
                        }
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void copyFile(File src, File dest) throws IOException {
                FileOutputStream fos = null;
                FileInputStream fis = null;
                try {
                    int read;
                    fos = new FileOutputStream(dest);
                    fis = new FileInputStream(src);
                    byte[] bytes = new byte[8192];
                    while ((read = fis.read(bytes)) > -1) {
                        fos.write(bytes, 0, read);
                    }
                    fos.flush();
                    fos.getFD().sync();
                    fos.close();
                    fos = null;
                }
                catch (Throwable throwable) {
                    ContentRepositoryImpl.safeClose(fos);
                    ContentRepositoryImpl.safeClose(fis);
                    throw throwable;
                }
                ContentRepositoryImpl.safeClose(fos);
                ContentRepositoryImpl.safeClose(fis);
            }

            @Override
            public void removeContent(byte[] hash) {
                File parent;
                File file = this.getDeploymentContentFile(hash, true);
                if (!file.delete()) {
                    file.deleteOnExit();
                }
                if (!(parent = file.getParentFile()).delete()) {
                    parent.deleteOnExit();
                }
                if ((parent = parent.getParentFile()).list().length == 0 && !parent.delete()) {
                    parent.deleteOnExit();
                }
                DeploymentRepositoryLogger.ROOT_LOGGER.contentRemoved(file.getAbsolutePath());
            }

            protected static void safeClose(Closeable closeable) {
                if (closeable != null) {
                    try {
                        closeable.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }

            public void start(StartContext context) throws StartException {
                DeploymentRepositoryLogger.ROOT_LOGGER.debugf("%s started", ContentRepository.class.getSimpleName());
            }

            public void stop(StopContext context) {
                DeploymentRepositoryLogger.ROOT_LOGGER.debugf("%s stopped", ContentRepository.class.getSimpleName());
            }

            public ContentRepository getValue() throws IllegalStateException, IllegalArgumentException {
                return this;
            }
        }
    }
}

