/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core;

import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ItemDefinition;
import javax.jcr.nodetype.NodeDefinition;
import org.apache.jackrabbit.core.ItemData;
import org.apache.jackrabbit.core.ItemId;
import org.apache.jackrabbit.core.ItemManager;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.state.NodeState;

public abstract class AbstractNodeData
extends ItemData {
    private NodeId primaryParentId;

    protected AbstractNodeData(NodeState state, ItemManager itemMgr) {
        super(state, itemMgr);
        if (state.isShareable()) {
            this.primaryParentId = state.getParentId();
        }
    }

    protected AbstractNodeData(ItemId id) {
        super(id);
    }

    public NodeState getNodeState() {
        return (NodeState)this.getState();
    }

    public NodeDefinition getNodeDefinition() throws RepositoryException {
        return (NodeDefinition)this.getDefinition();
    }

    public void setNodeDefinition(NodeDefinition definition) {
        this.setDefinition((ItemDefinition)definition);
    }

    public NodeId getParentId() {
        if (this.primaryParentId != null) {
            return this.primaryParentId;
        }
        return this.getState().getParentId();
    }

    public NodeId getPrimaryParentId() {
        return this.primaryParentId;
    }

    protected void setPrimaryParentId(NodeId primaryParentId) {
        this.primaryParentId = primaryParentId;
    }

    public boolean isNode() {
        return true;
    }
}

