/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core;

import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ItemDefinition;
import org.apache.jackrabbit.core.ItemId;
import org.apache.jackrabbit.core.ItemManager;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.state.ItemState;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.PropertyState;

public abstract class ItemData {
    private final ItemId id;
    private ItemState state;
    private ItemDefinition definition;
    private int status;
    private ItemManager itemMgr;

    protected ItemData(ItemState state, ItemManager itemMgr) {
        this.id = state.getId();
        this.state = state;
        this.status = 0;
        this.itemMgr = itemMgr;
    }

    protected ItemData(ItemId id) {
        this.id = id;
        this.status = 0;
    }

    public ItemState getState() {
        return this.state;
    }

    protected void setState(ItemState state) {
        this.state = state;
    }

    public ItemDefinition getDefinition() throws RepositoryException {
        if (this.definition == null && this.itemMgr != null) {
            this.definition = this.isNode() ? this.itemMgr.getDefinition((NodeState)this.state) : this.itemMgr.getDefinition((PropertyState)this.state);
        }
        return this.definition;
    }

    protected void setDefinition(ItemDefinition definition) {
        this.definition = definition;
    }

    public int getStatus() {
        return this.status;
    }

    protected void setStatus(int status) {
        this.status = status;
    }

    public boolean isNode() {
        return false;
    }

    public ItemId getId() {
        return this.id;
    }

    public NodeId getParentId() {
        return this.getState().getParentId();
    }

    public String toString() {
        return this.getId().toString();
    }
}

