/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.data.db;

import java.io.EOFException;
import java.io.IOException;
import java.sql.ResultSet;
import org.apache.commons.io.input.AutoCloseInputStream;
import org.apache.jackrabbit.core.data.DataIdentifier;
import org.apache.jackrabbit.core.data.DataStoreException;
import org.apache.jackrabbit.core.data.db.DatabaseHelper;
import org.apache.jackrabbit.core.data.db.DbDataStore;
import org.apache.jackrabbit.core.persistence.bundle.util.ConnectionRecoveryManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbInputStream
extends AutoCloseInputStream {
    private static Logger log = LoggerFactory.getLogger((Class)DbInputStream.class);
    protected DbDataStore store;
    protected DataIdentifier identifier;
    protected boolean endOfStream;
    protected ConnectionRecoveryManager conn;
    protected ResultSet rs;

    protected DbInputStream(DbDataStore store, DataIdentifier identifier) {
        super(null);
        this.store = store;
        this.identifier = identifier;
    }

    protected void openStream() throws IOException {
        if (this.endOfStream) {
            throw new EOFException();
        }
        if (this.in == null) {
            try {
                this.in = this.store.openStream(this, this.identifier);
            }
            catch (DataStoreException e) {
                IOException e2 = new IOException(e.getMessage());
                e2.initCause((Throwable)((Object)e));
                throw e2;
            }
        }
    }

    public int read() throws IOException {
        if (this.endOfStream) {
            return -1;
        }
        this.openStream();
        int c = this.in.read();
        if (c == -1) {
            this.endOfStream = true;
            this.close();
        }
        return c;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.endOfStream) {
            return -1;
        }
        this.openStream();
        int c = this.in.read(b, off, len);
        if (c == -1) {
            this.endOfStream = true;
            this.close();
        }
        return c;
    }

    public void close() throws IOException {
        if (this.in != null) {
            this.in.close();
            this.in = null;
            if (this.rs != null) {
                DatabaseHelper.closeSilently(this.rs);
                this.rs = null;
            }
            if (this.conn != null) {
                try {
                    this.store.putBack(this.conn);
                }
                catch (DataStoreException e) {
                    log.info("Error closing DbResource", (Throwable)((Object)e));
                }
            }
        }
    }

    public long skip(long n) throws IOException {
        if (this.endOfStream) {
            return -1L;
        }
        this.openStream();
        return this.in.skip(n);
    }

    public int available() throws IOException {
        if (this.endOfStream) {
            return 0;
        }
        this.openStream();
        return this.in.available();
    }

    public void mark(int readlimit) {
        if (this.endOfStream) {
            return;
        }
        try {
            this.openStream();
        }
        catch (IOException e) {
            log.info("Error getting underlying stream: ", (Throwable)e);
        }
        this.in.mark(readlimit);
    }

    public void reset() throws IOException {
        if (this.endOfStream) {
            throw new EOFException();
        }
        this.openStream();
        this.in.reset();
    }

    public boolean markSupported() {
        if (this.endOfStream) {
            return false;
        }
        try {
            this.openStream();
        }
        catch (IOException e) {
            log.info("Error getting underlying stream: ", (Throwable)e);
            return false;
        }
        return this.in.markSupported();
    }

    void setConnection(ConnectionRecoveryManager conn) {
        this.conn = conn;
    }

    void setResultSet(ResultSet rs) {
        this.rs = rs;
    }
}

