/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.nodetype;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.jcr.NamespaceException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.ValueFormatException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.nodetype.PropertyDefinition;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.jackrabbit.api.JackrabbitNodeTypeManager;
import org.apache.jackrabbit.api.jsr283.nodetype.InvalidNodeTypeDefinitionException;
import org.apache.jackrabbit.api.jsr283.nodetype.NodeDefinitionTemplate;
import org.apache.jackrabbit.api.jsr283.nodetype.NodeTypeDefinition;
import org.apache.jackrabbit.api.jsr283.nodetype.NodeTypeExistsException;
import org.apache.jackrabbit.api.jsr283.nodetype.NodeTypeTemplate;
import org.apache.jackrabbit.api.jsr283.nodetype.PropertyDefinitionTemplate;
import org.apache.jackrabbit.commons.NamespaceHelper;
import org.apache.jackrabbit.commons.iterator.NodeTypeIteratorAdapter;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.data.DataStore;
import org.apache.jackrabbit.core.nodetype.EffectiveNodeType;
import org.apache.jackrabbit.core.nodetype.InvalidConstraintException;
import org.apache.jackrabbit.core.nodetype.InvalidNodeTypeDefException;
import org.apache.jackrabbit.core.nodetype.ItemDef;
import org.apache.jackrabbit.core.nodetype.NodeDef;
import org.apache.jackrabbit.core.nodetype.NodeDefImpl;
import org.apache.jackrabbit.core.nodetype.NodeDefinitionImpl;
import org.apache.jackrabbit.core.nodetype.NodeDefinitionTemplateImpl;
import org.apache.jackrabbit.core.nodetype.NodeTypeDef;
import org.apache.jackrabbit.core.nodetype.NodeTypeImpl;
import org.apache.jackrabbit.core.nodetype.NodeTypeRegistry;
import org.apache.jackrabbit.core.nodetype.NodeTypeRegistryListener;
import org.apache.jackrabbit.core.nodetype.NodeTypeTemplateImpl;
import org.apache.jackrabbit.core.nodetype.PropDef;
import org.apache.jackrabbit.core.nodetype.PropDefImpl;
import org.apache.jackrabbit.core.nodetype.PropertyDefinitionImpl;
import org.apache.jackrabbit.core.nodetype.PropertyDefinitionTemplateImpl;
import org.apache.jackrabbit.core.nodetype.ValueConstraint;
import org.apache.jackrabbit.core.nodetype.compact.CompactNodeTypeDefReader;
import org.apache.jackrabbit.core.nodetype.compact.ParseException;
import org.apache.jackrabbit.core.nodetype.xml.NodeTypeReader;
import org.apache.jackrabbit.core.util.Dumpable;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.conversion.NameException;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceMapping;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class NodeTypeManagerImpl
implements JackrabbitNodeTypeManager,
Dumpable,
NodeTypeRegistryListener {
    private final NodeTypeRegistry ntReg;
    private final SessionImpl session;
    private final ValueFactory valueFactory;
    private final NodeDefinitionImpl rootNodeDef;
    private final Map ntCache;
    private final Map pdCache;
    private final Map ndCache;
    private final DataStore store;
    private static final String APPLICATION_XML = "application/xml";

    public NodeTypeManagerImpl(NodeTypeRegistry ntReg, SessionImpl session, DataStore store) throws RepositoryException {
        this.ntReg = ntReg;
        this.session = session;
        this.valueFactory = session.getValueFactory();
        this.ntReg.addListener(this);
        this.store = store;
        this.ntCache = new ReferenceMap(0, 1);
        this.pdCache = new ReferenceMap(0, 1);
        this.ndCache = new ReferenceMap(0, 1);
        this.rootNodeDef = new NodeDefinitionImpl(ntReg.getRootNodeDef(), this, (NamePathResolver)session);
        this.ndCache.put(this.rootNodeDef.unwrap(), this.rootNodeDef);
    }

    public NodeDefinitionImpl getRootNodeDefinition() {
        return this.rootNodeDef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeDefinitionImpl getNodeDefinition(NodeDef def) {
        Map map = this.ndCache;
        synchronized (map) {
            NodeDefinitionImpl ndi = (NodeDefinitionImpl)this.ndCache.get(def);
            if (ndi == null) {
                ndi = new NodeDefinitionImpl(def, this, (NamePathResolver)this.session);
                this.ndCache.put(def, ndi);
            }
            return ndi;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertyDefinitionImpl getPropertyDefinition(PropDef def) {
        Map map = this.pdCache;
        synchronized (map) {
            PropertyDefinitionImpl pdi = (PropertyDefinitionImpl)this.pdCache.get(def);
            if (pdi == null) {
                pdi = new PropertyDefinitionImpl(def, this, (NamePathResolver)this.session);
                this.pdCache.put(def, pdi);
            }
            return pdi;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeTypeImpl getNodeType(Name name) throws NoSuchNodeTypeException {
        Map map = this.ntCache;
        synchronized (map) {
            NodeTypeImpl nt = (NodeTypeImpl)this.ntCache.get(name);
            if (nt == null) {
                EffectiveNodeType ent = this.ntReg.getEffectiveNodeType(name);
                NodeTypeDef def = this.ntReg.getNodeTypeDef(name);
                nt = new NodeTypeImpl(ent, def, this, this.session, this.valueFactory, this.store);
                this.ntCache.put(name, nt);
            }
            return nt;
        }
    }

    public NodeTypeRegistry getNodeTypeRegistry() {
        return this.ntReg;
    }

    public NodeType[] registerNodeTypes(InputStream in, String contentType, boolean reregisterExisting) throws IOException, RepositoryException {
        try {
            HashMap<String, String> namespaceMap = new HashMap<String, String>();
            ArrayList<NodeTypeDef> nodeTypeDefs = new ArrayList<NodeTypeDef>();
            if (contentType.equalsIgnoreCase("text/xml") || contentType.equalsIgnoreCase(APPLICATION_XML)) {
                try {
                    NodeTypeReader ntr = new NodeTypeReader(in);
                    Properties namespaces = ntr.getNamespaces();
                    if (namespaces != null) {
                        Enumeration<?> prefixes = namespaces.propertyNames();
                        while (prefixes.hasMoreElements()) {
                            String prefix = (String)prefixes.nextElement();
                            String uri = namespaces.getProperty(prefix);
                            namespaceMap.put(prefix, uri);
                        }
                    }
                    NodeTypeDef[] defs = ntr.getNodeTypeDefs();
                    nodeTypeDefs.addAll(Arrays.asList(defs));
                }
                catch (NameException e) {
                    throw new RepositoryException("Illegal JCR name", (Throwable)e);
                }
            } else if (contentType.equalsIgnoreCase("text/x-jcr-cnd")) {
                try {
                    NamespaceMapping mapping = new NamespaceMapping((NamespaceResolver)this.session);
                    CompactNodeTypeDefReader reader = new CompactNodeTypeDefReader(new InputStreamReader(in), "cnd input stream", mapping);
                    namespaceMap.putAll(mapping.getPrefixToURIMapping());
                    nodeTypeDefs.addAll(reader.getNodeTypeDefs());
                }
                catch (ParseException e) {
                    IOException e2 = new IOException(e.getMessage());
                    e2.initCause(e);
                    throw e2;
                }
            } else {
                throw new UnsupportedRepositoryOperationException("Unsupported content type: " + contentType);
            }
            new NamespaceHelper((Session)this.session).registerNamespaces(namespaceMap);
            if (reregisterExisting) {
                ArrayList<NodeTypeDef> newNodeTypeDefs = new ArrayList<NodeTypeDef>();
                ArrayList<NodeTypeDef> registeredNodeTypeDefs = new ArrayList<NodeTypeDef>();
                Iterator iter = nodeTypeDefs.iterator();
                while (iter.hasNext()) {
                    NodeTypeDef nodeTypeDef = (NodeTypeDef)iter.next();
                    if (this.ntReg.isRegistered(nodeTypeDef.getName())) {
                        registeredNodeTypeDefs.add(nodeTypeDef);
                        continue;
                    }
                    newNodeTypeDefs.add(nodeTypeDef);
                }
                ArrayList<NodeTypeImpl> nodeTypes = new ArrayList<NodeTypeImpl>();
                nodeTypes.addAll(this.registerNodeTypes(newNodeTypeDefs));
                Iterator iter2 = registeredNodeTypeDefs.iterator();
                while (iter2.hasNext()) {
                    NodeTypeDef nodeTypeDef = (NodeTypeDef)iter2.next();
                    this.ntReg.reregisterNodeType(nodeTypeDef);
                    nodeTypes.add(this.getNodeType(nodeTypeDef.getName()));
                }
                return nodeTypes.toArray(new NodeType[nodeTypes.size()]);
            }
            Collection types = this.registerNodeTypes(nodeTypeDefs);
            return types.toArray(new NodeType[types.size()]);
        }
        catch (InvalidNodeTypeDefException e) {
            throw new RepositoryException("Invalid node type definition", (Throwable)e);
        }
    }

    public void nodeTypeRegistered(Name ntName) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nodeTypeReRegistered(Name ntName) {
        Iterator iter;
        this.ntCache.remove(ntName);
        Map map = this.pdCache;
        synchronized (map) {
            iter = this.pdCache.values().iterator();
            while (iter.hasNext()) {
                PropertyDefinitionImpl pd = (PropertyDefinitionImpl)iter.next();
                if (!ntName.equals(pd.unwrap().getDeclaringNodeType())) continue;
                iter.remove();
            }
        }
        map = this.ndCache;
        synchronized (map) {
            iter = this.ndCache.values().iterator();
            while (iter.hasNext()) {
                NodeDefinitionImpl nd = (NodeDefinitionImpl)iter.next();
                if (!ntName.equals(nd.unwrap().getDeclaringNodeType())) continue;
                iter.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nodeTypeUnregistered(Name ntName) {
        Iterator iter;
        this.ntCache.remove(ntName);
        Map map = this.pdCache;
        synchronized (map) {
            iter = this.pdCache.values().iterator();
            while (iter.hasNext()) {
                PropertyDefinitionImpl pd = (PropertyDefinitionImpl)iter.next();
                if (!ntName.equals(pd.unwrap().getDeclaringNodeType())) continue;
                iter.remove();
            }
        }
        map = this.ndCache;
        synchronized (map) {
            iter = this.ndCache.values().iterator();
            while (iter.hasNext()) {
                NodeDefinitionImpl nd = (NodeDefinitionImpl)iter.next();
                if (!ntName.equals(nd.unwrap().getDeclaringNodeType())) continue;
                iter.remove();
            }
        }
    }

    public NodeTypeIterator getAllNodeTypes() throws RepositoryException {
        Name[] ntNames = this.ntReg.getRegisteredNodeTypes();
        ArrayList<NodeTypeImpl> list = new ArrayList<NodeTypeImpl>(ntNames.length);
        for (int i = 0; i < ntNames.length; ++i) {
            list.add(this.getNodeType(ntNames[i]));
        }
        return new NodeTypeIteratorAdapter(list);
    }

    public NodeTypeIterator getPrimaryNodeTypes() throws RepositoryException {
        Name[] ntNames = this.ntReg.getRegisteredNodeTypes();
        ArrayList<NodeTypeImpl> list = new ArrayList<NodeTypeImpl>(ntNames.length);
        for (int i = 0; i < ntNames.length; ++i) {
            NodeTypeImpl nt = this.getNodeType(ntNames[i]);
            if (nt.isMixin()) continue;
            list.add(nt);
        }
        return new NodeTypeIteratorAdapter(list);
    }

    public NodeTypeIterator getMixinNodeTypes() throws RepositoryException {
        Name[] ntNames = this.ntReg.getRegisteredNodeTypes();
        ArrayList<NodeTypeImpl> list = new ArrayList<NodeTypeImpl>(ntNames.length);
        for (int i = 0; i < ntNames.length; ++i) {
            NodeTypeImpl nt = this.getNodeType(ntNames[i]);
            if (!nt.isMixin()) continue;
            list.add(nt);
        }
        return new NodeTypeIteratorAdapter(list);
    }

    public NodeType getNodeType(String nodeTypeName) throws NoSuchNodeTypeException {
        try {
            return this.getNodeType(this.session.getQName(nodeTypeName));
        }
        catch (NameException e) {
            throw new NoSuchNodeTypeException(nodeTypeName, (Throwable)e);
        }
        catch (NamespaceException e) {
            throw new NoSuchNodeTypeException(nodeTypeName, (Throwable)e);
        }
    }

    private Collection registerNodeTypes(List defs) throws InvalidNodeTypeDefException, RepositoryException {
        this.ntReg.registerNodeTypes(defs);
        HashSet<NodeTypeImpl> types = new HashSet<NodeTypeImpl>();
        Iterator iterator = defs.iterator();
        while (iterator.hasNext()) {
            try {
                NodeTypeDef def = (NodeTypeDef)iterator.next();
                types.add(this.getNodeType(def.getName()));
            }
            catch (NoSuchNodeTypeException e) {}
        }
        return types;
    }

    public NodeType[] registerNodeTypes(InputSource in) throws SAXException, RepositoryException {
        try {
            return this.registerNodeTypes(in.getByteStream(), "text/xml");
        }
        catch (IOException e) {
            throw new SAXException("Error reading node type stream", e);
        }
    }

    public NodeType[] registerNodeTypes(InputStream in, String contentType) throws IOException, RepositoryException {
        return this.registerNodeTypes(in, contentType, false);
    }

    public boolean hasNodeType(String name) throws RepositoryException {
        try {
            Name qname = this.session.getQName(name);
            return this.getNodeTypeRegistry().isRegistered(qname);
        }
        catch (NamespaceException e) {
            return false;
        }
        catch (NameException e) {
            throw new RepositoryException("Invalid name: " + name, (Throwable)e);
        }
    }

    public NodeTypeTemplate createNodeTypeTemplate() throws UnsupportedRepositoryOperationException, RepositoryException {
        return new NodeTypeTemplateImpl();
    }

    public NodeTypeTemplate createNodeTypeTemplate(NodeTypeDefinition ntd) throws UnsupportedRepositoryOperationException, RepositoryException {
        return new NodeTypeTemplateImpl(ntd);
    }

    public NodeDefinitionTemplate createNodeDefinitionTemplate() throws UnsupportedRepositoryOperationException, RepositoryException {
        return new NodeDefinitionTemplateImpl(this);
    }

    public PropertyDefinitionTemplate createPropertyDefinitionTemplate() throws UnsupportedRepositoryOperationException, RepositoryException {
        return new PropertyDefinitionTemplateImpl();
    }

    public NodeType registerNodeType(NodeTypeDefinition ntd, boolean allowUpdate) throws InvalidNodeTypeDefinitionException, NodeTypeExistsException, UnsupportedRepositoryOperationException, RepositoryException {
        HashSet<NodeTypeDefinition> defs = new HashSet<NodeTypeDefinition>();
        defs.add(ntd);
        return (NodeType)this.registerNodeTypes(defs, allowUpdate).next();
    }

    public NodeTypeIterator registerNodeTypes(Collection definitions, boolean allowUpdate) throws InvalidNodeTypeDefinitionException, NodeTypeExistsException, UnsupportedRepositoryOperationException, RepositoryException {
        ArrayList<NodeTypeDef> addedDefs = new ArrayList<NodeTypeDef>();
        ArrayList<NodeTypeDef> modifiedDefs = new ArrayList<NodeTypeDef>();
        Iterator iter = definitions.iterator();
        while (iter.hasNext()) {
            NodeTypeDefinition definition = (NodeTypeDefinition)iter.next();
            NodeTypeDef def = this.toNodeTypeDef(definition);
            if (this.ntReg.isRegistered(def.getName())) {
                if (allowUpdate) {
                    modifiedDefs.add(def);
                    continue;
                }
                throw new NodeTypeExistsException(definition.getName());
            }
            addedDefs.add(def);
        }
        try {
            ArrayList<NodeTypeImpl> result = new ArrayList<NodeTypeImpl>();
            result.addAll(this.registerNodeTypes(addedDefs));
            Iterator iter2 = modifiedDefs.iterator();
            while (iter2.hasNext()) {
                NodeTypeDef nodeTypeDef = (NodeTypeDef)iter2.next();
                this.ntReg.reregisterNodeType(nodeTypeDef);
                result.add(this.getNodeType(nodeTypeDef.getName()));
            }
            return new NodeTypeIteratorAdapter(result);
        }
        catch (InvalidNodeTypeDefException e) {
            throw new InvalidNodeTypeDefinitionException(e.getMessage(), (Throwable)e);
        }
    }

    public void unregisterNodeType(String name) throws UnsupportedRepositoryOperationException, NoSuchNodeTypeException, RepositoryException {
        this.unregisterNodeTypes(new String[]{name});
    }

    public void unregisterNodeTypes(String[] names) throws UnsupportedRepositoryOperationException, NoSuchNodeTypeException, RepositoryException {
        HashSet<Name> ntNames = new HashSet<Name>();
        for (int i = 0; i < names.length; ++i) {
            try {
                ntNames.add(this.session.getQName(names[i]));
                continue;
            }
            catch (NamespaceException e) {
                throw new RepositoryException("Invalid name: " + names[i], (Throwable)e);
            }
            catch (NameException e) {
                throw new RepositoryException("Invalid name: " + names[i], (Throwable)e);
            }
        }
        this.getNodeTypeRegistry().unregisterNodeTypes(ntNames);
    }

    private NodeTypeDef toNodeTypeDef(NodeTypeDefinition definition) throws InvalidNodeTypeDefinitionException, RepositoryException {
        PropertyDefinition[] pdefs;
        NodeTypeDef def = new NodeTypeDef();
        String name = definition.getName();
        if (name == null) {
            throw new InvalidNodeTypeDefinitionException("No node type name specified");
        }
        try {
            def.setName(this.session.getQName(name));
        }
        catch (NamespaceException e) {
            throw new InvalidNodeTypeDefinitionException("Invalid name: " + name, (Throwable)e);
        }
        catch (NameException e) {
            throw new InvalidNodeTypeDefinitionException("Invalid name: " + name, (Throwable)e);
        }
        String[] names = definition.getDeclaredSupertypeNames();
        Name[] qnames = new Name[names.length];
        for (int i = 0; i < names.length; ++i) {
            try {
                qnames[i] = this.session.getQName(names[i]);
                continue;
            }
            catch (NamespaceException e) {
                throw new InvalidNodeTypeDefinitionException("Invalid supertype name: " + names[i], (Throwable)e);
            }
            catch (NameException e) {
                throw new InvalidNodeTypeDefinitionException("Invalid supertype name: " + names[i], (Throwable)e);
            }
        }
        def.setSupertypes(qnames);
        name = definition.getPrimaryItemName();
        if (name != null) {
            try {
                def.setPrimaryItemName(this.session.getQName(name));
            }
            catch (NamespaceException e) {
                throw new InvalidNodeTypeDefinitionException("Invalid primary item name: " + name, (Throwable)e);
            }
            catch (NameException e) {
                throw new InvalidNodeTypeDefinitionException("Invalid primary item name: " + name, (Throwable)e);
            }
        }
        def.setMixin(definition.isMixin());
        def.setAbstract(definition.isAbstract());
        def.setOrderableChildNodes(definition.hasOrderableChildNodes());
        NodeDefinition[] ndefs = definition.getDeclaredChildNodeDefinitions();
        if (ndefs != null) {
            NodeDef[] qndefs = new NodeDef[ndefs.length];
            for (int i = 0; i < ndefs.length; ++i) {
                NodeDefImpl qndef = new NodeDefImpl();
                qndef.setDeclaringNodeType(def.getName());
                name = ndefs[i].getName();
                if (name != null) {
                    if (name.equals("*")) {
                        qndef.setName(ItemDef.ANY_NAME);
                    } else {
                        try {
                            qndef.setName(this.session.getQName(name));
                        }
                        catch (NamespaceException e) {
                            throw new InvalidNodeTypeDefinitionException("Invalid node name: " + name, (Throwable)e);
                        }
                        catch (NameException e) {
                            throw new InvalidNodeTypeDefinitionException("Invalid node name: " + name, (Throwable)e);
                        }
                    }
                }
                if ((name = ((NodeDefinitionTemplateImpl)ndefs[i]).getDefaultPrimaryTypeName()) != null) {
                    try {
                        qndef.setDefaultPrimaryType(this.session.getQName(name));
                    }
                    catch (NamespaceException e) {
                        throw new InvalidNodeTypeDefinitionException("Invalid default primary type: " + name, (Throwable)e);
                    }
                    catch (NameException e) {
                        throw new InvalidNodeTypeDefinitionException("Invalid default primary type: " + name, (Throwable)e);
                    }
                }
                names = ((NodeDefinitionTemplateImpl)ndefs[i]).getRequiredPrimaryTypeNames();
                qnames = new Name[names.length];
                for (int j = 0; j < names.length; ++j) {
                    try {
                        qnames[j] = this.session.getQName(names[j]);
                        continue;
                    }
                    catch (NamespaceException e) {
                        throw new InvalidNodeTypeDefinitionException("Invalid required primary type: " + names[j], (Throwable)e);
                    }
                    catch (NameException e) {
                        throw new InvalidNodeTypeDefinitionException("Invalid required primary type: " + names[j], (Throwable)e);
                    }
                }
                qndef.setRequiredPrimaryTypes(qnames);
                qndef.setAutoCreated(ndefs[i].isAutoCreated());
                qndef.setMandatory(ndefs[i].isMandatory());
                qndef.setProtected(ndefs[i].isProtected());
                qndef.setOnParentVersion(ndefs[i].getOnParentVersion());
                qndef.setAllowsSameNameSiblings(ndefs[i].allowsSameNameSiblings());
                qndefs[i] = qndef;
            }
            def.setChildNodeDefs(qndefs);
        }
        if ((pdefs = definition.getDeclaredPropertyDefinitions()) != null) {
            PropDef[] qpdefs = new PropDef[pdefs.length];
            for (int i = 0; i < pdefs.length; ++i) {
                Value[] values;
                PropDefImpl qpdef = new PropDefImpl();
                qpdef.setDeclaringNodeType(def.getName());
                name = pdefs[i].getName();
                if (name != null) {
                    if (name.equals("*")) {
                        qpdef.setName(ItemDef.ANY_NAME);
                    } else {
                        try {
                            qpdef.setName(this.session.getQName(name));
                        }
                        catch (NamespaceException e) {
                            throw new InvalidNodeTypeDefinitionException("Invalid property name: " + name, (Throwable)e);
                        }
                        catch (NameException e) {
                            throw new InvalidNodeTypeDefinitionException("Invalid property name: " + name, (Throwable)e);
                        }
                    }
                }
                int type = pdefs[i].getRequiredType();
                qpdef.setRequiredType(type);
                qpdef.setAutoCreated(pdefs[i].isAutoCreated());
                qpdef.setMandatory(pdefs[i].isMandatory());
                qpdef.setProtected(pdefs[i].isProtected());
                qpdef.setOnParentVersion(pdefs[i].getOnParentVersion());
                qpdef.setMultiple(pdefs[i].isMultiple());
                String[] constraints = pdefs[i].getValueConstraints();
                if (constraints != null) {
                    ValueConstraint[] qconstraints = new ValueConstraint[constraints.length];
                    for (int j = 0; j < constraints.length; ++j) {
                        try {
                            qconstraints[j] = ValueConstraint.create(type, constraints[j], this.session);
                            continue;
                        }
                        catch (InvalidConstraintException e) {
                            throw new InvalidNodeTypeDefinitionException("Invalid value constraint " + constraints[i], (Throwable)e);
                        }
                    }
                    qpdef.setValueConstraints(qconstraints);
                }
                if ((values = pdefs[i].getDefaultValues()) != null) {
                    InternalValue[] qvalues = new InternalValue[values.length];
                    for (int j = 0; j < values.length; ++j) {
                        try {
                            qvalues[j] = InternalValue.create(values[j], this.session);
                            continue;
                        }
                        catch (ValueFormatException e) {
                            throw new InvalidNodeTypeDefinitionException("Invalid default value format", (Throwable)e);
                        }
                    }
                    qpdef.setDefaultValues(qvalues);
                }
                qpdefs[i] = qpdef;
            }
            def.setPropertyDefs(qpdefs);
        }
        return def;
    }

    public void dump(PrintStream ps) {
        ps.println("NodeTypeManager (" + this + ")");
        ps.println();
        this.ntReg.dump(ps);
    }
}

