/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.authorization.acl;

import java.security.Principal;
import java.security.acl.Group;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import org.apache.commons.collections.map.ListOrderedMap;
import org.apache.jackrabbit.api.jsr283.security.AccessControlEntry;
import org.apache.jackrabbit.api.jsr283.security.AccessControlException;
import org.apache.jackrabbit.api.jsr283.security.AccessControlManager;
import org.apache.jackrabbit.api.jsr283.security.Privilege;
import org.apache.jackrabbit.api.security.principal.NoSuchPrincipalException;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.security.authorization.AccessControlConstants;
import org.apache.jackrabbit.core.security.authorization.AccessControlEntryImpl;
import org.apache.jackrabbit.core.security.authorization.JackrabbitAccessControlList;
import org.apache.jackrabbit.core.security.authorization.Permission;
import org.apache.jackrabbit.core.security.authorization.PrivilegeRegistry;
import org.apache.jackrabbit.core.security.principal.PrincipalImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ACLTemplate
implements JackrabbitAccessControlList {
    private static final Logger log = LoggerFactory.getLogger((Class)ACLTemplate.class);
    private final String path;
    private final Map entries = new ListOrderedMap();
    private final PrincipalManager principalMgr;
    private final PrivilegeRegistry privilegeRegistry;
    private final ValueFactory valueFactory;

    ACLTemplate(String path, PrincipalManager principalMgr, PrivilegeRegistry privilegeRegistry, ValueFactory valueFactory) {
        this.path = path;
        this.principalMgr = principalMgr;
        this.privilegeRegistry = privilegeRegistry;
        this.valueFactory = valueFactory;
    }

    ACLTemplate(NodeImpl aclNode, PrivilegeRegistry privilegeRegistry) throws RepositoryException {
        if (aclNode == null || !aclNode.isNodeType(AccessControlConstants.NT_REP_ACL)) {
            throw new IllegalArgumentException("Node must be of type 'rep:ACL'");
        }
        SessionImpl sImpl = (SessionImpl)aclNode.getSession();
        this.path = aclNode.getParent().getPath();
        this.principalMgr = sImpl.getPrincipalManager();
        this.valueFactory = sImpl.getValueFactory();
        this.privilegeRegistry = privilegeRegistry;
        AccessControlManager acMgr = sImpl.getAccessControlManager();
        NodeIterator itr = aclNode.getNodes();
        while (itr.hasNext()) {
            NodeImpl aceNode = (NodeImpl)itr.nextNode();
            try {
                String principalName = aceNode.getProperty(AccessControlConstants.P_PRINCIPAL_NAME).getString();
                Principal princ = null;
                if (this.principalMgr.hasPrincipal(principalName)) {
                    try {
                        princ = this.principalMgr.getPrincipal(principalName);
                    }
                    catch (NoSuchPrincipalException e) {
                        // empty catch block
                    }
                }
                if (princ == null) {
                    log.debug("Principal with name " + principalName + " unknown to PrincipalManager.");
                    princ = new PrincipalImpl(principalName);
                }
                Value[] privValues = aceNode.getProperty(AccessControlConstants.P_PRIVILEGES).getValues();
                Privilege[] privs = new Privilege[privValues.length];
                for (int i = 0; i < privValues.length; ++i) {
                    privs[i] = acMgr.privilegeFromName(privValues[i].getString());
                }
                Entry ace = new Entry(princ, privs, aceNode.isNodeType(AccessControlConstants.NT_REP_GRANT_ACE), this.valueFactory);
                this.internalAdd(ace);
            }
            catch (RepositoryException e) {
                log.debug("Failed to build ACE from content.", (Object)e.getMessage());
            }
        }
    }

    static void collectEntries(NodeImpl aclNode, Map princToEntries) throws RepositoryException {
        SessionImpl sImpl = (SessionImpl)aclNode.getSession();
        PrincipalManager principalMgr = sImpl.getPrincipalManager();
        AccessControlManager acMgr = sImpl.getAccessControlManager();
        NodeIterator itr = aclNode.getNodes();
        while (itr.hasNext()) {
            NodeImpl aceNode = (NodeImpl)itr.nextNode();
            String principalName = aceNode.getProperty(AccessControlConstants.P_PRINCIPAL_NAME).getString();
            if (!princToEntries.containsKey(principalName)) continue;
            Principal princ = null;
            if (principalMgr.hasPrincipal(principalName)) {
                try {
                    princ = principalMgr.getPrincipal(principalName);
                }
                catch (NoSuchPrincipalException e) {
                    // empty catch block
                }
            }
            if (princ == null) {
                log.warn("Principal with name " + principalName + " unknown to PrincipalManager.");
                princ = new PrincipalImpl(principalName);
            }
            Value[] privValues = aceNode.getProperty(AccessControlConstants.P_PRIVILEGES).getValues();
            Privilege[] privs = new Privilege[privValues.length];
            for (int i = 0; i < privValues.length; ++i) {
                privs[i] = acMgr.privilegeFromName(privValues[i].getString());
            }
            Entry ace = new Entry(princ, privs, aceNode.isNodeType(AccessControlConstants.NT_REP_GRANT_ACE), sImpl.getValueFactory());
            ((List)princToEntries.get(principalName)).add(ace);
        }
    }

    private List internalGetEntries() {
        ArrayList l = new ArrayList();
        Iterator it = this.entries.values().iterator();
        while (it.hasNext()) {
            l.addAll((List)it.next());
        }
        return l;
    }

    private List internalGetEntries(Principal principal) {
        String principalName = principal.getName();
        if (this.entries.containsKey(principalName)) {
            return (List)this.entries.get(principalName);
        }
        return new ArrayList(2);
    }

    private synchronized boolean internalAdd(Entry entry) throws AccessControlException {
        Principal principal = entry.getPrincipal();
        List l = this.internalGetEntries(principal);
        if (l.isEmpty()) {
            l.add(entry);
            this.entries.put(principal.getName(), l);
            return true;
        }
        if (l.contains(entry)) {
            return false;
        }
        AccessControlEntryImpl complementEntry = null;
        Entry[] entries = l.toArray(new Entry[l.size()]);
        for (int i = 0; i < entries.length; ++i) {
            if (entry.isAllow() == entries[i].isAllow()) {
                int existingPrivs = entries[i].getPrivilegeBits();
                if ((existingPrivs | ~entry.getPrivilegeBits()) == -1) {
                    return false;
                }
                l.remove(i);
                int mergedBits = entries[i].getPrivilegeBits() | entry.getPrivilegeBits();
                Privilege[] mergedPrivs = this.privilegeRegistry.getPrivileges(mergedBits);
                entry = new Entry(entry.getPrincipal(), mergedPrivs, entry.isAllow(), this.valueFactory);
                continue;
            }
            complementEntry = entries[i];
        }
        if (complementEntry != null) {
            int complPrivs = complementEntry.getPrivilegeBits();
            int resultPrivs = Permission.diff(complPrivs, entry.getPrivilegeBits());
            if (resultPrivs == 0) {
                l.remove(complementEntry);
            } else if (resultPrivs != complPrivs) {
                l.remove(complementEntry);
                Entry tmpl = new Entry(entry.getPrincipal(), this.privilegeRegistry.getPrivileges(resultPrivs), !entry.isAllow(), this.valueFactory);
                l.add(tmpl);
            }
        }
        l.add(entry);
        return true;
    }

    private void checkValidEntry(Principal principal, Privilege[] privileges, boolean isAllow) throws AccessControlException {
        if (!this.principalMgr.hasPrincipal(principal.getName())) {
            throw new AccessControlException("Principal " + principal.getName() + " does not exist.");
        }
        if (!isAllow && principal instanceof Group) {
            throw new AccessControlException("For group principals permissions can only be added but not denied.");
        }
    }

    public AccessControlEntry[] getAccessControlEntries() throws RepositoryException {
        List l = this.internalGetEntries();
        return l.toArray(new AccessControlEntry[l.size()]);
    }

    public boolean addAccessControlEntry(Principal principal, Privilege[] privileges) throws AccessControlException, RepositoryException {
        return this.addEntry(principal, privileges, true, Collections.EMPTY_MAP);
    }

    public synchronized void removeAccessControlEntry(AccessControlEntry ace) throws AccessControlException, RepositoryException {
        if (!(ace instanceof Entry)) {
            throw new AccessControlException("Invalid AccessControlEntry implementation " + ace.getClass().getName() + ".");
        }
        List l = this.internalGetEntries(ace.getPrincipal());
        if (l.remove(ace)) {
            if (l.isEmpty()) {
                this.entries.remove(ace.getPrincipal().getName());
            }
        } else {
            throw new AccessControlException("AccessControlEntry " + ace + " cannot be removed from ACL defined at " + this.getPath());
        }
    }

    public String getPath() {
        return this.path;
    }

    public String[] getRestrictionNames() {
        return new String[0];
    }

    public int getRestrictionType(String restrictionName) {
        return 0;
    }

    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    public int size() {
        return this.internalGetEntries().size();
    }

    public boolean addEntry(Principal principal, Privilege[] privileges, boolean isAllow) throws AccessControlException, RepositoryException {
        return this.addEntry(principal, privileges, isAllow, null);
    }

    public boolean addEntry(Principal principal, Privilege[] privileges, boolean isAllow, Map restrictions) throws AccessControlException, RepositoryException {
        if (restrictions != null && !restrictions.isEmpty()) {
            throw new AccessControlException("This AccessControlList does not allow for additional restrictions.");
        }
        this.checkValidEntry(principal, privileges, isAllow);
        Entry ace = new Entry(principal, privileges, isAllow, this.valueFactory);
        return this.internalAdd(ace);
    }

    public int hashCode() {
        return 0;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ACLTemplate) {
            ACLTemplate acl = (ACLTemplate)obj;
            return this.path.equals(acl.path) && ((Object)this.entries).equals(acl.entries);
        }
        return false;
    }

    static class Entry
    extends AccessControlEntryImpl {
        Entry(Principal principal, Privilege[] privileges, boolean allow, ValueFactory valueFactory) throws AccessControlException {
            super(principal, privileges, allow, Collections.EMPTY_MAP, valueFactory);
        }
    }
}

