/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.authorization.combined;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.api.jsr283.security.AccessControlException;
import org.apache.jackrabbit.api.jsr283.security.AccessControlPolicy;
import org.apache.jackrabbit.core.security.authorization.AccessControlEditor;
import org.apache.jackrabbit.core.security.authorization.JackrabbitAccessControlPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CombinedEditor
implements AccessControlEditor {
    private static Logger log = LoggerFactory.getLogger((Class)CombinedEditor.class);
    private final AccessControlEditor[] editors;

    CombinedEditor(AccessControlEditor[] editors) {
        this.editors = editors;
    }

    public AccessControlPolicy[] getPolicies(String nodePath) throws AccessControlException, PathNotFoundException, RepositoryException {
        ArrayList<AccessControlPolicy> templates = new ArrayList<AccessControlPolicy>(this.editors.length);
        for (int i = 0; i < this.editors.length; ++i) {
            AccessControlPolicy[] ts = this.editors[i].getPolicies(nodePath);
            if (ts.length <= 0) continue;
            templates.addAll(Arrays.asList(ts));
        }
        return templates.toArray(new AccessControlPolicy[templates.size()]);
    }

    public AccessControlPolicy[] editAccessControlPolicies(String nodePath) throws AccessControlException, PathNotFoundException, RepositoryException {
        ArrayList<AccessControlPolicy> templates = new ArrayList<AccessControlPolicy>(this.editors.length);
        for (int i = 0; i < this.editors.length; ++i) {
            try {
                templates.addAll(Arrays.asList(this.editors[i].editAccessControlPolicies(nodePath)));
                continue;
            }
            catch (AccessControlException e) {
                log.debug(e.getMessage());
            }
        }
        return templates.toArray(new AccessControlPolicy[templates.size()]);
    }

    public JackrabbitAccessControlPolicy[] editAccessControlPolicies(Principal principal) throws RepositoryException {
        ArrayList<JackrabbitAccessControlPolicy> templates = new ArrayList<JackrabbitAccessControlPolicy>();
        for (int i = 0; i < this.editors.length; ++i) {
            try {
                templates.addAll(Arrays.asList(this.editors[i].editAccessControlPolicies(principal)));
                continue;
            }
            catch (AccessControlException e) {
                log.debug(e.getMessage());
            }
        }
        return templates.toArray(new JackrabbitAccessControlPolicy[templates.size()]);
    }

    public void setPolicy(String nodePath, AccessControlPolicy template) throws AccessControlException, PathNotFoundException, RepositoryException {
        for (int i = 0; i < this.editors.length; ++i) {
            try {
                this.editors[i].setPolicy(nodePath, template);
                log.debug("Set template " + template + " using " + this.editors[i]);
                return;
            }
            catch (AccessControlException e) {
                log.debug(e.getMessage());
                continue;
            }
        }
        throw new AccessControlException("None of the editors accepted policy " + template + " at " + nodePath);
    }

    public void removePolicy(String nodePath, AccessControlPolicy policy) throws AccessControlException, PathNotFoundException, RepositoryException {
        for (int i = 0; i < this.editors.length; ++i) {
            try {
                this.editors[i].removePolicy(nodePath, policy);
                log.debug("Removed template " + policy + " using " + this.editors[i]);
                return;
            }
            catch (AccessControlException e) {
                log.debug(e.getMessage());
                continue;
            }
        }
        throw new AccessControlException("Unable to remove template " + policy);
    }
}

