/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.value;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.jcr.RepositoryException;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.core.data.LazyFileInputStream;
import org.apache.jackrabbit.core.value.BLOBFileValue;
import org.apache.jackrabbit.util.TransientFileFactory;

public class BLOBInTempFile
extends BLOBFileValue {
    private static final String PREFIX = "file:";
    private File file;
    private long length;
    private final boolean temp;

    private BLOBInTempFile(InputStream in, boolean temp) throws RepositoryException {
        this.temp = temp;
        OutputStream out = null;
        try {
            TransientFileFactory fileFactory = TransientFileFactory.getInstance();
            this.file = fileFactory.createTransientFile("bin", null, null);
            out = new FileOutputStream(this.file);
            this.length = IOUtils.copyLarge((InputStream)in, (OutputStream)out);
        }
        catch (IOException e) {
            throw new RepositoryException("Error creating temporary file", (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    throw new RepositoryException("Error creating temporary file", (Throwable)e);
                }
            }
        }
    }

    private BLOBInTempFile(File file, boolean temp) {
        this.file = file;
        this.length = file.length();
        this.temp = temp;
    }

    static BLOBInTempFile getInstance(InputStream in, boolean temp) throws RepositoryException {
        return new BLOBInTempFile(in, temp);
    }

    static BLOBInTempFile getInstance(File file, boolean temp) throws IOException {
        return new BLOBInTempFile(file, temp);
    }

    public void delete(boolean pruneEmptyParentDirs) {
        this.file.delete();
        this.length = -1L;
        this.file = null;
    }

    public void discard() {
        if (this.temp) {
            this.delete(true);
        }
    }

    public boolean isImmutable() {
        return false;
    }

    public long getLength() {
        return this.length;
    }

    public InputStream getStream() throws IllegalStateException, RepositoryException {
        try {
            return new LazyFileInputStream(this.file);
        }
        catch (FileNotFoundException fnfe) {
            throw new RepositoryException("file backing binary value not found", (Throwable)fnfe);
        }
    }

    public String toString() {
        return PREFIX + this.file.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BLOBInTempFile) {
            BLOBInTempFile other = (BLOBInTempFile)obj;
            return this.file == other.file || this.length == other.length && this.file != null && this.file.equals(other.file);
        }
        return false;
    }

    public int hashCode() {
        return 0;
    }

    public boolean isSmall() {
        return false;
    }
}

